/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.samples;

import org.chocosolver.samples.SlaveProblem;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.thread.AbstractParallelMaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterProblem
extends AbstractParallelMaster<SlaveProblem> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(MasterProblem.class);
    int bestVal;
    int nbSol;
    boolean closeWithSuccess;
    ResolutionPolicy policy;

    public MasterProblem(String probClassName, int nbThreads) {
        this.slaves = new SlaveProblem[nbThreads];
        for (int i = 0; i < nbThreads; ++i) {
            ((SlaveProblem[])this.slaves)[i] = new SlaveProblem(probClassName, this, i);
            ((SlaveProblem[])this.slaves)[i].workInParallel();
        }
        this.wait = true;
        try {
            while (this.wait) {
                Thread.sleep(20L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    @Override
    public synchronized void wishGranted() {
        if (LOGGER.isInfoEnabled()) {
            if (this.nbSol == 0) {
                if (!this.closeWithSuccess) {
                    LOGGER.info("=====UNKNOWN=====");
                } else {
                    LOGGER.info("=====UNSATISFIABLE=====");
                }
            } else if (!this.closeWithSuccess && this.policy != null && this.policy != ResolutionPolicy.SATISFACTION) {
                LOGGER.info("=====UNBOUNDED=====");
            } else {
                LOGGER.info("==========");
            }
        }
        Number[] nbs = ((SlaveProblem[])this.slaves)[0].solver.getMeasures().toArray();
        nbs[0] = this.nbSol;
        nbs[5] = this.policy != ResolutionPolicy.SATISFACTION ? this.bestVal : 0;
        System.exit(0);
    }

    public synchronized boolean newSol(int val, ResolutionPolicy policy) {
        this.policy = policy;
        if (this.nbSol == 0) {
            this.bestVal = val;
        }
        ++this.nbSol;
        boolean isBetter = false;
        switch (policy) {
            case MINIMIZE: {
                if (this.bestVal <= val && this.nbSol != 1) break;
                this.bestVal = val;
                isBetter = true;
                break;
            }
            case MAXIMIZE: {
                if (this.bestVal >= val && this.nbSol != 1) break;
                this.bestVal = val;
                isBetter = true;
                break;
            }
            case SATISFACTION: {
                this.bestVal = 1;
                boolean bl = isBetter = this.nbSol == 1;
            }
        }
        if (isBetter) {
            for (int i = 0; i < ((SlaveProblem[])this.slaves).length; ++i) {
                if (((SlaveProblem[])this.slaves)[i] == null) continue;
                ((SlaveProblem[])this.slaves)[i].findBetterThan(val, policy);
            }
        }
        return isBetter;
    }

    public synchronized void closeWithSuccess() {
        this.closeWithSuccess = true;
    }
}

