/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.samples;

import org.chocosolver.samples.AbstractProblem;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.propagation.hardcoded.TwoBucketPropagationEngine;
import org.chocosolver.solver.trace.Chatterbox;

public abstract class ParallelizedProblem
extends AbstractProblem {
    protected int searchIdx;

    public ParallelizedProblem(int searchIdx) {
        this.searchIdx = searchIdx;
        this.printDescription();
        this.createSolver();
        this.buildModel();
        this.configureSearch();
        this.overrideExplanation();
        this.solver.set(new TwoBucketPropagationEngine(this.solver));
        if (this.level.getLevel() > AbstractProblem.Level.SILENT.getLevel()) {
            Chatterbox.showStatistics(this.solver);
            if (this.level.getLevel() > AbstractProblem.Level.VERBOSE.getLevel()) {
                Chatterbox.showSolutions(this.solver);
            }
            if (this.level.getLevel() > AbstractProblem.Level.SOLUTION.getLevel()) {
                Chatterbox.showDecisions(this.solver);
            }
        }
    }

    @Override
    public void createSolver() {
        this.solver = new Solver();
    }
}

