/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.samples;

import java.lang.reflect.InvocationTargetException;
import org.chocosolver.samples.MasterProblem;
import org.chocosolver.samples.ParallelizedProblem;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.objective.ObjectiveManager;
import org.chocosolver.solver.thread.AbstractParallelSlave;

public class SlaveProblem
extends AbstractParallelSlave<MasterProblem> {
    Solver solver;
    ParallelizedProblem model;

    public SlaveProblem(String probClassName, MasterProblem master, int id) {
        super(master, id);
        try {
            this.model = (ParallelizedProblem)Class.forName(probClassName).getDeclaredConstructors()[0].newInstance(id);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void work() {
        try {
            this.solver = this.model.getSolver();
            this.solver.plugMonitor(() -> {
                ObjectiveManager om = this.solver.getSearchLoop().getObjectiveManager();
                int val = om.getPolicy() == ResolutionPolicy.SATISFACTION ? 1 : ((Number)om.getBestSolutionValue()).intValue();
                ((MasterProblem)this.master).newSol(val, om.getPolicy());
            });
            this.model.solve();
            if (!this.solver.hasReachedLimit()) {
                ((MasterProblem)this.master).closeWithSuccess();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void findBetterThan(int val, ResolutionPolicy policy) {
        if (this.solver == null) {
            return;
        }
        ObjectiveManager iom = this.solver.getSearchLoop().getObjectiveManager();
        if (iom == null) {
            return;
        }
        switch (policy) {
            case MAXIMIZE: {
                iom.updateBestLB(val);
                break;
            }
            case MINIMIZE: {
                iom.updateBestUB(val);
                break;
            }
        }
    }
}

