/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver;

import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Settings;
import org.chocosolver.solver.SlaveSolver;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.thread.AbstractParallelMaster;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.ESat;

public class MasterSolver
extends AbstractParallelMaster<SlaveSolver> {
    protected Solver[] solvers = new Solver[0];
    ESat feasible = ESat.FALSE;
    boolean limit = true;
    ResolutionPolicy policy = ResolutionPolicy.SATISFACTION;
    int nbSolution = 0;
    int bestValue = 0;

    public void populate(Solver model, int n) {
        this.solvers = new Solver[n + 1];
        this.solvers[0] = model;
        for (int i = 1; i < n + 1; ++i) {
            this.solvers[i] = model.duplicateModel();
        }
    }

    public void declare(Solver ... solvers) {
        this.solvers = solvers;
    }

    public Solver[] getSolvers() {
        return this.solvers;
    }

    public void declareSettings(Settings ... settings) {
        assert (settings.length == this.solvers.length);
        for (int i = 0; i < settings.length; ++i) {
            this.solvers[i].set(settings[i]);
        }
    }

    public ESat isFeasible() {
        if (this.nbSolution > 0) {
            return ESat.TRUE;
        }
        if (this.limit) {
            return ESat.UNDEFINED;
        }
        return ESat.FALSE;
    }

    public boolean hasReachedLimit() {
        return this.limit;
    }

    public boolean findSolution() {
        this.policy = ResolutionPolicy.SATISFACTION;
        this.slaves = new SlaveSolver[this.solvers.length];
        for (int i = 0; i < this.solvers.length; ++i) {
            ((SlaveSolver[])this.slaves)[i] = new SlaveSolver(this, i, this.solvers[i]);
        }
        this.distributedSlavery();
        return this.nbSolution > 0;
    }

    public void findOptimalSolution(ResolutionPolicy policy, IntVar objective) {
        this.policy = policy;
        int oidx = MasterSolver.findIndexOfObjective(this.solvers[0], objective);
        if (oidx == this.solvers[0].getNbVars()) {
            throw new SolverException(objective.getName() + " cannot be found in the first solver, as expected");
        }
        this.slaves = new SlaveSolver[this.solvers.length];
        for (int i = 0; i < this.solvers.length; ++i) {
            ((SlaveSolver[])this.slaves)[i] = new SlaveSolver(this, i, this.solvers[i], policy, (IntVar)this.solvers[i].getVar(oidx));
        }
        this.distributedSlavery();
    }

    private static int findIndexOfObjective(Solver solver, IntVar objective) {
        int idx;
        int n = solver.getNbVars();
        int oid = objective.getId();
        for (idx = 0; idx < n && oid != solver.getVar(idx).getId(); ++idx) {
        }
        return idx;
    }

    synchronized boolean onSolution(int val) {
        if (this.nbSolution == 0) {
            this.bestValue = val;
        }
        ++this.nbSolution;
        boolean isBetter = false;
        switch (this.policy) {
            case MINIMIZE: {
                if (this.bestValue <= val && this.nbSolution != 1) break;
                this.bestValue = val;
                isBetter = true;
                break;
            }
            case MAXIMIZE: {
                if (this.bestValue >= val && this.nbSolution != 1) break;
                this.bestValue = val;
                isBetter = true;
                break;
            }
            case SATISFACTION: {
                this.bestValue = 1;
                boolean bl = isBetter = this.nbSolution == 1;
            }
        }
        if (isBetter) {
            for (int i = 0; i < ((SlaveSolver[])this.slaves).length; ++i) {
                if (((SlaveSolver[])this.slaves)[i] == null) continue;
                ((SlaveSolver[])this.slaves)[i].findBetterThan(val, this.policy);
            }
        }
        return isBetter;
    }

    synchronized void closeWithSuccess() {
        this.limit = false;
    }

    @Override
    public synchronized void wishGranted() {
        for (SlaveSolver s : (SlaveSolver[])this.slaves) {
            s.stop();
        }
        super.wishGranted();
    }
}

