/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver;

import org.chocosolver.solver.MasterSolver;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.objective.ObjectiveManager;
import org.chocosolver.solver.thread.AbstractParallelSlave;
import org.chocosolver.solver.variables.IntVar;

public class SlaveSolver
extends AbstractParallelSlave<MasterSolver> {
    Solver solver;
    ResolutionPolicy policy;
    IntVar objective;

    public SlaveSolver(MasterSolver master, int id, Solver solver) {
        this(master, id, solver, ResolutionPolicy.SATISFACTION, null);
    }

    public SlaveSolver(MasterSolver master, int id, Solver solver, ResolutionPolicy policy, IntVar objective) {
        super(master, id);
        this.solver = solver;
        this.policy = policy;
        this.objective = objective;
    }

    @Override
    public void work() {
        this.solver.plugMonitor(() -> {
            ObjectiveManager om = this.solver.getSearchLoop().getObjectiveManager();
            int val = om.getPolicy() == ResolutionPolicy.SATISFACTION ? 1 : ((Number)om.getBestSolutionValue()).intValue();
            ((MasterSolver)this.master).onSolution(val);
        });
        if (this.policy.equals((Object)ResolutionPolicy.SATISFACTION)) {
            this.solver.findSolution();
            if (!this.solver.hasReachedLimit()) {
                ((MasterSolver)this.master).closeWithSuccess();
            }
        } else {
            this.solver.findOptimalSolution(this.policy, this.objective);
            if (!this.solver.hasReachedLimit()) {
                ((MasterSolver)this.master).closeWithSuccess();
            }
        }
    }

    public void findBetterThan(int val, ResolutionPolicy policy) {
        if (this.solver == null) {
            return;
        }
        ObjectiveManager iom = this.solver.getSearchLoop().getObjectiveManager();
        if (iom == null) {
            return;
        }
        switch (policy) {
            case MAXIMIZE: {
                iom.updateBestLB(val);
                break;
            }
            case MINIMIZE: {
                iom.updateBestUB(val);
                break;
            }
        }
    }

    public void stop() {
        this.solver.getSearchLoop().forceAlive(false);
    }
}

