/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.chocosolver.memory.Environments;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.Cause;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Settings;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.cnf.PropFalse;
import org.chocosolver.solver.constraints.nary.cnf.PropTrue;
import org.chocosolver.solver.constraints.nary.cnf.SatConstraint;
import org.chocosolver.solver.constraints.real.Ibex;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.objective.ObjectiveManager;
import org.chocosolver.solver.propagation.IPropagationEngine;
import org.chocosolver.solver.propagation.NoPropagationEngine;
import org.chocosolver.solver.propagation.PropagationEngineFactory;
import org.chocosolver.solver.propagation.PropagationTrigger;
import org.chocosolver.solver.search.loop.ISearchLoop;
import org.chocosolver.solver.search.loop.SearchLoop;
import org.chocosolver.solver.search.loop.monitors.ISearchMonitor;
import org.chocosolver.solver.search.measure.IMeasures;
import org.chocosolver.solver.search.measure.MeasuresRecorder;
import org.chocosolver.solver.search.solution.AllSolutionsRecorder;
import org.chocosolver.solver.search.solution.BestSolutionsRecorder;
import org.chocosolver.solver.search.solution.ISolutionRecorder;
import org.chocosolver.solver.search.solution.LastSolutionRecorder;
import org.chocosolver.solver.search.solution.ParetoSolutionsRecorder;
import org.chocosolver.solver.search.solution.Solution;
import org.chocosolver.solver.search.strategy.ISF;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.VF;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;

public class Solver
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Settings settings = new Settings(){};
    private ExplanationEngine explainer;
    Variable[] vars;
    int vIdx;
    Constraint[] cstrs;
    int cIdx;
    public TIntObjectHashMap<IntVar> cachedConstants;
    final IEnvironment environment;
    protected ISearchLoop search;
    protected IPropagationEngine engine;
    protected final IMeasures measures;
    protected ISolutionRecorder solutionRecorder;
    protected String name;
    ESat feasible = ESat.UNDEFINED;
    protected long creationTime;
    protected int id = 1;
    public final Constraint TRUE;
    public final Constraint FALSE;
    public final BoolVar ZERO;
    public final BoolVar ONE;
    protected SatConstraint minisat;
    private Ibex ibex;

    public Solver(IEnvironment environment, String name) {
        this.name = name;
        this.vars = new Variable[32];
        this.vIdx = 0;
        this.cstrs = new Constraint[32];
        this.cIdx = 0;
        this.environment = environment;
        this.measures = new MeasuresRecorder(this);
        this.search = new SearchLoop(this);
        this.explainer = new ExplanationEngine(this);
        this.creationTime -= System.nanoTime();
        this.cachedConstants = new TIntObjectHashMap(16, 1.5f, Integer.MAX_VALUE);
        this.engine = NoPropagationEngine.SINGLETON;
        this.ZERO = (BoolVar)VF.fixed(0, this);
        this.ONE = (BoolVar)VF.fixed(1, this);
        this.ZERO._setNot(this.ONE);
        this.ONE._setNot(this.ZERO);
        this.TRUE = new Constraint("TRUE cstr", new PropTrue(this.ONE));
        this.FALSE = new Constraint("FALSE cstr", new PropFalse(this.ZERO));
        this.solutionRecorder = new LastSolutionRecorder(new Solution(), false, this);
        this.set(ObjectiveManager.SAT());
    }

    public Solver() {
        this(Environments.DEFAULT.make(), "");
    }

    public Solver(String name) {
        this(Environments.DEFAULT.make(), name);
    }

    public ISearchLoop getSearchLoop() {
        return this.search;
    }

    public ObjectiveManager getObjectiveManager() {
        return this.search.getObjectiveManager();
    }

    public AbstractStrategy getStrategy() {
        return this.search.getStrategy();
    }

    public IPropagationEngine getEngine() {
        return this.engine;
    }

    public Variable[] getVars() {
        return Arrays.copyOf(this.vars, this.vIdx);
    }

    public int getNbVars() {
        return this.vIdx;
    }

    public Variable getVar(int i) {
        return this.vars[i];
    }

    public IntVar[] retrieveIntVars() {
        IntVar[] ivars = new IntVar[this.vIdx];
        int k = 0;
        for (int i = 0; i < this.vIdx; ++i) {
            if ((this.vars[i].getTypeAndKind() & 0xF8) != 8) continue;
            ivars[k++] = (IntVar)this.vars[i];
        }
        return Arrays.copyOf(ivars, k);
    }

    public BoolVar[] retrieveBoolVars() {
        BoolVar[] bvars = new BoolVar[this.vIdx];
        int k = 0;
        for (int i = 0; i < this.vIdx; ++i) {
            if ((this.vars[i].getTypeAndKind() & 0xF8) != 24) continue;
            bvars[k++] = (BoolVar)this.vars[i];
        }
        return Arrays.copyOf(bvars, k);
    }

    public SetVar[] retrieveSetVars() {
        SetVar[] bvars = new SetVar[this.vIdx];
        int k = 0;
        for (int i = 0; i < this.vIdx; ++i) {
            if ((this.vars[i].getTypeAndKind() & 0xF8) != 64) continue;
            bvars[k++] = (SetVar)this.vars[i];
        }
        return Arrays.copyOf(bvars, k);
    }

    public RealVar[] retrieveRealVars() {
        RealVar[] bvars = new RealVar[this.vIdx];
        int k = 0;
        for (int i = 0; i < this.vIdx; ++i) {
            if ((this.vars[i].getTypeAndKind() & 0xF8) != 128) continue;
            bvars[k++] = (RealVar)this.vars[i];
        }
        return Arrays.copyOf(bvars, k);
    }

    public Constraint[] getCstrs() {
        return Arrays.copyOf(this.cstrs, this.cIdx);
    }

    public int getNbCstrs() {
        return this.cIdx;
    }

    public String getName() {
        return this.name;
    }

    public IEnvironment getEnvironment() {
        return this.environment;
    }

    public IMeasures getMeasures() {
        return this.measures;
    }

    public ExplanationEngine getExplainer() {
        return this.explainer;
    }

    public ISolutionRecorder getSolutionRecorder() {
        return this.solutionRecorder;
    }

    public void set(ISearchLoop searchLoop) {
        this.search = searchLoop;
    }

    public void set(AbstractStrategy ... strategies) {
        if (strategies == null || strategies.length == 0) {
            throw new UnsupportedOperationException("no search strategy has been specified");
        }
        if (strategies.length == 1) {
            this.search.set(strategies[0]);
        } else {
            this.search.set(ISF.sequencer(strategies));
        }
    }

    public void set(IPropagationEngine propagationEngine) {
        this.engine = propagationEngine;
    }

    public void set(ExplanationEngine explainer) {
        this.explainer = explainer;
    }

    public void set(ObjectiveManager om) {
        this.search.setObjectiveManager(om);
    }

    public void set(ISolutionRecorder sr) {
        this.solutionRecorder = sr;
    }

    public void plugMonitor(ISearchMonitor sm) {
        this.search.plugSearchMonitor(sm);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void set(Settings defaults) {
        this.settings = defaults;
    }

    public void associates(Variable variable) {
        if (this.vIdx == this.vars.length) {
            Variable[] tmp = this.vars;
            this.vars = new Variable[tmp.length * 2];
            System.arraycopy(tmp, 0, this.vars, 0, this.vIdx);
        }
        this.vars[this.vIdx++] = variable;
    }

    public void unassociates(Variable variable) {
        int idx;
        if (variable.getNbProps() > 0) {
            throw new SolverException("Try to remove a variable (" + variable.getName() + ")which is still involved in at least one constraint");
        }
        for (idx = 0; idx < this.vIdx && variable != this.vars[idx]; ++idx) {
        }
        System.arraycopy(this.vars, idx + 1, this.vars, idx + 1 - 1, this.vIdx - (idx + 1));
        this.vars[--this.vIdx] = null;
    }

    public void post(Constraint c) {
        this._post(true, c);
    }

    public void post(Constraint ... cs) {
        this._post(true, cs);
    }

    public void postTemp(Constraint c) throws ContradictionException {
        this._post(false, c);
        if (this.engine == NoPropagationEngine.SINGLETON || !this.engine.isInitialized()) {
            throw new SolverException("Try to post a temporary constraint while the resolution has not begun.\nA call to Solver.post(Constraint) is more appropriate.");
        }
        for (Propagator propagator : c.getPropagators()) {
            PropagationTrigger.execute(propagator, this.engine);
        }
    }

    private void _post(boolean permanent, Constraint ... cs) {
        boolean dynAdd = false;
        if (this.engine != NoPropagationEngine.SINGLETON && this.engine.isInitialized()) {
            dynAdd = true;
        }
        if (this.cIdx + cs.length >= this.cstrs.length) {
            int nsize;
            for (nsize = this.cstrs.length; this.cIdx + cs.length >= nsize; nsize *= 2) {
            }
            Constraint[] tmp = this.cstrs;
            this.cstrs = new Constraint[nsize];
            System.arraycopy(tmp, 0, this.cstrs, 0, this.cIdx);
        }
        System.arraycopy(cs, 0, this.cstrs, this.cIdx, cs.length);
        this.cIdx += cs.length;
        for (int i = 0; i < cs.length; ++i) {
            if (dynAdd) {
                this.engine.dynamicAddition(cs[i], permanent);
            }
            if (!cs[i].isReified()) continue;
            try {
                cs[i].reif().setToTrue(Cause.Null);
                continue;
            }
            catch (ContradictionException e) {
                throw new SolverException("post a constraint whose reification BoolVar is already set to false: no solution can exist");
            }
        }
    }

    public void unpost(Constraint c) {
        int idx;
        for (idx = 0; idx < this.cIdx && this.cstrs[idx] != c; ++idx) {
        }
        if (idx < this.cIdx) {
            Constraint cm;
            this.cstrs[idx] = cm = this.cstrs[--this.cIdx];
            this.cstrs[this.cIdx] = null;
            if (this.engine != NoPropagationEngine.SINGLETON && this.engine.isInitialized()) {
                this.engine.dynamicDeletion(c);
            }
            for (Propagator prop : c.getPropagators()) {
                for (int v = 0; v < prop.getNbVars(); ++v) {
                    prop.getVar(v).unlink(prop);
                }
            }
        }
    }

    public SatConstraint getMinisat() {
        if (this.minisat == null) {
            this.minisat = new SatConstraint(this);
            this.post((Constraint)this.minisat);
        }
        return this.minisat;
    }

    public ESat isFeasible() {
        return this.feasible;
    }

    public void setFeasible(ESat feasible) {
        this.feasible = feasible;
    }

    public boolean hasReachedLimit() {
        return this.search.hasReachedLimit();
    }

    public boolean findSolution() {
        this.solve(true);
        return this.measures.getSolutionCount() > 0L;
    }

    public boolean nextSolution() {
        long nbsol = this.measures.getSolutionCount();
        this.search.resume();
        return this.measures.getSolutionCount() - nbsol > 0L;
    }

    public long findAllSolutions() {
        this.solve(false);
        return this.measures.getSolutionCount();
    }

    public void findOptimalSolution(ResolutionPolicy policy, IntVar objective) {
        if (policy == ResolutionPolicy.SATISFACTION) {
            throw new SolverException("Solver.findOptimalSolution(...) cannot be called with ResolutionPolicy.SATISFACTION.");
        }
        if (objective == null) {
            throw new SolverException("No objective variable has been defined");
        }
        if (!this.getObjectiveManager().isOptimization()) {
            this.set(new ObjectiveManager(objective, policy, true));
        }
        this.set(new LastSolutionRecorder(new Solution(), true, this));
        this.solve(false);
    }

    public void findAllOptimalSolutions(ResolutionPolicy policy, IntVar objective, boolean twoSteps) {
        if (twoSteps) {
            this.findOptimalSolution(policy, objective);
            if (this.getMeasures().getSolutionCount() > 0L) {
                int opt = ((Number)this.getObjectiveManager().getBestSolutionValue()).intValue();
                this.getEngine().flush();
                this.search.reset();
                this.post(ICF.arithm(objective, "=", opt));
                this.set(new AllSolutionsRecorder(this));
                this.findAllSolutions();
            }
        } else {
            if (policy == ResolutionPolicy.SATISFACTION) {
                throw new SolverException("Solver.findAllOptimalSolutions(...) cannot be called with ResolutionPolicy.SATISFACTION.");
            }
            if (objective == null) {
                throw new SolverException("No objective variable has been defined");
            }
            if (!this.getObjectiveManager().isOptimization()) {
                this.set(new ObjectiveManager(objective, policy, false));
            }
            this.set(new BestSolutionsRecorder(objective));
            this.solve(false);
        }
    }

    public void findParetoFront(ResolutionPolicy policy, IntVar ... objectives) {
        if (policy == ResolutionPolicy.SATISFACTION) {
            throw new SolverException("Solver.findParetoFront(...) cannot be called with ResolutionPolicy.SATISFACTION.");
        }
        if (objectives == null || objectives.length == 0) {
            throw new SolverException("No objective variable has been defined");
        }
        if (objectives.length == 1) {
            throw new SolverException("Only one objective variable has been defined. Pareto is relevant with >1 objective");
        }
        if (this.getObjectiveManager().isOptimization()) {
            this.set(new ObjectiveManager(null, ResolutionPolicy.SATISFACTION, false));
        }
        this.set(new ParetoSolutionsRecorder(policy, objectives));
        this.solve(false);
    }

    public void findOptimalSolution(ResolutionPolicy policy, RealVar objective, double precision) {
        if (policy == ResolutionPolicy.SATISFACTION) {
            throw new SolverException("Solver.findOptimalSolution(...) can not be called with ResolutionPolicy.SATISFACTION.");
        }
        if (objective == null) {
            throw new SolverException("No objective variable has been defined");
        }
        if (!this.getObjectiveManager().isOptimization()) {
            this.set(new ObjectiveManager(objective, policy, precision, true));
        }
        this.set(new LastSolutionRecorder(new Solution(), true, this));
        this.solve(false);
    }

    protected void solve(boolean stopAtFirst) {
        if (this.engine == NoPropagationEngine.SINGLETON) {
            this.set(PropagationEngineFactory.DEFAULT.make(this));
        }
        this.measures.setReadingTimeCount(this.creationTime + System.nanoTime());
        this.search.launch(stopAtFirst);
    }

    public void propagate() throws ContradictionException {
        if (this.engine == NoPropagationEngine.SINGLETON) {
            this.set(PropagationEngineFactory.DEFAULT.make(this));
        }
        this.engine.propagate();
    }

    public ESat isSatisfied() {
        int OK = 0;
        for (int c = 0; c < this.cIdx; ++c) {
            ESat satC = this.cstrs[c].isSatisfied();
            if (ESat.FALSE == satC) {
                System.err.println(String.format("FAILURE >> %s (%s)", new Object[]{this.cstrs[c].toString(), satC}));
                return ESat.FALSE;
            }
            if (ESat.TRUE != satC) continue;
            ++OK;
        }
        if (OK == this.cIdx) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    public String toString() {
        StringBuilder st = new StringBuilder(256);
        st.append(String.format("\n Solver %s\n", this.name));
        st.append(String.format("\n[ %d vars -- %d cstrs ]\n", this.vIdx, this.cIdx));
        st.append(String.format("Feasability: %s\n", new Object[]{this.feasible}));
        st.append("== variables ==\n");
        for (int v = 0; v < this.vIdx; ++v) {
            st.append(this.vars[v].toString()).append('\n');
        }
        st.append("== constraints ==\n");
        for (int c = 0; c < this.cIdx; ++c) {
            st.append(this.cstrs[c].toString()).append('\n');
        }
        return st.toString();
    }

    public static void writeInFile(Solver solver, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        ObjectOutputStream out = new ObjectOutputStream(fos);
        out.writeObject(solver);
        out.close();
    }

    public static File writeInFile(Solver solver) throws IOException {
        File file = File.createTempFile("SOLVER_", ".ser");
        FileOutputStream fos = new FileOutputStream(file);
        ObjectOutputStream out = new ObjectOutputStream(fos);
        out.writeObject(solver);
        out.close();
        return file;
    }

    public static Solver readFromFile(String file) throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(file);
        ObjectInputStream in = new ObjectInputStream(fis);
        Solver model = (Solver)in.readObject();
        in.close();
        return model;
    }

    public Solver duplicateModel() {
        int i;
        Solver clone;
        if (this.environment.getWorldIndex() > 0) {
            throw new SolverException("Duplicating a solver cannot be achieved once the resolution has begun.");
        }
        try {
            clone = new Solver((IEnvironment)this.environment.getClass().newInstance(), this.name);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new SolverException("The current solver cannot be duplicated:\n" + e.getMessage());
        }
        THashMap<Object, Object> identitymap = new THashMap<Object, Object>();
        for (i = 0; i < this.vIdx; ++i) {
            this.vars[i].duplicate(clone, identitymap);
        }
        for (i = 0; i < this.cIdx; ++i) {
            this.cstrs[i].duplicate(clone, identitymap);
            clone.post((Constraint)identitymap.get(this.cstrs[i]));
        }
        return clone;
    }

    public int getNbIdElt() {
        return this.id;
    }

    public int nextId() {
        return this.id++;
    }

    public Ibex getIbex() {
        if (this.ibex == null) {
            this.ibex = new Ibex();
        }
        return this.ibex;
    }
}

