/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.binary.PropEqualXY_C;
import org.chocosolver.solver.constraints.binary.PropEqualX_Y;
import org.chocosolver.solver.constraints.binary.PropEqualX_YC;
import org.chocosolver.solver.constraints.binary.PropGreaterOrEqualXY_C;
import org.chocosolver.solver.constraints.binary.PropGreaterOrEqualX_Y;
import org.chocosolver.solver.constraints.binary.PropGreaterOrEqualX_YC;
import org.chocosolver.solver.constraints.binary.PropLessOrEqualXY_C;
import org.chocosolver.solver.constraints.binary.PropNotEqualXY_C;
import org.chocosolver.solver.constraints.binary.PropNotEqualX_Y;
import org.chocosolver.solver.constraints.binary.PropNotEqualX_YC;
import org.chocosolver.solver.constraints.unary.PropEqualXC;
import org.chocosolver.solver.constraints.unary.PropGreaterOrEqualXC;
import org.chocosolver.solver.constraints.unary.PropLessOrEqualXC;
import org.chocosolver.solver.constraints.unary.PropNotEqualXC;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;

public class Arithmetic
extends Constraint {
    protected final Operator op1;
    protected final Operator op2;
    protected final int cste;
    protected final IntVar[] vars;

    private static boolean isOperation(Operator operator) {
        return operator.equals((Object)Operator.PL) || operator.equals((Object)Operator.MN);
    }

    public Arithmetic(IntVar var, Operator op, int cste) {
        super("ArithmeticUnary", Arithmetic.createProp(var, op, cste));
        this.vars = new IntVar[]{var};
        this.op1 = op;
        this.op2 = Operator.NONE;
        this.cste = cste;
    }

    private static Propagator createProp(IntVar var, Operator op, int cste) {
        switch (op) {
            case EQ: {
                return new PropEqualXC(var, cste);
            }
            case NQ: {
                return new PropNotEqualXC(var, cste);
            }
            case GE: {
                return new PropGreaterOrEqualXC(var, cste);
            }
            case GT: {
                return new PropGreaterOrEqualXC(var, cste + 1);
            }
            case LE: {
                return new PropLessOrEqualXC(var, cste);
            }
            case LT: {
                return new PropLessOrEqualXC(var, cste - 1);
            }
        }
        throw new SolverException("Incorrect formula; operator should be one of those:{=, !=, >=, >, <=, <}");
    }

    public Arithmetic(IntVar var1, Operator op, IntVar var2) {
        super("ArithmeticBinary", Arithmetic.createProp(var1, op, var2));
        this.vars = new IntVar[]{var1, var2};
        this.op1 = op;
        this.op2 = Operator.PL;
        this.cste = 0;
    }

    private static Propagator createProp(IntVar var1, Operator op, IntVar var2) {
        switch (op) {
            case EQ: {
                return new PropEqualX_Y(var1, var2);
            }
            case NQ: {
                return new PropNotEqualX_Y(var1, var2);
            }
            case GE: {
                return new PropGreaterOrEqualX_Y(new IntVar[]{var1, var2});
            }
            case GT: {
                return new PropGreaterOrEqualX_YC(new IntVar[]{var1, var2}, 1);
            }
            case LE: {
                return new PropGreaterOrEqualX_Y(new IntVar[]{var2, var1});
            }
            case LT: {
                return new PropGreaterOrEqualX_YC(new IntVar[]{var2, var1}, 1);
            }
        }
        throw new SolverException("Incorrect formula; operator should be one of those:{=, !=, >=, >, <=, <}");
    }

    public Arithmetic(IntVar var1, Operator op1, IntVar var2, Operator op2, int cste) {
        super("ArithmeticBinary", Arithmetic.createProp(var1, op1, var2, op2, cste));
        this.vars = new IntVar[]{var1, var2};
        this.op1 = op1;
        this.op2 = op2;
        if (Arithmetic.isOperation(op1) == Arithmetic.isOperation(op2)) {
            throw new SolverException("Incorrect formula; operators must be different!");
        }
        this.cste = cste;
    }

    private static Propagator createProp(IntVar var1, Operator op1, IntVar var2, Operator op2, int cste) {
        if (op1 == null) {
            throw new UnsupportedOperationException();
        }
        if (op2 == null) {
            throw new UnsupportedOperationException();
        }
        if (Arithmetic.isOperation(op1) == Arithmetic.isOperation(op2)) {
            throw new SolverException("Incorrect formula; operators must be different!");
        }
        IntVar[] vars = new IntVar[]{var1, var2};
        if (op1 == Operator.PL) {
            switch (op2) {
                case EQ: {
                    return new PropEqualXY_C(vars, cste);
                }
                case NQ: {
                    return new PropNotEqualXY_C(vars, cste);
                }
                case GE: {
                    return new PropGreaterOrEqualXY_C(vars, cste);
                }
                case GT: {
                    return new PropGreaterOrEqualXY_C(vars, cste + 1);
                }
                case LE: {
                    return new PropLessOrEqualXY_C(vars, cste);
                }
                case LT: {
                    return new PropLessOrEqualXY_C(vars, cste - 1);
                }
            }
            throw new SolverException("Incorrect formula; operator should be one of those:{=, !=, >=, >, <=, <}");
        }
        if (op1 == Operator.MN) {
            switch (op2) {
                case EQ: {
                    return new PropEqualX_YC(vars, cste);
                }
                case NQ: {
                    return new PropNotEqualX_YC(vars, cste);
                }
                case GE: {
                    return new PropGreaterOrEqualX_YC(vars, cste);
                }
                case GT: {
                    return new PropGreaterOrEqualX_YC(vars, cste + 1);
                }
                case LE: {
                    return new PropGreaterOrEqualX_YC(new IntVar[]{var2, var1}, -cste);
                }
                case LT: {
                    return new PropGreaterOrEqualX_YC(new IntVar[]{var2, var1}, -cste + 1);
                }
            }
            throw new SolverException("Incorrect formula; operator should be one of those:{=, !=, >=, >, <=, <}");
        }
        int _cste = cste * (op2 == Operator.PL ? 1 : -1);
        switch (op1) {
            case EQ: {
                return new PropEqualX_YC(vars, _cste);
            }
            case NQ: {
                return new PropNotEqualX_YC(vars, _cste);
            }
            case GE: {
                return new PropGreaterOrEqualX_YC(vars, _cste);
            }
            case GT: {
                return new PropGreaterOrEqualX_YC(vars, _cste + 1);
            }
            case LE: {
                return new PropGreaterOrEqualX_YC(new IntVar[]{var2, var1}, -_cste);
            }
            case LT: {
                return new PropGreaterOrEqualX_YC(new IntVar[]{var2, var1}, -_cste + 1);
            }
        }
        throw new SolverException("Incorrect formula; operator should be one of those:{=, !=, >=, >, <=, <}");
    }

    @Override
    public Constraint makeOpposite() {
        if (this.vars.length == 1) {
            return ICF.arithm(this.vars[0], Operator.getOpposite(this.op1).toString(), this.cste);
        }
        assert (this.vars.length == 2);
        if (this.op1 == Operator.PL || this.op1 == Operator.MN) {
            return ICF.arithm(this.vars[0], this.op1.toString(), this.vars[1], Operator.getOpposite(this.op2).toString(), this.cste);
        }
        return ICF.arithm(this.vars[0], Operator.getOpposite(this.op1).toString(), this.vars[1], this.op2.toString(), this.cste);
    }
}

