/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import gnu.trove.map.hash.THashMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.ReificationConstraint;
import org.chocosolver.solver.constraints.reification.PropOpposite;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VF;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.StringUtils;

public class Constraint
implements Serializable {
    protected final Propagator[] propagators;
    BoolVar boolReif;
    Constraint opposite;
    protected String name;
    private static final long serialVersionUID = 1L;

    public Constraint(String name, Propagator ... propagators) {
        if (propagators == null || propagators.length == 0) {
            throw new UnsupportedOperationException("cannot create a constraint without propagators ");
        }
        this.name = name;
        this.propagators = propagators;
        for (int i = 0; i < propagators.length; ++i) {
            propagators[i].defineIn(this);
        }
    }

    public Propagator[] getPropagators() {
        return this.propagators;
    }

    public Propagator getPropagator(int i) {
        return this.propagators[i];
    }

    public ESat isSatisfied() {
        int sat = 0;
        for (int i = 0; i < this.propagators.length; ++i) {
            ESat entail = this.propagators[i].isEntailed();
            if (entail.equals((Object)ESat.FALSE)) {
                return entail;
            }
            if (!entail.equals((Object)ESat.TRUE)) continue;
            ++sat;
        }
        if (sat == this.propagators.length) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    public String toString() {
        return this.name + " (" + Arrays.toString(this.propagators) + ")";
    }

    public final boolean isReified() {
        return this.boolReif != null;
    }

    public final void reifyWith(BoolVar bool) {
        Solver s = this.propagators[0].getSolver();
        if (this.boolReif == null) {
            this.boolReif = bool;
            s.post((Constraint)new ReificationConstraint(this.boolReif, this, this.getOpposite()));
        } else if (bool != this.boolReif) {
            s.post(ICF.arithm((IntVar)bool, "=", this.boolReif));
        }
    }

    public final BoolVar reif() {
        if (this.boolReif == null) {
            Solver s = this.propagators[0].getSolver();
            this.boolReif = VF.bool(StringUtils.randomName(), s);
            s.post((Constraint)new ReificationConstraint(this.boolReif, this, this.getOpposite()));
        }
        return this.boolReif;
    }

    public final Constraint getOpposite() {
        this.reif();
        if (this.opposite == null) {
            this.opposite = this.makeOpposite();
            this.opposite.opposite = this;
            this.opposite.boolReif = this.boolReif.not();
        }
        return this.opposite;
    }

    public Constraint makeOpposite() {
        Object[] vars;
        if (this.propagators.length == 1) {
            vars = this.propagators[0].vars;
        } else {
            HashSet allvars = new HashSet();
            for (Propagator p : this.propagators) {
                Collections.addAll(allvars, p.vars);
            }
            vars = allvars.toArray(new Variable[allvars.size()]);
        }
        return new Constraint("DefaultOppositeOf" + this.name, new PropOpposite(this, (Variable[])vars));
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public PropagatorPriority computeMaxPriority() {
        int priority = 1;
        for (Propagator p : this.propagators) {
            priority = Math.max(priority, p.getPriority().priority);
        }
        return PropagatorPriority.get(priority);
    }

    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            Propagator[] pclone = new Propagator[this.propagators.length];
            for (int i = 0; i < this.propagators.length; ++i) {
                this.propagators[i].duplicate(solver, identitymap);
                pclone[i] = (Propagator)identitymap.get(this.propagators[i]);
            }
            Constraint clone = new Constraint(this.name, pclone);
            identitymap.put(this, clone);
        }
    }
}

