/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import org.chocosolver.solver.Settings;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Arithmetic;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.binary.DistanceXYC;
import org.chocosolver.solver.constraints.binary.PropAbsolute;
import org.chocosolver.solver.constraints.binary.PropElement;
import org.chocosolver.solver.constraints.binary.PropEqualXY_C;
import org.chocosolver.solver.constraints.binary.PropEqualX_Y;
import org.chocosolver.solver.constraints.binary.PropScale;
import org.chocosolver.solver.constraints.binary.PropSquare;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.TuplesFactory;
import org.chocosolver.solver.constraints.extension.binary.PropBinAC2001;
import org.chocosolver.solver.constraints.extension.binary.PropBinAC3;
import org.chocosolver.solver.constraints.extension.binary.PropBinAC3bitrm;
import org.chocosolver.solver.constraints.extension.binary.PropBinAC3rm;
import org.chocosolver.solver.constraints.extension.binary.PropBinCSP;
import org.chocosolver.solver.constraints.extension.binary.PropBinFC;
import org.chocosolver.solver.constraints.extension.nary.PropLargeFC;
import org.chocosolver.solver.constraints.extension.nary.PropLargeGAC2001;
import org.chocosolver.solver.constraints.extension.nary.PropLargeGAC2001Positive;
import org.chocosolver.solver.constraints.extension.nary.PropLargeGAC3rm;
import org.chocosolver.solver.constraints.extension.nary.PropLargeGAC3rmPositive;
import org.chocosolver.solver.constraints.extension.nary.PropLargeGACSTRPos;
import org.chocosolver.solver.constraints.extension.nary.PropLargeMDDC;
import org.chocosolver.solver.constraints.extension.nary.PropTableStr2;
import org.chocosolver.solver.constraints.nary.PropDiffN;
import org.chocosolver.solver.constraints.nary.PropKLoops;
import org.chocosolver.solver.constraints.nary.PropKnapsack;
import org.chocosolver.solver.constraints.nary.PropSort;
import org.chocosolver.solver.constraints.nary.alldifferent.AllDifferent;
import org.chocosolver.solver.constraints.nary.alldifferent.conditions.Condition;
import org.chocosolver.solver.constraints.nary.alldifferent.conditions.PropCondAllDiffInst;
import org.chocosolver.solver.constraints.nary.alldifferent.conditions.PropCondAllDiff_AC;
import org.chocosolver.solver.constraints.nary.among.PropAmongGAC_GoodImpl;
import org.chocosolver.solver.constraints.nary.automata.CostRegular;
import org.chocosolver.solver.constraints.nary.automata.FA.IAutomaton;
import org.chocosolver.solver.constraints.nary.automata.FA.ICostAutomaton;
import org.chocosolver.solver.constraints.nary.automata.PropMultiCostRegular;
import org.chocosolver.solver.constraints.nary.automata.PropRegular;
import org.chocosolver.solver.constraints.nary.channeling.PropBitChanneling;
import org.chocosolver.solver.constraints.nary.channeling.PropEnumDomainChanneling;
import org.chocosolver.solver.constraints.nary.channeling.PropInverseChannelAC;
import org.chocosolver.solver.constraints.nary.channeling.PropInverseChannelBC;
import org.chocosolver.solver.constraints.nary.circuit.CircuitConf;
import org.chocosolver.solver.constraints.nary.circuit.PropCircuitSCC;
import org.chocosolver.solver.constraints.nary.circuit.PropCircuit_AntiArboFiltering;
import org.chocosolver.solver.constraints.nary.circuit.PropCircuit_ArboFiltering;
import org.chocosolver.solver.constraints.nary.circuit.PropNoSubtour;
import org.chocosolver.solver.constraints.nary.circuit.PropSubCircuitSCC;
import org.chocosolver.solver.constraints.nary.circuit.PropSubcircuit;
import org.chocosolver.solver.constraints.nary.circuit.PropSubcircuit_AntiArboFiltering;
import org.chocosolver.solver.constraints.nary.count.PropCountVar;
import org.chocosolver.solver.constraints.nary.count.PropCount_AC;
import org.chocosolver.solver.constraints.nary.cumulative.Cumulative;
import org.chocosolver.solver.constraints.nary.element.PropElementV_fast;
import org.chocosolver.solver.constraints.nary.globalcardinality.GlobalCardinality;
import org.chocosolver.solver.constraints.nary.lex.PropLex;
import org.chocosolver.solver.constraints.nary.lex.PropLexChain;
import org.chocosolver.solver.constraints.nary.min_max.PropBoolMax;
import org.chocosolver.solver.constraints.nary.min_max.PropBoolMin;
import org.chocosolver.solver.constraints.nary.min_max.PropMax;
import org.chocosolver.solver.constraints.nary.min_max.PropMin;
import org.chocosolver.solver.constraints.nary.nValue.PropAMNV;
import org.chocosolver.solver.constraints.nary.nValue.PropAtLeastNValues;
import org.chocosolver.solver.constraints.nary.nValue.PropAtLeastNValues_AC;
import org.chocosolver.solver.constraints.nary.nValue.PropAtMostNValues;
import org.chocosolver.solver.constraints.nary.nValue.amnv.differences.AutoDiffDetection;
import org.chocosolver.solver.constraints.nary.nValue.amnv.graph.Gci;
import org.chocosolver.solver.constraints.nary.nValue.amnv.mis.MDRk;
import org.chocosolver.solver.constraints.nary.nValue.amnv.rules.R;
import org.chocosolver.solver.constraints.nary.nValue.amnv.rules.R1;
import org.chocosolver.solver.constraints.nary.nValue.amnv.rules.R3;
import org.chocosolver.solver.constraints.nary.sum.PropBoolSumCoarse;
import org.chocosolver.solver.constraints.nary.sum.PropBoolSumIncremental;
import org.chocosolver.solver.constraints.nary.sum.ScalarFactory;
import org.chocosolver.solver.constraints.nary.tree.PropAntiArborescences;
import org.chocosolver.solver.constraints.ternary.DistanceXYZ;
import org.chocosolver.solver.constraints.ternary.PropDivXYZ;
import org.chocosolver.solver.constraints.ternary.PropMaxBC;
import org.chocosolver.solver.constraints.ternary.PropMinBC;
import org.chocosolver.solver.constraints.ternary.Times;
import org.chocosolver.solver.constraints.unary.Member;
import org.chocosolver.solver.constraints.unary.NotMember;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Task;
import org.chocosolver.solver.variables.VF;
import org.chocosolver.solver.variables.VariableFactory;
import org.chocosolver.util.objects.graphs.MultivaluedDecisionDiagram;
import org.chocosolver.util.tools.ArrayUtils;
import org.chocosolver.util.tools.StringUtils;

public class IntConstraintFactory {
    IntConstraintFactory() {
    }

    public static Constraint TRUE(Solver solver) {
        return solver.TRUE;
    }

    public static Constraint FALSE(Solver solver) {
        return solver.FALSE;
    }

    public static Constraint arithm(IntVar VAR, String OP, int CSTE) {
        Operator op = Operator.get(OP);
        return new Arithmetic(VAR, op, CSTE);
    }

    public static Constraint member(IntVar VAR, int[] TABLE) {
        return new Member(VAR, TABLE);
    }

    public static Constraint member(IntVar VAR, int LB, int UB) {
        return new Member(VAR, LB, UB);
    }

    public static Constraint not_member(IntVar VAR, int[] TABLE) {
        return new NotMember(VAR, TABLE);
    }

    public static Constraint not_member(IntVar VAR, int LB, int UB) {
        return new NotMember(VAR, LB, UB);
    }

    public static Constraint absolute(IntVar VAR1, IntVar VAR2) {
        assert (VAR1.getSolver() == VAR2.getSolver());
        return new Constraint("Absolute", new PropAbsolute(VAR1, VAR2));
    }

    public static Constraint arithm(IntVar VAR1, String OP, IntVar VAR2) {
        if (VAR2.isInstantiated()) {
            return IntConstraintFactory.arithm(VAR1, OP, VAR2.getValue());
        }
        if (VAR1.isInstantiated()) {
            return IntConstraintFactory.arithm(VAR2, Operator.getFlip(OP), VAR1.getValue());
        }
        return new Arithmetic(VAR1, Operator.get(OP), VAR2);
    }

    public static Constraint arithm(IntVar VAR1, String OP1, IntVar VAR2, String OP2, int CSTE) {
        if (VAR2.isInstantiated()) {
            if (OP1.equals("+")) {
                return IntConstraintFactory.arithm(VAR1, OP2, CSTE - VAR2.getValue());
            }
            if (OP1.equals("-")) {
                return IntConstraintFactory.arithm(VAR1, OP2, CSTE + VAR2.getValue());
            }
        }
        if (VAR1.isInstantiated()) {
            if (OP1.equals("+")) {
                return IntConstraintFactory.arithm(VAR2, OP2, CSTE - VAR1.getValue());
            }
            if (OP1.equals("-")) {
                return IntConstraintFactory.arithm(VAR2, Operator.getFlip(OP2), VAR1.getValue() - CSTE);
            }
        }
        Operator op1 = Operator.get(OP1);
        Operator op2 = Operator.get(OP2);
        return new Arithmetic(VAR1, op1, VAR2, op2, CSTE);
    }

    public static Constraint distance(IntVar VAR1, IntVar VAR2, String OP, int CSTE) {
        assert (VAR1.getSolver() == VAR2.getSolver());
        return new DistanceXYC(VAR1, VAR2, Operator.get(OP), CSTE);
    }

    public static Constraint element(IntVar VALUE, int[] TABLE, IntVar INDEX, int OFFSET, String SORT2) {
        return new Constraint("Element", new PropElement(VALUE, TABLE, INDEX, OFFSET, PropElement.Sort.valueOf(SORT2)));
    }

    public static Constraint element(IntVar VALUE, int[] TABLE, IntVar INDEX) {
        return IntConstraintFactory.element(VALUE, TABLE, INDEX, 0, "detect");
    }

    public static Constraint square(IntVar VAR1, IntVar VAR2) {
        assert (VAR1.getSolver() == VAR2.getSolver());
        return new Constraint("Square", new PropSquare(VAR1, VAR2));
    }

    public static Constraint table(IntVar VAR1, IntVar VAR2, Tuples TUPLES, String ALGORITHM) {
        PropBinCSP p;
        switch (ALGORITHM) {
            case "AC2001": {
                p = new PropBinAC2001(VAR1, VAR2, TUPLES);
                break;
            }
            case "FC": {
                p = new PropBinFC(VAR1, VAR2, TUPLES);
                break;
            }
            case "AC3": {
                p = new PropBinAC3(VAR1, VAR2, TUPLES);
                break;
            }
            case "AC3rm": {
                p = new PropBinAC3rm(VAR1, VAR2, TUPLES);
                break;
            }
            default: {
                p = new PropBinAC3bitrm(VAR1, VAR2, TUPLES);
            }
        }
        return new Constraint("TableBin(" + ALGORITHM + ")", p);
    }

    public static Constraint distance(IntVar VAR1, IntVar VAR2, String OP, IntVar VAR3) {
        return new DistanceXYZ(VAR1, VAR2, Operator.get(OP), VAR3);
    }

    public static Constraint eucl_div(IntVar DIVIDEND, IntVar DIVISOR, IntVar RESULT) {
        return new Constraint("DivisionEucl", new PropDivXYZ(DIVIDEND, DIVISOR, RESULT));
    }

    public static Constraint maximum(IntVar MAX, IntVar VAR1, IntVar VAR2) {
        return new Constraint("Max", new PropMaxBC(MAX, VAR1, VAR2));
    }

    public static Constraint minimum(IntVar MIN, IntVar VAR1, IntVar VAR2) {
        return new Constraint("Min", new PropMinBC(MIN, VAR1, VAR2));
    }

    public static Constraint mod(IntVar X, IntVar Y, IntVar Z) {
        int xl = Math.abs(X.getLB());
        int xu = Math.abs(X.getUB());
        int b = Math.max(xl, xu);
        Solver solver = X.getSolver();
        IntVar t1 = VariableFactory.bounded(StringUtils.randomName(), -b, b, solver);
        IntVar t2 = VariableFactory.bounded(StringUtils.randomName(), -b, b, solver);
        Constraint div = IntConstraintFactory.eucl_div(X, Y, t1);
        Constraint tim = IntConstraintFactory.times(t1, Y, t2);
        Constraint sum = IntConstraintFactory.sum(new IntVar[]{Z, t2}, X);
        return new Constraint("Mod", ArrayUtils.append(div.getPropagators(), tim.getPropagators(), sum.getPropagators()));
    }

    public static Constraint times(IntVar X, IntVar Y, IntVar Z) {
        if (Y.isInstantiated()) {
            return IntConstraintFactory.times(X, Y.getValue(), Z);
        }
        if (X.isInstantiated()) {
            return IntConstraintFactory.times(Y, X.getValue(), Z);
        }
        if (IntConstraintFactory.tupleIt(X, Y, Z)) {
            return IntConstraintFactory.table(new IntVar[]{X, Y, Z}, TuplesFactory.times(X, Y, Z), "");
        }
        return new Times(X, Y, Z);
    }

    public static Constraint times(IntVar X, int Y, IntVar Z) {
        if (Y == 0) {
            return IntConstraintFactory.arithm(Z, "=", 0);
        }
        if (Y == 1) {
            return IntConstraintFactory.arithm(X, "=", Z);
        }
        if (Y < 0) {
            return IntConstraintFactory.times(VF.minus(X), -Y, Z);
        }
        return new Constraint("Times", new PropScale(X, Y, Z));
    }

    public static Constraint alldifferent(IntVar[] VARS) {
        return IntConstraintFactory.alldifferent(VARS, "DEFAULT");
    }

    public static Constraint alldifferent(IntVar[] VARS, String CONSISTENCY) {
        return new AllDifferent(VARS, CONSISTENCY);
    }

    public static Constraint alldifferent_conditionnal(IntVar[] VARS, Condition CONDITION, boolean AC) {
        if (AC) {
            return new Constraint("AllDifferent" + CONDITION, new PropCondAllDiffInst(VARS, CONDITION), new PropCondAllDiff_AC(VARS, CONDITION));
        }
        return new Constraint("AllDifferent" + CONDITION, new PropCondAllDiffInst(VARS, CONDITION));
    }

    public static Constraint alldifferent_conditionnal(IntVar[] VARS, Condition CONDITION) {
        return IntConstraintFactory.alldifferent_conditionnal(VARS, CONDITION, false);
    }

    public static Constraint alldifferent_except_0(IntVar[] VARS) {
        return IntConstraintFactory.alldifferent_conditionnal(VARS, Condition.EXCEPT_0);
    }

    public static Constraint among(IntVar NVAR, IntVar[] VARS, int[] VALUES) {
        int[] values = new TIntHashSet(VALUES).toArray();
        Arrays.sort(values);
        return new Constraint("Among", new PropAmongGAC_GoodImpl(ArrayUtils.append(VARS, {NVAR}), values));
    }

    public static Constraint atleast_nvalues(IntVar[] VARS, IntVar NVALUES, boolean AC) {
        TIntArrayList vals = IntConstraintFactory.getDomainUnion(VARS);
        if (AC) {
            return new Constraint("AtLeastNValues", new PropAtLeastNValues(VARS, vals, NVALUES), new PropAtLeastNValues_AC(VARS, NVALUES));
        }
        return new Constraint("AtLeastNValues", new PropAtLeastNValues(VARS, vals, NVALUES));
    }

    public static Constraint atmost_nvalues(IntVar[] VARS, IntVar NVALUES, boolean GREEDY) {
        TIntArrayList vals = IntConstraintFactory.getDomainUnion(VARS);
        if (GREEDY) {
            Gci gci = new Gci(VARS, new AutoDiffDetection(VARS));
            R[] rules = new R[]{new R1(), new R3(VARS.length, NVALUES.getSolver())};
            return new Constraint("AtMostNValues", new PropAtMostNValues(VARS, vals, NVALUES), new PropAMNV(VARS, NVALUES, gci, new MDRk(gci), rules));
        }
        return new Constraint("AtMostNValues", new PropAtMostNValues(VARS, vals, NVALUES));
    }

    public static Constraint[] bin_packing(IntVar[] ITEM_BIN, int[] ITEM_SIZE, IntVar[] BIN_LOAD, int OFFSET) {
        int nbBins = BIN_LOAD.length;
        int nbItems = ITEM_BIN.length;
        Solver s = ITEM_BIN[0].getSolver();
        BoolVar[][] xbi = VF.boolMatrix("xbi", nbBins, nbItems, s);
        int sum = 0;
        for (int is : ITEM_SIZE) {
            sum += is;
        }
        IntVar sumView = VF.fixed(sum, s);
        Constraint[] bpcons = new Constraint[nbItems + nbBins + 1];
        for (int i = 0; i < nbItems; ++i) {
            bpcons[i] = ICF.boolean_channeling(ArrayUtils.getColumn(xbi, i), ITEM_BIN[i], OFFSET);
        }
        for (int b = 0; b < nbBins; ++b) {
            bpcons[nbItems + b] = ICF.scalar(xbi[b], ITEM_SIZE, BIN_LOAD[b]);
        }
        bpcons[nbItems + nbBins] = ICF.sum(BIN_LOAD, sumView);
        return bpcons;
    }

    public static Constraint boolean_channeling(BoolVar[] BVARS, IntVar VAR, int OFFSET) {
        if (VAR.hasEnumeratedDomain()) {
            return new Constraint("DomainChanneling", new PropEnumDomainChanneling(BVARS, VAR, OFFSET));
        }
        IntVar enumV = VF.enumerated(VAR.getName() + "_enumImage", VAR.getLB(), VAR.getUB(), VAR.getSolver());
        return new Constraint("BoolChanneling", new PropEnumDomainChanneling(BVARS, enumV, OFFSET), new PropEqualX_Y(VAR, enumV));
    }

    public static Constraint bit_channeling(BoolVar[] BITS, IntVar VAR) {
        return new Constraint("bit_channeling", new PropBitChanneling(VAR, BITS));
    }

    public static Constraint circuit(IntVar[] VARS, int OFFSET, CircuitConf CONF) {
        Propagator[] props = CONF == CircuitConf.LIGHT ? new Propagator[]{new PropNoSubtour(VARS, OFFSET)} : new Propagator[]{new PropNoSubtour(VARS, OFFSET), new PropCircuit_ArboFiltering(VARS, OFFSET, CONF), new PropCircuit_AntiArboFiltering(VARS, OFFSET, CONF), new PropCircuitSCC(VARS, OFFSET, CONF)};
        return new Constraint("Circuit", ArrayUtils.append(IntConstraintFactory.alldifferent((IntVar[])VARS, (String)"AC").propagators, props));
    }

    public static Constraint circuit(IntVar[] VARS, int OFFSET) {
        return IntConstraintFactory.circuit(VARS, OFFSET, CircuitConf.RD);
    }

    public static Constraint cost_regular(IntVar[] VARS, IntVar COST, ICostAutomaton CAUTOMATON) {
        return new CostRegular(VARS, COST, CAUTOMATON);
    }

    public static Constraint count(int VALUE, IntVar[] VARS, IntVar LIMIT) {
        return new Constraint("Count", new PropCount_AC(VARS, VALUE, LIMIT));
    }

    public static Constraint count(IntVar VALUE, IntVar[] VARS, IntVar LIMIT) {
        if (VALUE.isInstantiated()) {
            return IntConstraintFactory.count(VALUE.getValue(), VARS, LIMIT);
        }
        if (VALUE.hasEnumeratedDomain()) {
            return new Constraint("Count", new PropCountVar(VARS, VALUE, LIMIT));
        }
        IntVar EVALUE = VF.enumerated(StringUtils.randomName(), VALUE.getLB(), VALUE.getUB(), VALUE.getSolver());
        return new Constraint("Count", new PropEqualX_Y(EVALUE, VALUE), new PropCountVar(VARS, EVALUE, LIMIT));
    }

    public static Constraint cumulative(Task[] TASKS, IntVar[] HEIGHTS, IntVar CAPACITY) {
        return IntConstraintFactory.cumulative(TASKS, HEIGHTS, CAPACITY, TASKS.length > 500);
    }

    public static Constraint cumulative(Task[] TASKS, IntVar[] HEIGHTS, IntVar CAPACITY, boolean INCREMENTAL) {
        boolean addHeights = false;
        int nbUseFull = 0;
        for (int h = 0; h < HEIGHTS.length; ++h) {
            if (!HEIGHTS[h].isInstantiated()) {
                addHeights = true;
            }
            if (HEIGHTS[h].isInstantiatedTo(0) || TASKS[h].getDuration().isInstantiatedTo(0)) continue;
            ++nbUseFull;
        }
        if (nbUseFull < TASKS.length) {
            if (nbUseFull == 0) {
                return IntConstraintFactory.arithm(CAPACITY, ">=", 0);
            }
            Task[] T2 = new Task[nbUseFull];
            IntVar[] H2 = new IntVar[nbUseFull];
            int idx = 0;
            for (int h = 0; h < HEIGHTS.length; ++h) {
                if (HEIGHTS[h].isInstantiatedTo(0) || TASKS[h].getDuration().isInstantiatedTo(0)) continue;
                T2[idx] = TASKS[h];
                H2[idx] = HEIGHTS[h];
                ++idx;
            }
            TASKS = T2;
            HEIGHTS = H2;
        }
        Cumulative.Filter[] filters = new Cumulative.Filter[]{Cumulative.Filter.TIME, Cumulative.Filter.NRJ};
        if (addHeights) {
            filters = ArrayUtils.append(filters, {Cumulative.Filter.HEIGHTS});
        }
        return new Cumulative(TASKS, HEIGHTS, CAPACITY, INCREMENTAL, filters);
    }

    public static Constraint[] diffn(IntVar[] X, IntVar[] Y, IntVar[] WIDTH, IntVar[] HEIGHT, boolean USE_CUMUL) {
        Solver solver = X[0].getSolver();
        Constraint diffNCons = new Constraint("DiffN", new PropDiffN(X, Y, WIDTH, HEIGHT, false), new PropDiffN(X, Y, WIDTH, HEIGHT, false));
        if (USE_CUMUL) {
            IntVar[] EX = new IntVar[X.length];
            IntVar[] EY = new IntVar[X.length];
            Task[] TX = new Task[X.length];
            Task[] TY = new Task[X.length];
            int minx = 0x3FFFFFFF;
            int maxx = -1073741824;
            int miny = 0x3FFFFFFF;
            int maxy = -1073741824;
            for (int i = 0; i < X.length; ++i) {
                EX[i] = VF.bounded(StringUtils.randomName("diffn"), X[i].getLB() + WIDTH[i].getLB(), X[i].getUB() + WIDTH[i].getUB(), solver);
                EY[i] = VF.bounded(StringUtils.randomName("diffn"), Y[i].getLB() + HEIGHT[i].getLB(), Y[i].getUB() + HEIGHT[i].getUB(), solver);
                TX[i] = VF.task(X[i], WIDTH[i], EX[i]);
                TY[i] = VF.task(Y[i], HEIGHT[i], EY[i]);
                minx = Math.min(minx, X[i].getLB());
                miny = Math.min(miny, Y[i].getLB());
                maxx = Math.max(maxx, X[i].getUB() + WIDTH[i].getUB());
                maxy = Math.max(maxy, Y[i].getUB() + HEIGHT[i].getUB());
            }
            IntVar maxX = VF.bounded(StringUtils.randomName("diffn"), minx, maxx, solver);
            IntVar minX = VF.bounded(StringUtils.randomName("diffn"), minx, maxx, solver);
            IntVar diffX = VF.bounded(StringUtils.randomName("diffn"), 0, maxx - minx, solver);
            IntVar maxY = VF.bounded(StringUtils.randomName("diffn"), miny, maxy, solver);
            IntVar minY = VF.bounded(StringUtils.randomName("diffn"), miny, maxy, solver);
            IntVar diffY = VF.bounded(StringUtils.randomName("diffn"), 0, maxy - miny, solver);
            return new Constraint[]{diffNCons, IntConstraintFactory.minimum(minX, X), IntConstraintFactory.maximum(maxX, EX), IntConstraintFactory.scalar(new IntVar[]{maxX, minX}, new int[]{1, -1}, diffX), IntConstraintFactory.cumulative(TX, HEIGHT, diffY, true), IntConstraintFactory.minimum(minY, Y), IntConstraintFactory.maximum(maxY, EY), IntConstraintFactory.scalar(new IntVar[]{maxY, minY}, new int[]{1, -1}, diffY), IntConstraintFactory.cumulative(TY, WIDTH, diffX, true)};
        }
        return new Constraint[]{diffNCons};
    }

    public static Constraint element(IntVar VALUE, IntVar[] TABLE, IntVar INDEX, int OFFSET) {
        return new Constraint("Element", new PropElementV_fast(VALUE, TABLE, INDEX, OFFSET, true), new PropElementV_fast(VALUE, TABLE, INDEX, OFFSET, true));
    }

    public static Constraint global_cardinality(IntVar[] VARS, int[] VALUES, IntVar[] OCCURRENCES, boolean CLOSED) {
        assert (VALUES.length == OCCURRENCES.length);
        if (!CLOSED) {
            return new GlobalCardinality(VARS, VALUES, OCCURRENCES);
        }
        TIntArrayList toAdd = new TIntArrayList();
        TIntHashSet givenValues = new TIntHashSet();
        for (int i : VALUES) {
            assert (!givenValues.contains(i));
            givenValues.add(i);
        }
        for (IntVar var : VARS) {
            int ub = var.getUB();
            int k = var.getLB();
            while (k <= ub) {
                if (!givenValues.contains(k) && !toAdd.contains(k)) {
                    toAdd.add(k);
                }
                k = var.nextValue(k);
            }
        }
        if (toAdd.size() > 0) {
            int n = VALUES.length + toAdd.size();
            int[] values = new int[n];
            IntVar[] cards = new IntVar[n];
            System.arraycopy(VALUES, 0, values, 0, VALUES.length);
            System.arraycopy(OCCURRENCES, 0, cards, 0, VALUES.length);
            for (int i = VALUES.length; i < n; ++i) {
                values[i] = toAdd.get(i - VALUES.length);
                cards[i] = VariableFactory.fixed(0, VARS[0].getSolver());
            }
            return new GlobalCardinality(VARS, values, cards);
        }
        return new GlobalCardinality(VARS, VALUES, OCCURRENCES);
    }

    public static Constraint inverse_channeling(IntVar[] VARS1, IntVar[] VARS2, int OFFSET1, int OFFSET2) {
        if (VARS1.length != VARS2.length) {
            throw new UnsupportedOperationException(Arrays.toString(VARS1) + " and " + Arrays.toString(VARS2) + " should have same size");
        }
        boolean allEnum = true;
        for (int i = 0; i < VARS1.length && allEnum; ++i) {
            if (VARS1[i].hasEnumeratedDomain() && VARS2[i].hasEnumeratedDomain()) continue;
            allEnum = false;
        }
        Propagator ip = allEnum ? new PropInverseChannelAC(VARS1, VARS2, OFFSET1, OFFSET2) : new PropInverseChannelBC(VARS1, VARS2, OFFSET1, OFFSET2);
        return new Constraint("InverseChanneling", ArrayUtils.append(IntConstraintFactory.alldifferent(VARS1).getPropagators(), IntConstraintFactory.alldifferent(VARS2).getPropagators(), {ip}));
    }

    public static Constraint knapsack(IntVar[] OCCURRENCES, IntVar TOTAL_WEIGHT, IntVar TOTAL_ENERGY, int[] WEIGHT, int[] ENERGY) {
        return new Constraint("Knapsack", ArrayUtils.append(IntConstraintFactory.scalar((IntVar[])OCCURRENCES, (int[])WEIGHT, (IntVar)TOTAL_WEIGHT).propagators, IntConstraintFactory.scalar((IntVar[])OCCURRENCES, (int[])ENERGY, (IntVar)TOTAL_ENERGY).propagators, {new PropKnapsack(OCCURRENCES, TOTAL_WEIGHT, TOTAL_ENERGY, WEIGHT, ENERGY)}));
    }

    public static Constraint lex_chain_less(IntVar[] ... VARS) {
        return new Constraint("LexChain(<) ", new PropLexChain(VARS, true));
    }

    public static Constraint lex_chain_less_eq(IntVar[] ... VARS) {
        return new Constraint("LexChain(<=)", new PropLexChain(VARS, false));
    }

    public static Constraint lex_less(IntVar[] VARS1, IntVar[] VARS2) {
        return new Constraint("Lex(<)", new PropLex(VARS1, VARS2, true));
    }

    public static Constraint lex_less_eq(IntVar[] VARS1, IntVar[] VARS2) {
        return new Constraint("Lex(<=)", new PropLex(VARS1, VARS2, false));
    }

    public static Constraint maximum(IntVar MAX, IntVar[] VARS) {
        Propagator[] propagatorArray;
        boolean enu = MAX.hasEnumeratedDomain();
        for (int i = 0; i < VARS.length && !enu; ++i) {
            enu = VARS[i].hasEnumeratedDomain();
        }
        if (enu) {
            Propagator[] propagatorArray2 = new Propagator[2];
            propagatorArray2[0] = new PropMax(VARS, MAX);
            propagatorArray = propagatorArray2;
            propagatorArray2[1] = new PropMax(VARS, MAX);
        } else {
            Propagator[] propagatorArray3 = new Propagator[1];
            propagatorArray = propagatorArray3;
            propagatorArray3[0] = new PropMax(VARS, MAX);
        }
        Propagator[] propagators = propagatorArray;
        return new Constraint("Max", propagators);
    }

    public static Constraint maximum(BoolVar MAX, BoolVar[] VARS) {
        return new Constraint("MinOverBools", new PropBoolMax(VARS, MAX));
    }

    public static Constraint mddc(IntVar[] VARS, MultivaluedDecisionDiagram MDD) {
        return new Constraint("mddc", new PropLargeMDDC(MDD, VARS));
    }

    public static Constraint minimum(IntVar MIN, IntVar[] VARS) {
        Propagator[] propagatorArray;
        boolean enu = MIN.hasEnumeratedDomain();
        for (int i = 0; i < VARS.length && !enu; ++i) {
            enu = VARS[i].hasEnumeratedDomain();
        }
        if (enu) {
            Propagator[] propagatorArray2 = new Propagator[2];
            propagatorArray2[0] = new PropMin(VARS, MIN);
            propagatorArray = propagatorArray2;
            propagatorArray2[1] = new PropMin(VARS, MIN);
        } else {
            Propagator[] propagatorArray3 = new Propagator[1];
            propagatorArray = propagatorArray3;
            propagatorArray3[0] = new PropMin(VARS, MIN);
        }
        Propagator[] propagators = propagatorArray;
        return new Constraint("Min", propagators);
    }

    public static Constraint minimum(BoolVar MIN, BoolVar[] VARS) {
        return new Constraint("MinOverBools", new PropBoolMin(VARS, MIN));
    }

    public static Constraint multicost_regular(IntVar[] VARS, IntVar[] CVARS, ICostAutomaton CAUTOMATON) {
        return new Constraint("MultiCostRegular", new PropMultiCostRegular(VARS, CVARS, CAUTOMATON));
    }

    public static Constraint[] nvalues(IntVar[] VARS, IntVar NVALUES) {
        return new Constraint[]{IntConstraintFactory.atleast_nvalues(VARS, NVALUES, false), IntConstraintFactory.atmost_nvalues(VARS, NVALUES, true)};
    }

    public static Constraint[] path(IntVar[] VARS, IntVar START, IntVar END, int OFFSET) {
        assert (START != null && END != null && VARS != null);
        switch (VARS.length) {
            case 0: {
                throw new UnsupportedOperationException("|VARS| Should be strictly greater than 0");
            }
            case 1: {
                return new Constraint[]{IntConstraintFactory.arithm(START, "=", OFFSET), IntConstraintFactory.arithm(END, "=", OFFSET), IntConstraintFactory.arithm(VARS[0], "=", 1 + OFFSET)};
            }
        }
        if (START == END) {
            return new Constraint[]{START.getSolver().FALSE};
        }
        return new Constraint[]{IntConstraintFactory.arithm(START, "!=", END), IntConstraintFactory.circuit(ArrayUtils.append(VARS, {START}), OFFSET), IntConstraintFactory.element(VF.fixed(VARS.length + OFFSET, END.getSolver()), VARS, END, OFFSET)};
    }

    public static Constraint regular(IntVar[] VARS, IAutomaton AUTOMATON) {
        return new Constraint("Regular", new PropRegular(VARS, AUTOMATON));
    }

    public static Constraint scalar(IntVar[] VARS, int[] COEFFS, IntVar SCALAR) {
        return IntConstraintFactory.scalar(VARS, COEFFS, "=", SCALAR);
    }

    public static Constraint scalar(IntVar[] VARS, int[] COEFFS, String OPERATOR, IntVar SCALAR) {
        return ScalarFactory.reduce(VARS, COEFFS, OPERATOR, SCALAR);
    }

    public static Constraint sort(IntVar[] VARS, IntVar[] SORTEDVARS) {
        return new Constraint("Sort", new PropSort(VARS, SORTEDVARS));
    }

    public static Constraint subcircuit(IntVar[] VARS, int OFFSET, IntVar SUBCIRCUIT_SIZE) {
        int n = VARS.length;
        Solver solver = VARS[0].getSolver();
        IntVar nbLoops = VariableFactory.bounded("nLoops", 0, n, solver);
        return new Constraint("SubCircuit", ArrayUtils.append(IntConstraintFactory.alldifferent(VARS).getPropagators(), ArrayUtils.toArray(new PropEqualXY_C(new IntVar[]{nbLoops, SUBCIRCUIT_SIZE}, n), new PropKLoops(VARS, OFFSET, nbLoops), new PropSubcircuit(VARS, OFFSET, SUBCIRCUIT_SIZE), new PropSubcircuit_AntiArboFiltering(VARS, OFFSET), new PropSubCircuitSCC(VARS, OFFSET))));
    }

    public static Constraint[] subpath(IntVar[] VARS, IntVar START, IntVar END, int OFFSET, IntVar SIZE) {
        assert (START != null && END != null && VARS != null);
        switch (VARS.length) {
            case 0: {
                throw new UnsupportedOperationException("|VARS| Should be strictly greater than 0");
            }
            case 1: {
                return new Constraint[]{IntConstraintFactory.arithm(START, "=", OFFSET), IntConstraintFactory.arithm(END, "=", OFFSET), IntConstraintFactory.arithm(VARS[0], "=", 1 + OFFSET), IntConstraintFactory.arithm(SIZE, "=", 1)};
            }
        }
        return new Constraint[]{IntConstraintFactory.arithm(START, "<", VARS.length + OFFSET), IntConstraintFactory.subcircuit(ArrayUtils.append(VARS, {START}), OFFSET, VF.offset(SIZE, 1)), IntConstraintFactory.element(VF.fixed(VARS.length + OFFSET, END.getSolver()), VARS, END, OFFSET)};
    }

    public static Constraint sum(IntVar[] VARS, IntVar SUM) {
        return IntConstraintFactory.sum(VARS, "=", SUM);
    }

    public static Constraint sum(IntVar[] VARS, String OPERATOR, IntVar SUM) {
        return ScalarFactory.reduce(VARS, OPERATOR, SUM);
    }

    public static Constraint sum(BoolVar[] VARS, IntVar SUM) {
        if (VARS.length > 10) {
            return new Constraint("SumOfBool", new PropBoolSumIncremental(VARS, SUM));
        }
        return new Constraint("SumOfBool", new PropBoolSumCoarse(VARS, SUM));
    }

    public static Constraint sum(BoolVar[] VARS, String OPERATOR, IntVar SUM) {
        if (OPERATOR.equals("=")) {
            return IntConstraintFactory.sum(VARS, SUM);
        }
        int lb = 0;
        int ub = 0;
        for (BoolVar v : VARS) {
            lb += v.getLB();
            ub += v.getUB();
        }
        IntVar p = VF.bounded(StringUtils.randomName(), lb, ub, SUM.getSolver());
        SUM.getSolver().post(IntConstraintFactory.sum(VARS, p));
        return IntConstraintFactory.arithm(p, OPERATOR, SUM);
    }

    public static Constraint table(IntVar[] VARS, Tuples TUPLES, String ALGORITHM) {
        Propagator p;
        if (VARS.length == 2) {
            IntConstraintFactory.table(VARS[0], VARS[1], TUPLES, "");
        }
        switch (ALGORITHM) {
            case "FC": {
                p = new PropLargeFC(VARS, TUPLES);
                break;
            }
            case "GAC3rm": {
                p = new PropLargeGAC3rm(VARS, TUPLES);
                break;
            }
            case "GAC2001": {
                p = new PropLargeGAC2001(VARS, TUPLES);
                break;
            }
            default: {
                if (!TUPLES.isFeasible()) {
                    throw new SolverException("GACSTR+ cannot be used with forbidden tuples.");
                }
                p = new PropLargeGACSTRPos(VARS, TUPLES);
                break;
            }
            case "GAC2001+": {
                if (!TUPLES.isFeasible()) {
                    throw new SolverException("GAC2001+ cannot be used with forbidden tuples.");
                }
                p = new PropLargeGAC2001Positive(VARS, TUPLES);
                break;
            }
            case "GAC3rm+": {
                if (!TUPLES.isFeasible()) {
                    throw new SolverException("GAC3rm+ cannot be used with forbidden tuples.");
                }
                p = new PropLargeGAC3rmPositive(VARS, TUPLES);
                break;
            }
            case "STR2+": {
                if (!TUPLES.isFeasible()) {
                    throw new SolverException("STR2+ cannot be used with forbidden tuples.");
                }
                p = new PropTableStr2(VARS, TUPLES.toMatrix());
            }
        }
        return new Constraint("Table(" + ALGORITHM + ")", p);
    }

    public static Constraint tree(IntVar[] SUCCS, IntVar NBTREES, int OFFSET) {
        return new Constraint("tree", new PropAntiArborescences(SUCCS, OFFSET, false), new PropKLoops(SUCCS, OFFSET, NBTREES));
    }

    public static Constraint[] tsp(IntVar[] SUCCS, IntVar COST, int[][] COST_MATRIX) {
        int n = SUCCS.length;
        assert (n > 1);
        assert (n == COST_MATRIX.length && n == COST_MATRIX[0].length);
        IntVar[] costOf = new IntVar[n];
        for (int i = 0; i < n; ++i) {
            costOf[i] = VF.enumerated("costOf(" + i + ")", COST_MATRIX[i], COST.getSolver());
        }
        Constraint[] model = new Constraint[n + 2];
        for (int i = 0; i < n; ++i) {
            model[i] = IntConstraintFactory.element(costOf[i], COST_MATRIX[i], SUCCS[i]);
        }
        model[n] = IntConstraintFactory.sum(costOf, COST);
        model[n + 1] = IntConstraintFactory.circuit(SUCCS, 0);
        return model;
    }

    public static TIntArrayList getDomainUnion(IntVar[] vars) {
        TIntArrayList values = new TIntArrayList();
        for (IntVar v : vars) {
            int ub = v.getUB();
            int i = v.getLB();
            while (i <= ub) {
                if (!values.contains(i)) {
                    values.add(i);
                }
                i = v.nextValue(i);
            }
        }
        return values;
    }

    public static boolean tupleIt(IntVar ... VARS) {
        Settings settings = VARS[0].getSolver().getSettings();
        if (!settings.enableTableSubstitution()) {
            return false;
        }
        long doms = 1L;
        for (int i = 0; i < VARS.length && doms < (long)settings.getMaxTupleSizeForSubstitution(); doms *= (long)VARS[i].getDomainSize(), ++i) {
            if (VARS[i].hasEnumeratedDomain()) continue;
            return false;
        }
        return doms < (long)settings.getMaxTupleSizeForSubstitution();
    }
}

