/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.IntConstraintFactory;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VariableFactory;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.StringUtils;

public class LogicalConstraintFactory {
    public static Constraint and(BoolVar ... BOOLS) {
        Solver s = BOOLS[0].getSolver();
        IntVar sum = VariableFactory.bounded(StringUtils.randomName(), 0, BOOLS.length, s);
        s.post(IntConstraintFactory.sum(BOOLS, sum));
        return IntConstraintFactory.arithm(sum, "=", BOOLS.length);
    }

    public static Constraint or(BoolVar ... BOOLS) {
        Solver s = BOOLS[0].getSolver();
        IntVar sum = VariableFactory.bounded(StringUtils.randomName(), 0, BOOLS.length, s);
        s.post(IntConstraintFactory.sum(BOOLS, sum));
        return IntConstraintFactory.arithm(sum, ">=", 1);
    }

    public static Constraint and(Constraint ... CONS) {
        BoolVar[] bools = new BoolVar[CONS.length];
        for (int i = 0; i < CONS.length; ++i) {
            bools[i] = CONS[i].reif();
        }
        return LogicalConstraintFactory.and(bools);
    }

    public static Constraint or(Constraint ... CONS) {
        BoolVar[] bools = new BoolVar[CONS.length];
        for (int i = 0; i < CONS.length; ++i) {
            bools[i] = CONS[i].reif();
        }
        return LogicalConstraintFactory.or(bools);
    }

    public static Constraint not(Constraint CONS) {
        return CONS.getOpposite();
    }

    public static void ifThenElse(Constraint IF, Constraint THEN, Constraint ELSE) {
        LogicalConstraintFactory.ifThenElse(IF.reif(), THEN, ELSE);
    }

    public static void ifThenElse(BoolVar BVAR, Constraint THEN, Constraint ELSE) {
        LogicalConstraintFactory.ifThen(BVAR, THEN);
        LogicalConstraintFactory.ifThen(BVAR.not(), ELSE);
    }

    public static void ifThen(Constraint IF, Constraint THEN) {
        LogicalConstraintFactory.ifThen(IF.reif(), THEN);
    }

    public static void ifThen(BoolVar BVAR, Constraint CSTR) {
        Solver s = BVAR.getSolver();
        if (BVAR.contains(1)) {
            if (BVAR.isInstantiated()) {
                s.post(CSTR);
            } else if (CSTR.isSatisfied() == ESat.FALSE) {
                s.post(ICF.arithm((IntVar)BVAR, "=", 0));
            } else {
                s.post(ICF.arithm((IntVar)BVAR, "<=", CSTR.reif()));
            }
        }
    }

    public static void reification(BoolVar BVAR, Constraint CSTR) {
        Solver s = BVAR.getSolver();
        ESat entail = CSTR.isSatisfied();
        if (BVAR.isInstantiatedTo(1)) {
            s.post(CSTR);
        } else if (BVAR.isInstantiatedTo(0)) {
            s.post(LogicalConstraintFactory.not(CSTR));
        } else if (entail == ESat.TRUE) {
            s.post(ICF.arithm((IntVar)BVAR, "=", 1));
        } else if (entail == ESat.FALSE) {
            s.post(ICF.arithm((IntVar)BVAR, "=", 0));
        } else {
            CSTR.reifyWith(BVAR);
        }
    }

    public static Constraint ifThenElse_reifiable(Constraint IF, Constraint THEN, Constraint ELSE) {
        return LogicalConstraintFactory.ifThenElse_reifiable(IF.reif(), THEN, ELSE);
    }

    public static Constraint ifThenElse_reifiable(BoolVar BVAR, Constraint THEN, Constraint ELSE) {
        return LogicalConstraintFactory.and(LogicalConstraintFactory.ifThen_reifiable(BVAR, THEN), LogicalConstraintFactory.ifThen_reifiable(BVAR.not(), ELSE));
    }

    public static Constraint ifThen_reifiable(Constraint IF, Constraint THEN) {
        return LogicalConstraintFactory.ifThen_reifiable(IF.reif(), THEN);
    }

    public static Constraint ifThen_reifiable(BoolVar BVAR, Constraint CSTR) {
        Solver s = BVAR.getSolver();
        ESat entail = CSTR.isSatisfied();
        if (BVAR.isInstantiatedTo(0) || BVAR.isInstantiatedTo(1) && entail == ESat.TRUE) {
            return s.TRUE;
        }
        if (BVAR.isInstantiatedTo(1) && entail == ESat.FALSE) {
            return s.FALSE;
        }
        return ICF.arithm((IntVar)BVAR, "<=", CSTR.reif());
    }

    public static Constraint reification_reifiable(BoolVar BVAR, Constraint CSTR) {
        Solver s = BVAR.getSolver();
        ESat entail = CSTR.isSatisfied();
        if (BVAR.isInstantiated() && entail != ESat.UNDEFINED) {
            if (BVAR.getValue() == 1 && entail == ESat.TRUE || BVAR.getValue() == 0 && entail == ESat.FALSE) {
                return s.TRUE;
            }
            return s.FALSE;
        }
        return ICF.arithm((IntVar)BVAR, "=", CSTR.reif());
    }
}

