/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import gnu.trove.map.hash.THashMap;

public enum Operator {
    NONE(-1),
    EQ(0),
    LT(1),
    GT(2),
    NQ(3),
    LE(4),
    GE(5),
    PL(6),
    MN(7);

    int num;
    static THashMap<String, Operator> operators;

    private Operator(int num) {
        this.num = num;
    }

    public static Operator get(String name) {
        return operators.get(name);
    }

    public String toString() {
        switch (this) {
            case LT: {
                return "<";
            }
            case GT: {
                return ">";
            }
            case LE: {
                return "<=";
            }
            case GE: {
                return ">=";
            }
            case NQ: {
                return "!=";
            }
            case EQ: {
                return "=";
            }
            case PL: {
                return "+";
            }
            case MN: {
                return "-";
            }
        }
        throw new UnsupportedOperationException();
    }

    public static String getFlip(String operator) {
        switch (Operator.get(operator)) {
            case LT: {
                return ">";
            }
            case GT: {
                return "<";
            }
            case LE: {
                return ">=";
            }
            case GE: {
                return "<=";
            }
        }
        return operator;
    }

    public static Operator getOpposite(Operator operator) {
        switch (operator) {
            case LT: {
                return GE;
            }
            case GT: {
                return LE;
            }
            case LE: {
                return GT;
            }
            case GE: {
                return LT;
            }
            case NQ: {
                return EQ;
            }
            case EQ: {
                return NQ;
            }
            case PL: {
                return MN;
            }
            case MN: {
                return PL;
            }
        }
        throw new UnsupportedOperationException();
    }

    static {
        operators = new THashMap();
        operators.put("@", NONE);
        operators.put("=", EQ);
        operators.put(">", GT);
        operators.put(">=", GE);
        operators.put("<", LT);
        operators.put("<=", LE);
        operators.put("!=", NQ);
        operators.put("+", PL);
        operators.put("-", MN);
    }
}

