/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import gnu.trove.map.hash.THashMap;
import java.io.Serializable;
import java.util.Arrays;
import org.chocosolver.memory.structure.Operation;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Identity;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Propagator<V extends Variable>
implements Serializable,
ICause,
Identity,
Comparable<Propagator> {
    private static final long serialVersionUID = 2L;
    protected static final Logger LOGGER = LoggerFactory.getLogger(Propagator.class);
    protected static final short NEW = 0;
    protected static final short REIFIED = 1;
    protected static final short ACTIVE = 2;
    protected static final short PASSIVE = 3;
    private final int ID;
    private short state;
    private Operation[] operations;
    private int nbPendingEvt = 0;
    public long fineERcalls;
    public long coarseERcalls;
    protected Propagator aCause;
    protected final PropagatorPriority priority;
    protected final boolean reactToFineEvt;
    protected Constraint constraint;
    protected final Solver solver;
    protected V[] vars;
    private int[] vindices;

    protected Propagator(V[] vars, PropagatorPriority priority, boolean reactToFineEvt) {
        assert (vars != null && vars.length > 0 && vars[0] != null) : "wrong variable set in propagator constructor";
        this.solver = vars[0].getSolver();
        this.reactToFineEvt = reactToFineEvt;
        this.state = 0;
        this.priority = priority;
        this.aCause = this;
        this.vars = vars;
        this.vindices = new int[vars.length];
        for (int v = 0; v < vars.length; ++v) {
            this.vindices[v] = vars[v].link(this, v);
        }
        this.ID = this.solver.nextId();
        this.operations = new Operation[]{new Operation(){

            @Override
            public void undo() {
                Propagator.this.state = (short)0;
            }
        }, new Operation(){

            @Override
            public void undo() {
                Propagator.this.state = (short)1;
            }
        }, new Operation(){

            @Override
            public void undo() {
                Propagator.this.state = (short)2;
            }
        }};
    }

    @SafeVarargs
    protected Propagator(V ... vars) {
        this((Variable[])vars, PropagatorPriority.LINEAR, false);
    }

    @SafeVarargs
    protected final void addVariable(V ... nvars) {
        V[] tmp = this.vars;
        this.vars = (Variable[])Arrays.copyOf(this.vars, this.vars.length + nvars.length);
        System.arraycopy(tmp, 0, this.vars, 0, tmp.length);
        System.arraycopy(nvars, 0, this.vars, tmp.length, nvars.length);
        int[] itmp = this.vindices;
        this.vindices = new int[this.vars.length];
        System.arraycopy(itmp, 0, this.vindices, 0, itmp.length);
        for (int v = tmp.length; v < this.vars.length; ++v) {
            this.vindices[v] = this.vars[v].link(this, v);
        }
    }

    public void defineIn(Constraint c) {
        this.constraint = c;
    }

    protected int getPropagationConditions(int vIdx) {
        return 255;
    }

    public abstract void propagate(int var1) throws ContradictionException;

    public boolean advise(int idxVarInProp, int mask) {
        return (mask & this.getPropagationConditions(idxVarInProp)) != 0;
    }

    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (this.reactToFineEvt) {
            throw new SolverException(this + " has been declared to ignore which variable is modified.\n" + "To change the configuration, consider:\n" + "- to set 'reactToFineEvt' to false or,\n" + "- to override the following methode:\n" + "\t'public void propagate(int idxVarInProp, int mask) throws ContradictionException'." + "The latter enables incrementality but also to delay calls to complex filtering algorithm (see the method 'forcePropagate(EventType evt)'.");
        }
        this.propagate(PropagatorEventType.CUSTOM_PROPAGATION.getStrengthenedMask());
    }

    public final void forcePropagate(PropagatorEventType evt) throws ContradictionException {
        this.solver.getEngine().delayedPropagation(this, evt);
    }

    public void setActive() {
        assert (this.isStateLess()) : "the propagator is already active, it cannot set active";
        this.state = (short)2;
        this.solver.getEnvironment().save(this.operations[0]);
        for (int v = 0; v < this.vars.length; ++v) {
            this.vars[v].recordMask(this.getPropagationConditions(v));
        }
    }

    public void setReifiedTrue() {
        assert (this.isReifiedAndSilent()) : "the propagator was not in a silent reified state";
        this.state = (short)2;
        this.solver.getEnvironment().save(this.operations[1]);
        for (int v = 0; v < this.vars.length; ++v) {
            this.vars[v].recordMask(this.getPropagationConditions(v));
        }
    }

    public void setReifiedSilent() {
        assert (this.isStateLess() || this.isReifiedAndSilent()) : "the propagator was neither stateless nor reified";
        this.state = 1;
    }

    public void setPassive() {
        if (!this.isCompletelyInstantiated()) {
            assert (this.isActive()) : this.toString() + " is already passive, it cannot set passive more than once in one filtering call";
            this.state = (short)3;
            this.solver.getEnvironment().save(this.operations[2]);
            this.solver.getEngine().desactivatePropagator(this);
        }
    }

    public abstract ESat isEntailed();

    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        e.add(xengine.getPropagatorActivation(this));
        for (V v : this.vars) {
            v.explain(xengine, VariableState.DOM, e);
        }
    }

    public boolean isCompletelyInstantiated() {
        for (int i = 0; i < this.vars.length; ++i) {
            if (this.vars[i].isInstantiated()) continue;
            return false;
        }
        return true;
    }

    public void incNbPendingEvt() {
        assert (this.nbPendingEvt >= 0) : "number of enqued records is < 0 " + this;
        ++this.nbPendingEvt;
    }

    public void decNbPendingEvt() {
        assert (this.nbPendingEvt > 0) : "number of enqued records is < 0 " + this;
        --this.nbPendingEvt;
    }

    public void flushPendingEvt() {
        this.nbPendingEvt = 0;
    }

    public int arity() {
        int arity = 0;
        for (int i = 0; i < this.vars.length; ++i) {
            arity += this.vars[i].isInstantiated() ? 0 : 1;
        }
        return arity;
    }

    public int dynPriority() {
        int arity = 0;
        for (int i = 0; i < this.vars.length && arity <= 3; arity += this.vars[i].isInstantiated() ? 0 : 1, ++i) {
        }
        if (arity > 3) {
            return this.priority.priority;
        }
        return arity;
    }

    public void contradiction(Variable variable, String message) throws ContradictionException {
        this.solver.getEngine().fails(this.aCause, variable, message);
    }

    @Override
    public int compareTo(Propagator o) {
        return this.ID - o.ID;
    }

    @Override
    public int getId() {
        return this.ID;
    }

    public Solver getSolver() {
        return this.solver;
    }

    public int hashCode() {
        return this.ID;
    }

    public int getNbPendingEvt() {
        return this.nbPendingEvt;
    }

    public final V getVar(int i) {
        return this.vars[i];
    }

    public final V[] getVars() {
        return this.vars;
    }

    public int[] getVIndices() {
        return this.vindices;
    }

    public void setVIndices(int idx, int val) {
        this.vindices[idx] = val;
    }

    public final int getNbVars() {
        return this.vars.length;
    }

    public final Constraint getConstraint() {
        return this.constraint;
    }

    public final PropagatorPriority getPriority() {
        return this.priority;
    }

    public boolean isStateLess() {
        return this.state == 0;
    }

    public boolean isReifiedAndSilent() {
        return this.state == 1;
    }

    public boolean isActive() {
        return this.state == 2;
    }

    public boolean isPassive() {
        return this.state == 3;
    }

    public final boolean reactToFineEvent() {
        return this.reactToFineEvt;
    }

    public String toString() {
        StringBuilder st = new StringBuilder();
        st.append(this.getClass().getSimpleName()).append("(");
        int i = 0;
        switch (this.vars.length) {
            case 0: {
                break;
            }
            default: {
                st.append(this.vars[i++].getName()).append(", ");
            }
            case 2: {
                st.append(this.vars[i++].getName()).append(", ");
            }
            case 1: {
                st.append(this.vars[i++].getName());
            }
        }
        if (i < this.vars.length) {
            if (this.vars.length > 4) {
                st.append(", ...");
            }
            st.append(", ").append(this.vars[this.vars.length - 1].getName());
        }
        st.append(')');
        return st.toString();
    }

    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        throw new SolverException("The propagator cannot be duplicated: the method is not defined.");
    }
}

