/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import gnu.trove.list.array.TIntArrayList;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.nary.cnf.ILogical;
import org.chocosolver.solver.constraints.nary.cnf.LogOp;
import org.chocosolver.solver.constraints.nary.cnf.LogicTreeToolBox;
import org.chocosolver.solver.constraints.nary.cnf.PropSat;
import org.chocosolver.solver.constraints.nary.cnf.SatSolver;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.VF;
import org.chocosolver.util.tools.StringUtils;

public class SatFactory {
    private SatFactory() {
    }

    private static boolean buildOnLogicalOperator(LogOp logOp, Solver solver) {
        PropSat sat = solver.getMinisat().getPropSat();
        ILogical tree = LogicTreeToolBox.toCNF(logOp, solver);
        if (solver.ONE.equals(tree)) {
            return SatFactory.addTrue(solver.ONE);
        }
        if (solver.ZERO.equals(tree)) {
            return SatFactory.addTrue(solver.ZERO);
        }
        ILogical[] clauses = !tree.isLit() && ((LogOp)tree).is(LogOp.Operator.AND) ? ((LogOp)tree).getChildren() : new ILogical[]{tree};
        boolean ret = true;
        for (int i = 0; i < clauses.length; ++i) {
            ILogical clause = clauses[i];
            if (clause.isLit()) {
                BoolVar bv = (BoolVar)clause;
                ret &= SatFactory.addTrue(bv);
                continue;
            }
            LogOp n = (LogOp)clause;
            BoolVar[] bvars = n.flattenBoolVar();
            TIntArrayList lits = new TIntArrayList(bvars.length);
            for (int j = 0; j < bvars.length; ++j) {
                lits.add(sat.Literal(bvars[j]));
            }
            ret &= sat.addClause(lits);
        }
        return ret;
    }

    public static boolean addClauses(LogOp TREE, Solver SOLVER) {
        return SatFactory.buildOnLogicalOperator(TREE, SOLVER);
    }

    public static boolean addClauses(BoolVar[] POSLITS, BoolVar[] NEGLITS) {
        int i;
        Solver solver = POSLITS.length > 0 ? POSLITS[0].getSolver() : NEGLITS[0].getSolver();
        PropSat sat = solver.getMinisat().getPropSat();
        TIntArrayList lits = new TIntArrayList(POSLITS.length + NEGLITS.length);
        for (i = 0; i < POSLITS.length; ++i) {
            lits.add(sat.Literal(POSLITS[i]));
        }
        for (i = 0; i < NEGLITS.length; ++i) {
            lits.add(SatSolver.negated(sat.Literal(NEGLITS[i])));
        }
        sat.addClause(lits);
        return true;
    }

    public static boolean addTrue(BoolVar BOOLVAR) {
        Solver solver = BOOLVAR.getSolver();
        PropSat sat = solver.getMinisat().getPropSat();
        int lit = sat.Literal(BOOLVAR);
        sat.addClause(lit);
        return true;
    }

    public static boolean addFalse(BoolVar BOOLVAR) {
        Solver solver = BOOLVAR.getSolver();
        PropSat sat = solver.getMinisat().getPropSat();
        int lit = SatSolver.negated(sat.Literal(BOOLVAR));
        sat.addClause(lit);
        return true;
    }

    public static boolean addBoolEq(BoolVar LEFT, BoolVar RIGHT) {
        Solver solver = LEFT.getSolver();
        PropSat sat = solver.getMinisat().getPropSat();
        int left_lit = sat.Literal(LEFT);
        int right_lit = sat.Literal(RIGHT);
        sat.addClause(SatSolver.negated(left_lit), right_lit);
        sat.addClause(left_lit, SatSolver.negated(right_lit));
        return true;
    }

    public static boolean addBoolLe(BoolVar LEFT, BoolVar RIGHT) {
        Solver solver = LEFT.getSolver();
        PropSat sat = solver.getMinisat().getPropSat();
        int left_lit = sat.Literal(LEFT);
        int right_lit = sat.Literal(RIGHT);
        sat.addClause(SatSolver.negated(left_lit), right_lit);
        return true;
    }

    public static boolean addBoolLt(BoolVar LEFT, BoolVar RIGHT) {
        Solver solver = LEFT.getSolver();
        PropSat sat = solver.getMinisat().getPropSat();
        int left_lit = sat.Literal(LEFT);
        int right_lit = sat.Literal(RIGHT);
        sat.addClause(right_lit);
        sat.addClause(SatSolver.negated(left_lit), SatSolver.negated(right_lit));
        return true;
    }

    public static boolean addBoolNot(BoolVar LEFT, BoolVar RIGHT) {
        Solver solver = LEFT.getSolver();
        PropSat sat = solver.getMinisat().getPropSat();
        int left_lit = sat.Literal(LEFT);
        int right_lit = sat.Literal(RIGHT);
        sat.addClause(SatSolver.negated(left_lit), SatSolver.negated(right_lit));
        sat.addClause(left_lit, right_lit);
        return true;
    }

    public static boolean addBoolOrArrayEqVar(BoolVar[] BOOLVARS, BoolVar TARGET) {
        int i;
        Solver solver = TARGET.getSolver();
        PropSat sat = solver.getMinisat().getPropSat();
        int target_lit = sat.Literal(TARGET);
        TIntArrayList lits = new TIntArrayList(BOOLVARS.length + 1);
        for (i = 0; i < BOOLVARS.length; ++i) {
            lits.add(sat.Literal(BOOLVARS[i]));
        }
        lits.add(SatSolver.negated(target_lit));
        sat.addClause(lits);
        for (i = 0; i < BOOLVARS.length; ++i) {
            sat.addClause(target_lit, SatSolver.negated(sat.Literal(BOOLVARS[i])));
        }
        return true;
    }

    public static boolean addBoolAndArrayEqVar(BoolVar[] BOOLVARS, BoolVar TARGET) {
        int i;
        Solver solver = TARGET.getSolver();
        PropSat sat = solver.getMinisat().getPropSat();
        int target_lit = sat.Literal(TARGET);
        TIntArrayList lits = new TIntArrayList(BOOLVARS.length + 1);
        for (i = 0; i < BOOLVARS.length; ++i) {
            lits.add(SatSolver.negated(sat.Literal(BOOLVARS[i])));
        }
        lits.add(target_lit);
        sat.addClause(lits);
        for (i = 0; i < BOOLVARS.length; ++i) {
            sat.addClause(SatSolver.negated(target_lit), sat.Literal(BOOLVARS[i]));
        }
        return true;
    }

    public static boolean addBoolOrEqVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        Solver solver = TARGET.getSolver();
        PropSat sat = solver.getMinisat().getPropSat();
        int left_lit = sat.Literal(LEFT);
        int right_lit = sat.Literal(RIGHT);
        int target_lit = sat.Literal(TARGET);
        sat.addClause(left_lit, right_lit, SatSolver.negated(target_lit));
        sat.addClause(SatSolver.negated(left_lit), target_lit);
        sat.addClause(SatSolver.negated(right_lit), target_lit);
        return true;
    }

    public static boolean addBoolAndEqVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        Solver solver = TARGET.getSolver();
        PropSat sat = solver.getMinisat().getPropSat();
        int left_lit = sat.Literal(LEFT);
        int right_lit = sat.Literal(RIGHT);
        int target_lit = sat.Literal(TARGET);
        sat.addClause(SatSolver.negated(left_lit), SatSolver.negated(right_lit), target_lit);
        sat.addClause(left_lit, SatSolver.negated(target_lit));
        sat.addClause(right_lit, SatSolver.negated(target_lit));
        return true;
    }

    public static boolean addBoolXorEqVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        return SatFactory.addBoolIsNeqVar(LEFT, RIGHT, TARGET);
    }

    public static boolean addBoolIsEqVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        Solver solver = TARGET.getSolver();
        PropSat sat = solver.getMinisat().getPropSat();
        int left_lit = sat.Literal(LEFT);
        int right_lit = sat.Literal(RIGHT);
        int target_lit = sat.Literal(TARGET);
        sat.addClause(SatSolver.negated(left_lit), right_lit, SatSolver.negated(target_lit));
        sat.addClause(left_lit, SatSolver.negated(right_lit), SatSolver.negated(target_lit));
        sat.addClause(left_lit, right_lit, target_lit);
        sat.addClause(SatSolver.negated(left_lit), SatSolver.negated(right_lit), target_lit);
        return true;
    }

    public static boolean addBoolIsNeqVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        Solver solver = TARGET.getSolver();
        PropSat sat = solver.getMinisat().getPropSat();
        int left_lit = sat.Literal(LEFT);
        int right_lit = sat.Literal(RIGHT);
        int target_lit = sat.Literal(TARGET);
        sat.addClause(SatSolver.negated(left_lit), right_lit, target_lit);
        sat.addClause(left_lit, SatSolver.negated(right_lit), target_lit);
        sat.addClause(left_lit, right_lit, SatSolver.negated(target_lit));
        sat.addClause(SatSolver.negated(left_lit), SatSolver.negated(right_lit), SatSolver.negated(target_lit));
        return true;
    }

    public static boolean addBoolIsLeVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        Solver solver = TARGET.getSolver();
        PropSat sat = solver.getMinisat().getPropSat();
        int left_lit = sat.Literal(LEFT);
        int right_lit = sat.Literal(RIGHT);
        int target_lit = sat.Literal(TARGET);
        sat.addClause(SatSolver.negated(left_lit), right_lit, SatSolver.negated(target_lit));
        sat.addClause(left_lit, target_lit);
        sat.addClause(SatSolver.negated(right_lit), target_lit);
        return true;
    }

    public static boolean addBoolIsLtVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        Solver solver = TARGET.getSolver();
        PropSat sat = solver.getMinisat().getPropSat();
        int left_lit = sat.Literal(LEFT);
        int right_lit = sat.Literal(RIGHT);
        int target_lit = sat.Literal(TARGET);
        sat.addClause(left_lit, right_lit, SatSolver.negated(target_lit));
        sat.addClause(SatSolver.negated(left_lit), right_lit, SatSolver.negated(target_lit));
        sat.addClause(left_lit, SatSolver.negated(right_lit), target_lit);
        sat.addClause(SatSolver.negated(left_lit), SatSolver.negated(right_lit), SatSolver.negated(target_lit));
        return true;
    }

    public static boolean addBoolOrArrayEqualTrue(BoolVar[] BOOLVARS) {
        Solver solver = BOOLVARS[0].getSolver();
        PropSat sat = solver.getMinisat().getPropSat();
        TIntArrayList lits = new TIntArrayList(BOOLVARS.length);
        for (int i = 0; i < BOOLVARS.length; ++i) {
            lits.add(sat.Literal(BOOLVARS[i]));
        }
        sat.addClause(lits);
        return true;
    }

    public static boolean addBoolAndArrayEqualFalse(BoolVar[] BOOLVARS) {
        return SatFactory.addAtMostNMinusOne(BOOLVARS);
    }

    public static boolean addAtMostOne(BoolVar[] BOOLVARS) {
        int i;
        Solver solver = BOOLVARS[0].getSolver();
        PropSat sat = solver.getMinisat().getPropSat();
        TIntArrayList lits = new TIntArrayList(BOOLVARS.length);
        for (i = 0; i < BOOLVARS.length; ++i) {
            lits.add(SatSolver.negated(sat.Literal(BOOLVARS[i])));
        }
        for (i = 0; i < lits.size() - 1; ++i) {
            for (int j = i + 1; j < lits.size(); ++j) {
                sat.addClause(lits.get(i), lits.get(j));
            }
        }
        return true;
    }

    public static boolean addAtMostNMinusOne(BoolVar[] BOOLVARS) {
        Solver solver = BOOLVARS[0].getSolver();
        PropSat sat = solver.getMinisat().getPropSat();
        TIntArrayList lits = new TIntArrayList(BOOLVARS.length);
        for (int i = 0; i < BOOLVARS.length; ++i) {
            lits.add(SatSolver.negated(sat.Literal(BOOLVARS[i])));
        }
        sat.addClause(lits);
        return true;
    }

    public static boolean addSumBoolArrayGreaterEqVar(BoolVar[] BOOLVARS, BoolVar TARGET) {
        Solver solver = BOOLVARS[0].getSolver();
        PropSat sat = solver.getMinisat().getPropSat();
        TIntArrayList lits = new TIntArrayList(BOOLVARS.length + 1);
        for (int i = 0; i < BOOLVARS.length; ++i) {
            lits.add(sat.Literal(BOOLVARS[i]));
        }
        lits.add(SatSolver.negated(sat.Literal(TARGET)));
        sat.addClause(lits);
        return true;
    }

    public static boolean addMaxBoolArrayLessEqVar(BoolVar[] BOOLVARS, BoolVar TARGET) {
        Solver solver = BOOLVARS[0].getSolver();
        PropSat sat = solver.getMinisat().getPropSat();
        int tlit = sat.Literal(TARGET);
        for (int i = 0; i < BOOLVARS.length; ++i) {
            sat.addClause(SatSolver.negated(sat.Literal(BOOLVARS[i])), tlit);
        }
        return true;
    }

    public static boolean addSumBoolArrayLessEqVar(BoolVar[] BOOLVARS, BoolVar TARGET) {
        int i;
        Solver solver = BOOLVARS[0].getSolver();
        PropSat sat = solver.getMinisat().getPropSat();
        if (BOOLVARS.length == 1) {
            return SatFactory.addBoolLe(BOOLVARS[0], TARGET);
        }
        BoolVar extra = VF.bool(StringUtils.randomName(), solver);
        int tlit = sat.Literal(TARGET);
        int elit = sat.Literal(extra);
        TIntArrayList lits = new TIntArrayList(BOOLVARS.length + 1);
        for (i = 0; i < BOOLVARS.length; ++i) {
            lits.add(sat.Literal(BOOLVARS[i]));
        }
        lits.add(SatSolver.negated(elit));
        sat.addClause(lits);
        for (i = 0; i < BOOLVARS.length; ++i) {
            sat.addClause(elit, SatSolver.negated(sat.Literal(BOOLVARS[i])));
        }
        sat.addClause(SatSolver.negated(elit), tlit);
        return true;
    }
}

