/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.binary.PropDistanceXYC;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.ArrayUtils;

public class DistanceXYC
extends Constraint {
    final IntVar X;
    final IntVar Y;
    final int C;
    final Operator operator;

    public DistanceXYC(IntVar X, IntVar Y, Operator operator, int C) {
        super("DistanceXYC " + operator.name(), new PropDistanceXYC(ArrayUtils.toArray(X, Y), operator, C));
        if (operator != Operator.EQ && operator != Operator.GT && operator != Operator.LT && operator != Operator.NQ) {
            throw new SolverException("Unexpected operator for distance");
        }
        this.X = X;
        this.Y = Y;
        this.C = C;
        this.operator = operator;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            this.X.duplicate(solver, identitymap);
            IntVar X = (IntVar)identitymap.get(this.X);
            this.Y.duplicate(solver, identitymap);
            IntVar Y = (IntVar)identitymap.get(this.Y);
            DistanceXYC clone = new DistanceXYC(X, Y, this.operator, this.C);
            identitymap.put(this.propagators[0], clone.getPropagator(0));
            identitymap.put(this, clone);
        }
    }
}

