/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.ValueRemoval;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.UnaryIntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropAbsolute
extends Propagator<IntVar> {
    protected RemProc rem_proc;
    protected IIntDeltaMonitor[] idms;
    protected IntVar X;
    protected IntVar Y;
    protected boolean bothEnumerated;

    public PropAbsolute(IntVar X, IntVar Y) {
        super((Variable[])ArrayUtils.toArray(X, Y), PropagatorPriority.BINARY, true);
        this.X = ((IntVar[])this.vars)[0];
        this.Y = ((IntVar[])this.vars)[1];
        boolean bl = this.bothEnumerated = X.hasEnumeratedDomain() && Y.hasEnumeratedDomain();
        if (this.bothEnumerated) {
            this.rem_proc = new RemProc();
            this.idms = new IIntDeltaMonitor[((IntVar[])this.vars).length];
            for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
                this.idms[i] = ((IntVar[])this.vars)[i].hasEnumeratedDomain() ? ((IntVar[])this.vars)[i].monitorDelta(this) : IIntDeltaMonitor.Default.NONE;
            }
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (this.bothEnumerated) {
            return IntEventType.all();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public ESat isEntailed() {
        if (((IntVar[])this.vars)[0].getUB() < 0) {
            return ESat.FALSE;
        }
        if (((IntVar[])this.vars)[0].isInstantiated()) {
            if (((IntVar[])this.vars)[1].isInstantiated()) {
                return ESat.eval(((IntVar[])this.vars)[0].getValue() == Math.abs(((IntVar[])this.vars)[1].getValue()));
            }
            if (((IntVar[])this.vars)[1].getDomainSize() == 2 && ((IntVar[])this.vars)[1].contains(((IntVar[])this.vars)[0].getValue()) && ((IntVar[])this.vars)[1].contains(-((IntVar[])this.vars)[0].getValue())) {
                return ESat.TRUE;
            }
            if (!((IntVar[])this.vars)[1].contains(((IntVar[])this.vars)[0].getValue()) && !((IntVar[])this.vars)[1].contains(-((IntVar[])this.vars)[0].getValue())) {
                return ESat.FALSE;
            }
            return ESat.UNDEFINED;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return String.format("%s = |%s|", ((IntVar[])this.vars)[0].toString(), ((IntVar[])this.vars)[1].toString());
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.X.updateLowerBound(0, this.aCause);
        this.setBounds();
        if (this.bothEnumerated) {
            this.enumeratedFiltering();
            this.idms[0].unfreeze();
            this.idms[1].unfreeze();
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        if (this.bothEnumerated) {
            this.idms[varIdx].freeze();
            this.idms[varIdx].forEachRemVal(this.rem_proc.set(varIdx));
            this.idms[varIdx].unfreeze();
        } else {
            this.setBounds();
        }
    }

    private void setBounds() throws ContradictionException {
        int max = this.X.getUB();
        int min = this.X.getLB();
        this.Y.updateUpperBound(max, this.aCause);
        this.Y.updateLowerBound(-max, this.aCause);
        this.Y.removeInterval(1 - min, min - 1, this.aCause);
        int prevLB = this.X.getLB();
        int prevUB = this.X.getUB();
        min = this.Y.getLB();
        max = this.Y.getUB();
        if (max <= 0) {
            this.X.updateLowerBound(-max, this.aCause);
            this.X.updateUpperBound(-min, this.aCause);
        } else if (min >= 0) {
            this.X.updateLowerBound(min, this.aCause);
            this.X.updateUpperBound(max, this.aCause);
        } else {
            if (this.Y.hasEnumeratedDomain()) {
                int mP = this.Y.nextValue(-1);
                int mN = -this.Y.previousValue(1);
                this.X.updateLowerBound(Math.min(mP, mN), this.aCause);
            }
            this.X.updateUpperBound(Math.max(-min, max), this.aCause);
        }
        if (prevLB != this.X.getLB() || prevUB != this.X.getUB()) {
            this.setBounds();
        }
    }

    private void enumeratedFiltering() throws ContradictionException {
        int min = this.X.getLB();
        int max = this.X.getUB();
        int v = min;
        while (v <= max) {
            if (!this.Y.contains(v) && !this.Y.contains(-v)) {
                this.X.removeValue(v, this.aCause);
            }
            v = this.X.nextValue(v);
        }
        min = this.Y.getLB();
        max = this.Y.getUB();
        v = min;
        while (v <= max) {
            if (!this.X.contains(Math.abs(v))) {
                this.Y.removeValue(v, this.aCause);
            }
            v = this.Y.nextValue(v);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        if (d.getVar() == ((IntVar[])this.vars)[0]) {
            e.add(xengine.getPropagatorActivation(this));
            if (d.getmType() != Deduction.Type.ValRem) throw new UnsupportedOperationException("PropAbsolute only knows how to explain ValueRemovals");
            ((IntVar[])this.vars)[1].explain(xengine, VariableState.REM, ((ValueRemoval)d).getVal(), e);
            ((IntVar[])this.vars)[1].explain(xengine, VariableState.REM, -((ValueRemoval)d).getVal(), e);
            return;
        } else if (d.getVar() == ((IntVar[])this.vars)[1]) {
            e.add(xengine.getPropagatorActivation(this));
            if (d.getmType() != Deduction.Type.ValRem) throw new UnsupportedOperationException("PropAbsolute only knows how to explain ValueRemovals");
            ((IntVar[])this.vars)[0].explain(xengine, VariableState.REM, Math.abs(((ValueRemoval)d).getVal()), e);
            return;
        } else {
            super.explain(xengine, d, e);
        }
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            ((IntVar[])this.vars)[0].duplicate(solver, identitymap);
            IntVar X = (IntVar)identitymap.get(((IntVar[])this.vars)[0]);
            ((IntVar[])this.vars)[1].duplicate(solver, identitymap);
            IntVar Y = (IntVar)identitymap.get(((IntVar[])this.vars)[1]);
            identitymap.put(this, new PropAbsolute(X, Y));
        }
    }

    private class RemProc
    implements UnaryIntProcedure<Integer> {
        private int var;

        private RemProc() {
        }

        @Override
        public UnaryIntProcedure set(Integer idxVar) {
            this.var = idxVar;
            return this;
        }

        @Override
        public void execute(int val) throws ContradictionException {
            if (this.var == 0) {
                ((IntVar[])PropAbsolute.this.vars)[1].removeValue(val, PropAbsolute.this.aCause);
                ((IntVar[])PropAbsolute.this.vars)[1].removeValue(-val, PropAbsolute.this.aCause);
            } else if (!((IntVar[])PropAbsolute.this.vars)[1].contains(-val)) {
                ((IntVar[])PropAbsolute.this.vars)[0].removeValue(Math.abs(val), PropAbsolute.this.aCause);
            }
        }
    }
}

