/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.procedure.UnaryIntProcedure;

public class PropDistanceXYC
extends Propagator<IntVar> {
    protected final Operator operator;
    protected final int cste;
    protected final RemProc remproc;
    protected final IIntDeltaMonitor[] idms;

    public PropDistanceXYC(IntVar[] vars, Operator operator, int cste) {
        super((Variable[])vars, PropagatorPriority.BINARY, true);
        if (operator == Operator.EQ) {
            this.idms = new IIntDeltaMonitor[((IntVar[])this.vars).length];
            for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
                this.idms[i] = vars[i].hasEnumeratedDomain() ? ((IntVar[])this.vars)[i].monitorDelta(this) : IIntDeltaMonitor.Default.NONE;
            }
        } else {
            this.idms = new IIntDeltaMonitor[0];
        }
        this.operator = operator;
        this.cste = cste;
        this.remproc = new RemProc(this);
    }

    @Override
    public int getPropagationConditions(int idx) {
        if (((IntVar[])this.vars)[idx].hasEnumeratedDomain()) {
            return IntEventType.all();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.cste < 0) {
            switch (this.operator) {
                case EQ: 
                case LT: {
                    this.contradiction(null, "< or = to 0");
                    break;
                }
                case NQ: 
                case GT: {
                    this.setPassive();
                }
            }
        }
        if (this.operator == Operator.EQ) {
            if (((IntVar[])this.vars)[0].hasEnumeratedDomain()) {
                this.filterFromVarToVar(((IntVar[])this.vars)[0], ((IntVar[])this.vars)[1]);
            } else {
                ((IntVar[])this.vars)[0].updateLowerBound(((IntVar[])this.vars)[1].getLB() - this.cste, this.aCause);
                ((IntVar[])this.vars)[0].updateUpperBound(((IntVar[])this.vars)[1].getUB() + this.cste, this.aCause);
            }
            if (((IntVar[])this.vars)[1].hasEnumeratedDomain()) {
                this.filterFromVarToVar(((IntVar[])this.vars)[1], ((IntVar[])this.vars)[0]);
            } else {
                ((IntVar[])this.vars)[1].updateLowerBound(((IntVar[])this.vars)[0].getLB() - this.cste, this.aCause);
                ((IntVar[])this.vars)[1].updateUpperBound(((IntVar[])this.vars)[0].getUB() + this.cste, this.aCause);
            }
        } else if (this.operator == Operator.GT) {
            this.filterGT();
        } else if (this.operator == Operator.LT) {
            this.filterLT();
        } else {
            this.filterNeq();
        }
        for (int i = 0; i < this.idms.length; ++i) {
            this.idms[i].unfreeze();
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        int idx2 = varIdx == 0 ? 1 : 0;
        switch (this.operator) {
            case EQ: {
                if (IntEventType.isInstantiate(mask)) {
                    this.filterOnInst(((IntVar[])this.vars)[idx2], ((IntVar[])this.vars)[varIdx].getValue());
                    break;
                }
                if (IntEventType.isRemove(mask) && ((IntVar[])this.vars)[varIdx].hasEnumeratedDomain()) {
                    this.idms[varIdx].freeze();
                    this.idms[varIdx].forEachRemVal(this.remproc.set(varIdx));
                    this.idms[varIdx].unfreeze();
                }
                if (IntEventType.isInclow(mask)) {
                    this.filterOnInf(((IntVar[])this.vars)[varIdx], ((IntVar[])this.vars)[idx2]);
                }
                if (!IntEventType.isDecupp(mask)) break;
                this.filterOnSup(((IntVar[])this.vars)[varIdx], ((IntVar[])this.vars)[idx2]);
                break;
            }
            case NQ: {
                this.filterNeq();
                break;
            }
            case GT: {
                if (IntEventType.isInstantiate(mask)) {
                    this.filterGTonVar(((IntVar[])this.vars)[varIdx], ((IntVar[])this.vars)[idx2]);
                    break;
                }
                if (!IntEventType.isBound(mask)) break;
                this.filterGTonVar(((IntVar[])this.vars)[varIdx], ((IntVar[])this.vars)[idx2]);
                break;
            }
            case LT: {
                if (IntEventType.isInstantiate(mask)) {
                    this.filterLTonVar(((IntVar[])this.vars)[varIdx], ((IntVar[])this.vars)[idx2]);
                    break;
                }
                if (!IntEventType.isBound(mask)) break;
                this.filterLTonVar(((IntVar[])this.vars)[varIdx], ((IntVar[])this.vars)[idx2]);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            if (this.operator == Operator.EQ) {
                return ESat.eval(Math.abs(((IntVar[])this.vars)[0].getValue() - ((IntVar[])this.vars)[1].getValue()) == this.cste);
            }
            if (this.operator == Operator.LT) {
                return ESat.eval(Math.abs(((IntVar[])this.vars)[0].getValue() - ((IntVar[])this.vars)[1].getValue()) < this.cste);
            }
            if (this.operator == Operator.GT) {
                return ESat.eval(Math.abs(((IntVar[])this.vars)[0].getValue() - ((IntVar[])this.vars)[1].getValue()) > this.cste);
            }
            if (this.operator == Operator.NQ) {
                return ESat.eval(Math.abs(((IntVar[])this.vars)[0].getValue() - ((IntVar[])this.vars)[1].getValue()) != this.cste);
            }
            throw new SolverException("operator not known");
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        StringBuilder st = new StringBuilder();
        st.append("|").append(((IntVar[])this.vars)[0].getName()).append(" - ").append(((IntVar[])this.vars)[1].getName()).append("|");
        switch (this.operator) {
            case EQ: {
                st.append("=");
                break;
            }
            case GT: {
                st.append(">");
                break;
            }
            case LT: {
                st.append("<");
                break;
            }
            case NQ: {
                st.append("=/=");
            }
        }
        st.append(this.cste);
        return st.toString();
    }

    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        e.add(xengine.getPropagatorActivation(this));
        IntVar reason = d.getVar() == ((IntVar[])this.vars)[0] ? ((IntVar[])this.vars)[1] : ((IntVar[])this.vars)[0];
        reason.explain(xengine, VariableState.DOM, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterFromVarToVar(IntVar var1, IntVar var2) throws ContradictionException {
        DisposableRangeIterator it = var1.getRangeIterator(true);
        try {
            while (it.hasNext()) {
                int from = it.min();
                int to = it.max();
                for (int value = from; value <= to; ++value) {
                    if (var2.contains(value - this.cste) || var2.contains(value + this.cste)) continue;
                    var1.removeValue(value, this.aCause);
                }
                it.next();
            }
        }
        finally {
            it.dispose();
        }
    }

    public void filterGT() throws ContradictionException {
        if (this.cste >= 0) {
            int lbv0 = ((IntVar[])this.vars)[1].getUB() - this.cste;
            int ubv0 = ((IntVar[])this.vars)[1].getLB() + this.cste;
            ((IntVar[])this.vars)[0].removeInterval(lbv0, ubv0, this.aCause);
            int lbv1 = ((IntVar[])this.vars)[0].getUB() - this.cste;
            int ubv1 = ((IntVar[])this.vars)[0].getLB() + this.cste;
            ((IntVar[])this.vars)[1].removeInterval(lbv1, ubv1, this.aCause);
        } else {
            this.setPassive();
        }
    }

    public void filterGTonVar(IntVar v0, IntVar v1) throws ContradictionException {
        if (this.cste >= 0) {
            int lbv0 = v0.getUB() - this.cste;
            int ubv0 = v0.getLB() + this.cste;
            v1.removeInterval(lbv0, ubv0, this.aCause);
        } else {
            this.setPassive();
        }
    }

    public void filterLT() throws ContradictionException {
        ((IntVar[])this.vars)[0].updateLowerBound(((IntVar[])this.vars)[1].getLB() - this.cste + 1, this.aCause);
        ((IntVar[])this.vars)[0].updateUpperBound(((IntVar[])this.vars)[1].getUB() + this.cste - 1, this.aCause);
        ((IntVar[])this.vars)[1].updateLowerBound(((IntVar[])this.vars)[0].getLB() - this.cste + 1, this.aCause);
        ((IntVar[])this.vars)[1].updateUpperBound(((IntVar[])this.vars)[0].getUB() + this.cste - 1, this.aCause);
    }

    public void filterLTonVar(IntVar v0, IntVar v1) throws ContradictionException {
        v1.updateLowerBound(v0.getLB() - this.cste + 1, this.aCause);
        v1.updateUpperBound(v0.getUB() + this.cste - 1, this.aCause);
    }

    public void filterOnInf(IntVar v0, IntVar v1) throws ContradictionException {
        if (v1.hasEnumeratedDomain()) {
            int end = v0.getLB() + this.cste;
            int val = v0.getLB();
            while (val <= end) {
                if (!v0.contains(val - this.cste) && !v0.contains(val + this.cste)) {
                    v1.removeValue(val, this.aCause);
                }
                val = v1.nextValue(val);
            }
        } else {
            v1.updateLowerBound(v0.getLB() - this.cste, this.aCause);
        }
    }

    public void filterOnSup(IntVar v0, IntVar v1) throws ContradictionException {
        if (v1.hasEnumeratedDomain()) {
            int initval = v0.getUB() - this.cste > v1.getLB() ? v1.nextValue(v0.getUB() - this.cste - 1) : v1.getLB();
            int val = initval;
            do {
                if (v0.contains(val - this.cste) || v0.contains(val + this.cste)) continue;
                v1.removeValue(val, this.aCause);
            } while ((val = v1.nextValue(val)) <= v1.getUB() && val > initval);
        } else {
            v1.updateUpperBound(v0.getUB() + this.cste, this.aCause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterOnInst(IntVar v, int val) throws ContradictionException {
        if (!v.contains(val + this.cste)) {
            v.instantiateTo(val - this.cste, this.aCause);
        } else if (!v.contains(val - this.cste)) {
            v.instantiateTo(val + this.cste, this.aCause);
        } else if (v.hasEnumeratedDomain()) {
            DisposableRangeIterator rit = v.getRangeIterator(true);
            try {
                while (rit.hasNext()) {
                    int from = rit.min();
                    int to = rit.max();
                    for (int value = from; value <= to; ++value) {
                        if (value == val - this.cste || value == val + this.cste) continue;
                        v.removeValue(value, this.aCause);
                    }
                    rit.next();
                }
            }
            finally {
                rit.dispose();
            }
        } else {
            v.updateLowerBound(val - this.cste, this.aCause);
            v.updateUpperBound(val + this.cste, this.aCause);
        }
    }

    public void filterNeq() throws ContradictionException {
        if (this.cste >= 0) {
            if (((IntVar[])this.vars)[0].isInstantiated()) {
                ((IntVar[])this.vars)[1].removeValue(((IntVar[])this.vars)[0].getValue() + this.cste, this.aCause);
                ((IntVar[])this.vars)[1].removeValue(((IntVar[])this.vars)[0].getValue() - this.cste, this.aCause);
            }
            if (((IntVar[])this.vars)[1].isInstantiated()) {
                ((IntVar[])this.vars)[0].removeValue(((IntVar[])this.vars)[1].getValue() + this.cste, this.aCause);
                ((IntVar[])this.vars)[0].removeValue(((IntVar[])this.vars)[1].getValue() - this.cste, this.aCause);
            }
        } else {
            this.setPassive();
        }
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            identitymap.put(this, new PropDistanceXYC(aVars, this.operator, this.cste));
        }
    }

    private static class RemProc
    implements UnaryIntProcedure<Integer> {
        int idx;
        final PropDistanceXYC p;

        public RemProc(PropDistanceXYC p) {
            this.p = p;
        }

        @Override
        public UnaryIntProcedure set(Integer integer) {
            this.idx = integer;
            return this;
        }

        @Override
        public void execute(int i) throws ContradictionException {
            if (this.idx == 0) {
                if (!((IntVar[])this.p.vars)[0].contains(i + 2 * this.p.cste)) {
                    ((IntVar[])this.p.vars)[1].removeValue(i + this.p.cste, this.p);
                }
                if (!((IntVar[])this.p.vars)[0].contains(i - 2 * this.p.cste)) {
                    ((IntVar[])this.p.vars)[1].removeValue(i - this.p.cste, this.p);
                }
            } else {
                if (!((IntVar[])this.p.vars)[1].contains(i + 2 * this.p.cste)) {
                    ((IntVar[])this.p.vars)[0].removeValue(i + this.p.cste, this.p);
                }
                if (!((IntVar[])this.p.vars)[1].contains(i - 2 * this.p.cste)) {
                    ((IntVar[])this.p.vars)[0].removeValue(i - this.p.cste, this.p);
                }
            }
        }
    }
}

