/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.structure.Operation;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.tools.ArrayUtils;

public class PropElement
extends Propagator<IntVar> {
    int[] lval;
    int cste;
    private Sort s;

    public PropElement(IntVar value, int[] values, IntVar index, int offset, Sort s) {
        super((Variable[])ArrayUtils.toArray(value, index), PropagatorPriority.BINARY, true);
        this.lval = values;
        this.cste = offset;
        this.s = s;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        ((IntVar[])this.vars)[1].updateLowerBound(this.cste, this.aCause);
        ((IntVar[])this.vars)[1].updateUpperBound(this.lval.length - 1 + this.cste, this.aCause);
        this.filter(false, 2);
    }

    protected void filter(boolean startWithIndex, int nbRules) throws ContradictionException {
        boolean run;
        int nbR = 0;
        do {
            run = startWithIndex ? this.updateIndexFromValue() : this.updateValueFromIndex();
            startWithIndex ^= true;
        } while (run || ++nbR < nbRules);
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        if (IntEventType.isInstantiate(mask) && varIdx == 1) {
            ((IntVar[])this.vars)[0].instantiateTo(this.lval[((IntVar[])this.vars)[1].getValue() - this.cste], this.aCause);
            this.setPassive();
        }
        this.filter(true, varIdx == 0 ? 1 : 2);
    }

    @Override
    public ESat isEntailed() {
        if (((IntVar[])this.vars)[0].isInstantiated()) {
            boolean allVal = true;
            boolean oneVal = false;
            int ub = ((IntVar[])this.vars)[1].getUB();
            int val = ((IntVar[])this.vars)[1].getLB();
            while (val <= ub) {
                boolean b = val - this.cste >= 0 && val - this.cste < this.lval.length && this.lval[val - this.cste] == ((IntVar[])this.vars)[0].getValue();
                allVal &= b;
                oneVal |= b;
                val = ((IntVar[])this.vars)[1].nextValue(val);
            }
            if (allVal) {
                return ESat.TRUE;
            }
            if (oneVal) {
                return ESat.UNDEFINED;
            }
        } else {
            int ub = ((IntVar[])this.vars)[1].getUB();
            int val = ((IntVar[])this.vars)[1].getLB();
            while (val <= ub) {
                if (val - this.cste >= 0 && val - this.cste < this.lval.length && ((IntVar[])this.vars)[0].contains(this.lval[val - this.cste])) {
                    return ESat.UNDEFINED;
                }
                val = ((IntVar[])this.vars)[1].nextValue(val);
            }
        }
        return ESat.FALSE;
    }

    @Override
    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder(32);
        sb.append("nth(").append(((IntVar[])this.vars)[0]).append(" = ");
        sb.append(" <");
        for (i = 0; i < Math.min(this.lval.length - 1, 5); ++i) {
            sb.append(this.lval[i]).append(", ");
        }
        if (i == 5 && this.lval.length - 1 > 5) {
            sb.append("..., ");
        }
        sb.append(this.lval[this.lval.length - 1]);
        sb.append("> [").append(((IntVar[])this.vars)[1]).append("])");
        return sb.toString();
    }

    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        e.add(xengine.getPropagatorActivation(this));
        IntVar reason = d.getVar() == ((IntVar[])this.vars)[0] ? ((IntVar[])this.vars)[1] : ((IntVar[])this.vars)[0];
        reason.explain(xengine, VariableState.DOM, e);
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            ((IntVar[])this.vars)[0].duplicate(solver, identitymap);
            IntVar X = (IntVar)identitymap.get(((IntVar[])this.vars)[0]);
            ((IntVar[])this.vars)[1].duplicate(solver, identitymap);
            IntVar Y = (IntVar)identitymap.get(((IntVar[])this.vars)[1]);
            identitymap.put(this, new PropElement(X, this.lval, Y, this.cste, this.s));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateValueFromIndex() throws ContradictionException {
        boolean hasChanged;
        if (this.s == Sort.desc) {
            hasChanged = ((IntVar[])this.vars)[0].updateLowerBound(this.lval[((IntVar[])this.vars)[1].getUB() - this.cste], this.aCause);
            hasChanged |= ((IntVar[])this.vars)[0].updateUpperBound(this.lval[((IntVar[])this.vars)[1].getLB() - this.cste], this.aCause);
        } else if (this.s == Sort.asc) {
            hasChanged = ((IntVar[])this.vars)[0].updateLowerBound(this.lval[((IntVar[])this.vars)[1].getLB() - this.cste], this.aCause);
            hasChanged |= ((IntVar[])this.vars)[0].updateUpperBound(this.lval[((IntVar[])this.vars)[1].getUB() - this.cste], this.aCause);
        } else {
            int minVal = Integer.MAX_VALUE;
            int maxVal = Integer.MIN_VALUE;
            DisposableValueIterator iter = ((IntVar[])this.vars)[1].getValueIterator(true);
            boolean isDsc = true;
            boolean isAsc = true;
            int prev = this.lval[((IntVar[])this.vars)[1].getLB() - this.cste];
            try {
                while (iter.hasNext()) {
                    int index = iter.next();
                    int val = this.lval[index - this.cste];
                    if (minVal > val) {
                        minVal = val;
                    }
                    if (maxVal < val) {
                        maxVal = val;
                    }
                    if (this.s != Sort.detect) continue;
                    if (val > prev) {
                        isDsc = false;
                    }
                    if (val < prev) {
                        isAsc = false;
                    }
                    prev = val;
                }
                if (this.s == Sort.detect) {
                    IEnvironment environment = this.solver.getEnvironment();
                    if (isDsc) {
                        this.s = Sort.desc;
                        environment.save(new Operation(){

                            @Override
                            public void undo() {
                                PropElement.this.s = Sort.detect;
                            }
                        });
                    } else if (isAsc) {
                        this.s = Sort.asc;
                        environment.save(new Operation(){

                            @Override
                            public void undo() {
                                PropElement.this.s = Sort.detect;
                            }
                        });
                    } else {
                        this.s = Sort.none;
                        environment.save(new Operation(){

                            @Override
                            public void undo() {
                                PropElement.this.s = Sort.detect;
                            }
                        });
                    }
                }
                hasChanged = ((IntVar[])this.vars)[0].updateLowerBound(minVal, this.aCause);
                hasChanged |= ((IntVar[])this.vars)[0].updateUpperBound(maxVal, this.aCause);
            }
            finally {
                iter.dispose();
            }
        }
        return hasChanged;
    }

    protected boolean updateIndexFromValue() throws ContradictionException {
        int maxFeasibleIndex;
        int minFeasibleIndex = Math.max(this.cste, ((IntVar[])this.vars)[1].getLB());
        if (minFeasibleIndex > (maxFeasibleIndex = Math.min(((IntVar[])this.vars)[1].getUB(), this.lval.length - 1 + this.cste))) {
            this.contradiction(null, "impossible");
        }
        while (((IntVar[])this.vars)[1].contains(minFeasibleIndex) && !((IntVar[])this.vars)[0].contains(this.lval[minFeasibleIndex - this.cste])) {
            ++minFeasibleIndex;
        }
        boolean hasChanged = ((IntVar[])this.vars)[1].updateLowerBound(minFeasibleIndex, this.aCause);
        while (((IntVar[])this.vars)[1].contains(maxFeasibleIndex) && !((IntVar[])this.vars)[0].contains(this.lval[maxFeasibleIndex - this.cste])) {
            --maxFeasibleIndex;
        }
        hasChanged |= ((IntVar[])this.vars)[1].updateUpperBound(maxFeasibleIndex, this.aCause);
        if (((IntVar[])this.vars)[1].hasEnumeratedDomain()) {
            for (int i = minFeasibleIndex + 1; i <= maxFeasibleIndex - 1; ++i) {
                if (!((IntVar[])this.vars)[1].contains(i) || ((IntVar[])this.vars)[0].contains(this.lval[i - this.cste])) continue;
                hasChanged |= ((IntVar[])this.vars)[1].removeValue(i, this.aCause);
            }
        }
        return hasChanged;
    }

    public static enum Sort {
        none,
        asc,
        desc,
        detect;

    }
}

