/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.ValueRemoval;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public final class PropEqualX_Y
extends Propagator<IntVar> {
    private IntVar x;
    private IntVar y;
    private boolean bothEnumerated;
    private IIntDeltaMonitor[] idms;
    private RemProc rem_proc;
    private int indexToFilter;

    public PropEqualX_Y(IntVar x, IntVar y) {
        super((Variable[])ArrayUtils.toArray(x, y), PropagatorPriority.BINARY, true);
        this.x = ((IntVar[])this.vars)[0];
        this.y = ((IntVar[])this.vars)[1];
        if (x.hasEnumeratedDomain() && y.hasEnumeratedDomain()) {
            this.bothEnumerated = true;
            this.idms = new IIntDeltaMonitor[2];
            this.idms[0] = ((IntVar[])this.vars)[0].monitorDelta(this);
            this.idms[1] = ((IntVar[])this.vars)[1].monitorDelta(this);
            this.rem_proc = new RemProc();
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (this.bothEnumerated) {
            return IntEventType.all();
        }
        return IntEventType.boundAndInst();
    }

    private void updateBounds() throws ContradictionException {
        while (this.x.updateLowerBound(this.y.getLB(), this.aCause) | this.y.updateLowerBound(this.x.getLB(), this.aCause)) {
        }
        while (this.x.updateUpperBound(this.y.getUB(), this.aCause) | this.y.updateUpperBound(this.x.getUB(), this.aCause)) {
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.updateBounds();
        if (this.bothEnumerated) {
            int ub = this.x.getUB();
            int val = this.x.getLB();
            while (val <= ub) {
                if (!this.y.contains(val)) {
                    this.x.removeValue(val, this.aCause);
                }
                val = this.x.nextValue(val);
            }
            ub = this.y.getUB();
            val = this.y.getLB();
            while (val <= ub) {
                if (!this.x.contains(val)) {
                    this.y.removeValue(val, this.aCause);
                }
                val = this.y.nextValue(val);
            }
            this.idms[0].unfreeze();
            this.idms[1].unfreeze();
        }
        if (this.x.isInstantiated()) {
            assert (this.y.isInstantiated());
            this.setPassive();
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        this.updateBounds();
        if (this.x.isInstantiated()) {
            assert (this.y.isInstantiated());
            this.setPassive();
        } else if (this.bothEnumerated) {
            this.indexToFilter = 1 - varIdx;
            this.idms[varIdx].freeze();
            this.idms[varIdx].forEachRemVal(this.rem_proc);
            this.idms[varIdx].unfreeze();
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.x.getUB() < this.y.getLB() || this.x.getLB() > this.y.getUB() || this.x.hasEnumeratedDomain() && this.y.hasEnumeratedDomain() && !this.match()) {
            return ESat.FALSE;
        }
        if (this.x.isInstantiated() && this.y.isInstantiated() && this.x.getValue() == this.y.getValue()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    private boolean match() {
        int lb = this.x.getLB();
        int ub = this.x.getUB();
        while (lb <= ub) {
            if (this.y.contains(lb)) {
                return true;
            }
            lb = this.x.nextValue(lb);
        }
        return false;
    }

    @Override
    public String toString() {
        return "prop(" + ((IntVar[])this.vars)[0].getName() + ".EQ." + ((IntVar[])this.vars)[1].getName() + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        if (d.getVar() == this.x) {
            e.add(xengine.getPropagatorActivation(this));
            if (d.getmType() != Deduction.Type.ValRem) throw new UnsupportedOperationException("PropEqualXY only knows how to explain ValueRemovals");
            this.y.explain(xengine, VariableState.REM, ((ValueRemoval)d).getVal(), e);
            return;
        } else if (d.getVar() == this.y) {
            e.add(xengine.getPropagatorActivation(this));
            if (d.getmType() != Deduction.Type.ValRem) throw new UnsupportedOperationException("PropEqualXY only knows how to explain ValueRemovals");
            this.x.explain(xengine, VariableState.REM, ((ValueRemoval)d).getVal(), e);
            return;
        } else {
            super.explain(xengine, d, e);
        }
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            ((IntVar[])this.vars)[0].duplicate(solver, identitymap);
            IntVar X = (IntVar)identitymap.get(((IntVar[])this.vars)[0]);
            ((IntVar[])this.vars)[1].duplicate(solver, identitymap);
            IntVar Y = (IntVar)identitymap.get(((IntVar[])this.vars)[1]);
            identitymap.put(this, new PropEqualX_Y(X, Y));
        }
    }

    private class RemProc
    implements IntProcedure {
        private RemProc() {
        }

        @Override
        public void execute(int i) throws ContradictionException {
            ((IntVar[])PropEqualX_Y.this.vars)[PropEqualX_Y.this.indexToFilter].removeValue(i, PropEqualX_Y.this.aCause);
        }
    }
}

