/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public final class PropGreaterOrEqualXY_C
extends Propagator<IntVar> {
    final IntVar x;
    final IntVar y;
    final int cste;

    public PropGreaterOrEqualXY_C(IntVar[] vars, int c) {
        super((Variable[])vars, PropagatorPriority.BINARY, true);
        this.x = vars[0];
        this.y = vars[1];
        this.cste = c;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.INSTANTIATE.getMask() + IntEventType.DECUPP.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.x.updateLowerBound(this.cste - this.y.getUB(), this.aCause);
        this.y.updateLowerBound(this.cste - this.x.getUB(), this.aCause);
        if (this.x.getLB() + this.y.getLB() >= this.cste) {
            this.setPassive();
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp == 0) {
            this.y.updateLowerBound(this.cste - this.x.getUB(), this.aCause);
        } else {
            this.x.updateLowerBound(this.cste - this.y.getUB(), this.aCause);
        }
        if (this.x.getLB() + this.y.getLB() >= this.cste) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.x.getUB() + this.y.getUB() < this.cste) {
            return ESat.FALSE;
        }
        if (this.x.getLB() + this.y.getLB() >= this.cste) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return this.x.getName() + " + " + this.y.getName() + " >= " + this.cste;
    }

    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        e.add(xengine.getPropagatorActivation(this));
        Variable var = d.getVar();
        if (var.equals(this.x)) {
            this.y.explain(xengine, VariableState.UB, e);
        } else if (var.equals(this.y)) {
            this.x.explain(xengine, VariableState.UB, e);
        } else {
            super.explain(xengine, d, e);
        }
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            ((IntVar[])this.vars)[0].duplicate(solver, identitymap);
            IntVar X = (IntVar)identitymap.get(((IntVar[])this.vars)[0]);
            ((IntVar[])this.vars)[1].duplicate(solver, identitymap);
            IntVar Y = (IntVar)identitymap.get(((IntVar[])this.vars)[1]);
            identitymap.put(this, new PropGreaterOrEqualXY_C(new IntVar[]{X, Y}, this.cste));
        }
    }
}

