/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropNotEqualXY_C
extends Propagator<IntVar> {
    IntVar x;
    IntVar y;
    int cste;

    public PropNotEqualXY_C(IntVar[] vars, int c) {
        super((Variable[])vars, PropagatorPriority.BINARY, true);
        this.x = vars[0];
        this.y = vars[1];
        this.cste = c;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (((IntVar[])this.vars)[vIdx].hasEnumeratedDomain()) {
            return IntEventType.instantiation();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.x.isInstantiated()) {
            this.removeValV1();
        } else if (this.y.isInstantiated()) {
            this.removeValV0();
        } else if (this.x.getLB() + this.y.getLB() > this.cste || this.x.getUB() + this.y.getUB() < this.cste) {
            this.setPassive();
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        this.propagate(0);
    }

    private void removeValV0() throws ContradictionException {
        if (this.x.removeValue(this.cste - this.y.getValue(), this.aCause) || !this.x.contains(this.cste - this.y.getValue())) {
            this.setPassive();
        }
    }

    private void removeValV1() throws ContradictionException {
        if (this.y.removeValue(this.cste - this.x.getValue(), this.aCause) || !this.y.contains(this.cste - this.x.getValue())) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.x.getUB() + this.y.getUB() < this.cste || this.y.getLB() + this.x.getLB() > this.cste) {
            return ESat.TRUE;
        }
        if (this.x.isInstantiated() && this.y.isInstantiated() && this.x.getValue() + this.y.getValue() == this.cste) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        e.add(xengine.getPropagatorActivation(this));
        Variable var = d.getVar();
        if (var.equals(this.x)) {
            this.y.explain(xengine, VariableState.DOM, e);
        } else if (var != null) {
            this.x.explain(xengine, VariableState.DOM, e);
        }
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            ((IntVar[])this.vars)[0].duplicate(solver, identitymap);
            IntVar X = (IntVar)identitymap.get(((IntVar[])this.vars)[0]);
            ((IntVar[])this.vars)[1].duplicate(solver, identitymap);
            IntVar Y = (IntVar)identitymap.get(((IntVar[])this.vars)[1]);
            identitymap.put(this, new PropNotEqualXY_C(new IntVar[]{X, Y}, this.cste));
        }
    }
}

