/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.ternary.Times;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;

public class PropScale
extends Propagator<IntVar> {
    protected static final int MAX = 0x7FFFFFFE;
    protected static final int MIN = -2147483647;
    final IntVar X;
    final IntVar Z;
    final int Y;
    final boolean enumerated;

    public PropScale(IntVar x, int y, IntVar z) {
        super((Variable[])new IntVar[]{x, z}, PropagatorPriority.BINARY, false);
        this.X = ((IntVar[])this.vars)[0];
        this.Z = ((IntVar[])this.vars)[1];
        this.Y = y;
        assert (y > 1);
        if (!Times.inIntBounds((long)this.X.getLB() * (long)this.Y) || !Times.inIntBounds((long)this.X.getUB() * (long)this.Y)) {
            throw new SolverException("Integer overflow.\nConsider reducing the variable domains.");
        }
        this.enumerated = this.X.hasEnumeratedDomain() && this.Z.hasEnumeratedDomain();
    }

    @Override
    public final void propagate(int evtmask) throws ContradictionException {
        this.X.updateLowerBound((int)Math.ceil((double)this.Z.getLB() / (double)this.Y - 1.0E-4), this.aCause);
        this.X.updateUpperBound((int)Math.floor((double)this.Z.getUB() / (double)this.Y + 1.0E-4), this.aCause);
        boolean hasChanged = this.Z.updateLowerBound(this.X.getLB() * this.Y, this.aCause);
        hasChanged |= this.Z.updateUpperBound(this.X.getUB() * this.Y, this.aCause);
        if (this.enumerated) {
            int ub = this.X.getUB();
            int v = this.X.getLB();
            while (v <= ub) {
                if (!this.Z.contains(v * this.Y)) {
                    this.X.removeValue(v, this.aCause);
                }
                v = this.X.nextValue(v);
            }
            ub = this.Z.getUB();
            v = this.Z.getLB();
            while (v <= ub) {
                if (v / this.Y * this.Y != v || !this.X.contains(v / this.Y)) {
                    this.Z.removeValue(v, this.aCause);
                }
                v = this.Z.nextValue(v);
            }
        } else if (hasChanged && this.Z.hasEnumeratedDomain() && (this.Z.getLB() > this.X.getLB() * this.Y || this.Z.getUB() < this.X.getUB() * this.Y)) {
            this.propagate(evtmask);
        }
    }

    @Override
    public final ESat isEntailed() {
        if (this.X.getUB() * this.Y < this.Z.getLB() || this.X.getLB() * this.Y > this.Z.getUB()) {
            return ESat.FALSE;
        }
        if (this.X.isInstantiated() && this.Z.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            ((IntVar[])this.vars)[0].duplicate(solver, identitymap);
            IntVar X = (IntVar)identitymap.get(((IntVar[])this.vars)[0]);
            ((IntVar[])this.vars)[1].duplicate(solver, identitymap);
            IntVar Y = (IntVar)identitymap.get(((IntVar[])this.vars)[1]);
            identitymap.put(this, new PropScale(X, this.Y, Y));
        }
    }
}

