/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.ValueRemoval;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.UnaryIntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropSquare
extends Propagator<IntVar> {
    protected final RemProc rem_proc;
    protected final IIntDeltaMonitor[] idms;

    public PropSquare(IntVar X, IntVar Y) {
        super((Variable[])ArrayUtils.toArray(X, Y), PropagatorPriority.BINARY, true);
        this.idms = new IIntDeltaMonitor[((IntVar[])this.vars).length];
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            this.idms[i] = ((IntVar[])this.vars)[i].hasEnumeratedDomain() ? ((IntVar[])this.vars)[i].monitorDelta(this) : IIntDeltaMonitor.Default.NONE;
        }
        this.rem_proc = new RemProc(this);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.updateLowerBoundofX();
        this.updateUpperBoundofX();
        this.updateHolesinX();
        this.updateLowerBoundofY();
        this.updateUpperBoundofY();
        this.updateHolesinY();
        for (int i = 0; i < this.idms.length; ++i) {
            this.idms[i].unfreeze();
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        if (varIdx == 0) {
            if (IntEventType.isInstantiate(mask) || IntEventType.isBound(mask)) {
                this.updateLowerBoundofY();
                this.updateUpperBoundofY();
                this.updateHolesinY();
            } else {
                this.idms[varIdx].freeze();
                this.idms[varIdx].forEachRemVal(this.rem_proc.set(varIdx));
                this.idms[varIdx].unfreeze();
            }
        } else if (IntEventType.isInstantiate(mask) || IntEventType.isBound(mask)) {
            this.updateLowerBoundofX();
            this.updateUpperBoundofX();
            this.updateHolesinX();
        } else {
            this.idms[varIdx].freeze();
            this.idms[varIdx].forEachRemVal(this.rem_proc.set(varIdx));
            this.idms[varIdx].unfreeze();
        }
    }

    @Override
    public ESat isEntailed() {
        if (((IntVar[])this.vars)[0].getUB() < 0) {
            return ESat.FALSE;
        }
        if (((IntVar[])this.vars)[0].isInstantiated()) {
            if (((IntVar[])this.vars)[1].isInstantiated()) {
                return ESat.eval(((IntVar[])this.vars)[0].getValue() == PropSquare.sqr(((IntVar[])this.vars)[1].getValue()));
            }
            if (((IntVar[])this.vars)[1].getDomainSize() == 2 && ((IntVar[])this.vars)[1].contains(-PropSquare.floor_sqrt(((IntVar[])this.vars)[0].getValue())) && ((IntVar[])this.vars)[1].contains(-PropSquare.floor_sqrt(((IntVar[])this.vars)[0].getValue()))) {
                return ESat.TRUE;
            }
            if (!((IntVar[])this.vars)[1].contains(PropSquare.floor_sqrt(((IntVar[])this.vars)[0].getValue())) && !((IntVar[])this.vars)[1].contains(-PropSquare.floor_sqrt(((IntVar[])this.vars)[0].getValue()))) {
                return ESat.FALSE;
            }
            return ESat.UNDEFINED;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return String.format("%s = %s^2", ((IntVar[])this.vars)[0].toString(), ((IntVar[])this.vars)[1].toString());
    }

    private static int floor_sqrt(int n) {
        if (n < 0) {
            return 0;
        }
        return (int)Math.floor(Math.sqrt(n));
    }

    private static int ceil_sqrt(int n) {
        if (n < 0) {
            return 0;
        }
        return (int)Math.ceil(Math.sqrt(n));
    }

    private static int sqr(int n) {
        if (n > 0x3FFFFFFF || n < -1073741824) {
            return Integer.MAX_VALUE;
        }
        return n * n;
    }

    protected void updateLowerBoundofX() throws ContradictionException {
        int a0 = ((IntVar[])this.vars)[1].nextValue(-1);
        int b0 = Math.max(-2147483647, ((IntVar[])this.vars)[1].previousValue(1));
        ((IntVar[])this.vars)[0].updateLowerBound(Math.min(PropSquare.sqr(a0), PropSquare.sqr(b0)), this.aCause);
    }

    protected void updateUpperBoundofX() throws ContradictionException {
        ((IntVar[])this.vars)[0].updateUpperBound(Math.max(PropSquare.sqr(((IntVar[])this.vars)[1].getLB()), PropSquare.sqr(((IntVar[])this.vars)[1].getUB())), this.aCause);
    }

    protected void updateHolesinX() throws ContradictionException {
        if (((IntVar[])this.vars)[1].hasEnumeratedDomain()) {
            int left = Integer.MIN_VALUE;
            int right = Integer.MIN_VALUE;
            int ub = ((IntVar[])this.vars)[0].getUB();
            int value = ((IntVar[])this.vars)[0].getLB();
            while (value <= ub) {
                if (!((IntVar[])this.vars)[1].contains(PropSquare.floor_sqrt(value)) && !((IntVar[])this.vars)[1].contains(-PropSquare.floor_sqrt(value))) {
                    if (value == right + 1) {
                        right = value;
                    } else {
                        ((IntVar[])this.vars)[0].removeInterval(left, right, this.aCause);
                        left = right = value;
                    }
                }
                value = ((IntVar[])this.vars)[0].nextValue(value);
            }
            ((IntVar[])this.vars)[0].removeInterval(left, right, this.aCause);
        } else {
            int value = ((IntVar[])this.vars)[0].getLB();
            int nlb = value - 1;
            while (nlb == value - 1) {
                if (!((IntVar[])this.vars)[1].contains(PropSquare.floor_sqrt(value)) && !((IntVar[])this.vars)[1].contains(-PropSquare.floor_sqrt(value))) {
                    nlb = value;
                }
                value = ((IntVar[])this.vars)[0].nextValue(value);
            }
            ((IntVar[])this.vars)[0].updateLowerBound(nlb, this.aCause);
            value = ((IntVar[])this.vars)[0].getUB();
            int nub = value + 1;
            while (nub == value + 1) {
                if (!((IntVar[])this.vars)[1].contains(PropSquare.floor_sqrt(value)) && !((IntVar[])this.vars)[1].contains(-PropSquare.floor_sqrt(value))) {
                    nub = value;
                }
                value = ((IntVar[])this.vars)[0].previousValue(value);
            }
            ((IntVar[])this.vars)[0].updateUpperBound(nub, this.aCause);
        }
    }

    protected void updateHoleinX(int remVal) throws ContradictionException {
        if (!((IntVar[])this.vars)[1].contains(-remVal)) {
            ((IntVar[])this.vars)[0].removeValue(PropSquare.sqr(remVal), this.aCause);
        }
    }

    protected void updateLowerBoundofY() throws ContradictionException {
        ((IntVar[])this.vars)[1].updateLowerBound(-PropSquare.ceil_sqrt(((IntVar[])this.vars)[0].getUB()), this.aCause);
    }

    protected void updateUpperBoundofY() throws ContradictionException {
        ((IntVar[])this.vars)[1].updateUpperBound(PropSquare.floor_sqrt(((IntVar[])this.vars)[0].getUB()), this.aCause);
    }

    protected void updateHolesinY() throws ContradictionException {
        if (((IntVar[])this.vars)[0].hasEnumeratedDomain()) {
            int left = Integer.MIN_VALUE;
            int right = Integer.MIN_VALUE;
            int ub = ((IntVar[])this.vars)[1].getUB();
            int value = ((IntVar[])this.vars)[1].getLB();
            while (value <= ub) {
                if (!((IntVar[])this.vars)[0].contains(PropSquare.sqr(value))) {
                    if (value == right + 1) {
                        right = value;
                    } else {
                        ((IntVar[])this.vars)[1].removeInterval(left, right, this.aCause);
                        left = right = value;
                    }
                }
                value = ((IntVar[])this.vars)[1].nextValue(value);
            }
            ((IntVar[])this.vars)[1].removeInterval(left, right, this.aCause);
        } else {
            int lb = ((IntVar[])this.vars)[1].getLB();
            int ub = ((IntVar[])this.vars)[1].getUB();
            while (!((IntVar[])this.vars)[0].contains(PropSquare.sqr(lb)) && (lb = ((IntVar[])this.vars)[1].nextValue(lb + 1)) <= ub) {
            }
            ((IntVar[])this.vars)[1].updateLowerBound(lb, this.aCause);
            while (!((IntVar[])this.vars)[0].contains(PropSquare.sqr(ub)) && (ub = ((IntVar[])this.vars)[1].nextValue(ub + 1)) >= lb) {
            }
            ((IntVar[])this.vars)[1].updateUpperBound(ub, this.aCause);
        }
    }

    protected void updateHoleinY(int remVal) throws ContradictionException {
        ((IntVar[])this.vars)[1].removeValue(PropSquare.floor_sqrt(remVal), this.aCause);
        ((IntVar[])this.vars)[1].removeValue(-PropSquare.ceil_sqrt(remVal), this.aCause);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        if (d.getVar() == ((IntVar[])this.vars)[0]) {
            e.add(xengine.getPropagatorActivation(this));
            if (!(d instanceof ValueRemoval)) throw new UnsupportedOperationException("PropSquare only knows how to explain ValueRemovals");
            int val = (int)Math.sqrt(((ValueRemoval)d).getVal());
            ((IntVar[])this.vars)[1].explain(xengine, VariableState.REM, val, e);
            ((IntVar[])this.vars)[1].explain(xengine, VariableState.REM, -val, e);
            return;
        } else if (d.getVar() == ((IntVar[])this.vars)[1]) {
            e.add(xengine.getPropagatorActivation(this));
            if (!(d instanceof ValueRemoval)) throw new UnsupportedOperationException("PropSquare only knows how to explain ValueRemovals");
            int val = ((ValueRemoval)d).getVal() ^ 2;
            ((IntVar[])this.vars)[0].explain(xengine, VariableState.REM, val, e);
            return;
        } else {
            super.explain(xengine, d, e);
        }
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            ((IntVar[])this.vars)[0].duplicate(solver, identitymap);
            IntVar X = (IntVar)identitymap.get(((IntVar[])this.vars)[0]);
            ((IntVar[])this.vars)[1].duplicate(solver, identitymap);
            IntVar Y = (IntVar)identitymap.get(((IntVar[])this.vars)[1]);
            identitymap.put(this, new PropSquare(X, Y));
        }
    }

    private static class RemProc
    implements UnaryIntProcedure<Integer> {
        private final PropSquare p;
        private int idxVar;

        public RemProc(PropSquare p) {
            this.p = p;
        }

        @Override
        public UnaryIntProcedure set(Integer idxVar) {
            this.idxVar = idxVar;
            return this;
        }

        @Override
        public void execute(int i) throws ContradictionException {
            if (this.idxVar == 0) {
                this.p.updateHoleinY(i);
            } else {
                this.p.updateHoleinX(i);
            }
        }
    }
}

