/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.chocosolver.solver.exception.SolverException;

public class Tuples {
    protected final boolean feasible;
    protected final List<int[]> tuples;
    protected int arity;
    protected int[] ranges;

    public Tuples(boolean feasible) {
        this.feasible = feasible;
        this.tuples = new ArrayList<int[]>();
    }

    public Tuples() {
        this(true);
    }

    public void add(int ... tuple) {
        if (this.tuples.size() == 0) {
            this.arity = tuple.length;
            this.ranges = new int[2 * this.arity];
            Arrays.fill(this.ranges, 0, this.arity, Integer.MAX_VALUE);
            Arrays.fill(this.ranges, this.arity, 2 * this.arity, Integer.MIN_VALUE);
        } else if (this.arity != tuple.length) {
            throw new SolverException("The given tuple does not match the arity: " + this.arity);
        }
        this.tuples.add(tuple);
        for (int i = 0; i < this.arity; ++i) {
            this.ranges[i] = Math.min(this.ranges[i], tuple[i]);
            this.ranges[i + this.arity] = Math.max(this.ranges[i + this.arity], tuple[i]);
        }
    }

    public void add(int[] ... tuples) {
        for (int[] t : tuples) {
            this.add(t);
        }
    }

    public boolean isFeasible() {
        return this.feasible;
    }

    public int min(int idx) {
        return this.ranges[idx];
    }

    public int max(int idx) {
        return this.ranges[idx + this.arity];
    }

    public int nbTuples() {
        return this.tuples.size();
    }

    public int[] get(int idx) {
        return this.tuples.get(idx);
    }

    public String toString() {
        StringBuilder st = new StringBuilder(this.isFeasible() ? "Allowed" : "Fordidden").append(" tuples: {");
        for (int i = 0; i < this.tuples.size(); ++i) {
            st.append(Arrays.toString(this.tuples.get(i)));
        }
        st.append("}");
        return st.toString();
    }

    public int[][] toMatrix() {
        int i = 0;
        int[][] matrix = new int[this.tuples.size()][];
        for (int[] tuple : this.tuples) {
            matrix[i++] = (int[])tuple.clone();
        }
        return matrix;
    }

    public void sort() {
        this.tuples.sort(new TupleComparator());
    }

    private static class TupleComparator
    implements Comparator<int[]> {
        private TupleComparator() {
        }

        @Override
        public int compare(int[] o1, int[] o2) {
            int i;
            int l = o1.length;
            for (i = 0; i < l && o1[i] == o2[i]; ++i) {
            }
            return i == l ? 0 : o1[i] - o2[i];
        }
    }
}

