/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.binary;

import java.util.BitSet;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.binary.BinRelation;
import org.chocosolver.solver.variables.IntVar;

class CouplesTable
extends BinRelation {
    protected final BitSet table;
    protected final int offset1;
    protected final int offset2;
    protected final int range1;
    protected final int range2;
    protected final boolean feasible;

    public CouplesTable(Tuples tuples, IntVar var1, IntVar var2) {
        this.offset1 = var1.getLB();
        this.offset2 = var2.getLB();
        this.range1 = var1.getUB() - this.offset1 + 1;
        this.range2 = var2.getUB() - this.offset2 + 1;
        this.table = new BitSet(this.range1 * this.range2);
        this.feasible = tuples.isFeasible();
        int nt = tuples.nbTuples();
        for (int i = 0; i < nt; ++i) {
            int[] tuple = tuples.get(i);
            if (!var1.contains(tuple[0]) || !var2.contains(tuple[1])) continue;
            this.table.set((tuple[0] - this.offset1) * this.range2 + tuple[1] - this.offset2);
        }
    }

    private CouplesTable(BitSet table, int offset1, int offset2, int range1, int range2, boolean feasible) {
        this.table = table;
        this.offset1 = offset1;
        this.offset2 = offset2;
        this.range1 = range1;
        this.range2 = range2;
        this.feasible = feasible;
    }

    @Override
    public boolean isConsistent(int x, int y) {
        return this.table.get((x - this.offset1) * this.range2 + y - this.offset2) == this.feasible;
    }

    @Override
    public boolean checkCouple(int x, int y) {
        return this.table.get((x - this.offset1) * this.range2 + y - this.offset2);
    }

    @Override
    public BinRelation duplicate() {
        return new CouplesTable((BitSet)this.table.clone(), this.offset1, this.offset2, this.range1, this.range2, this.feasible);
    }
}

