/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.binary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.binary.CouplesBitSetTable;
import org.chocosolver.solver.constraints.extension.binary.PropBinCSP;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.iterators.DisposableValueIterator;

public class PropBinAC3
extends PropBinCSP {
    public PropBinAC3(IntVar x, IntVar y, Tuples tuples) {
        this(x, y, new CouplesBitSetTable(tuples, x, y));
    }

    private PropBinAC3(IntVar x, IntVar y, CouplesBitSetTable table) {
        super(x, y, table);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.reviseV0();
        this.reviseV1();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp == 0) {
            this.reviseV1();
        } else {
            this.reviseV0();
        }
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            ((IntVar[])this.vars)[0].duplicate(solver, identitymap);
            IntVar X = (IntVar)identitymap.get(((IntVar[])this.vars)[0]);
            ((IntVar[])this.vars)[1].duplicate(solver, identitymap);
            IntVar Y = (IntVar)identitymap.get(((IntVar[])this.vars)[1]);
            identitymap.put(this, new PropBinAC3(X, Y, (CouplesBitSetTable)this.relation.duplicate()));
        }
    }

    private void reviseV1() throws ContradictionException {
        int left;
        int nbs = 0;
        int right = left = Integer.MIN_VALUE;
        DisposableValueIterator itv1 = this.v1.getValueIterator(true);
        while (itv1.hasNext()) {
            int val1 = itv1.next();
            DisposableValueIterator itv0 = this.v0.getValueIterator(true);
            while (itv0.hasNext()) {
                int val0 = itv0.next();
                if (!this.relation.isConsistent(val0, val1)) continue;
                ++nbs;
                break;
            }
            itv0.dispose();
            if (nbs == 0) {
                if (val1 == right + 1) {
                    right = val1;
                } else {
                    this.v1.removeInterval(left, right, this);
                    left = right = val1;
                }
            }
            nbs = 0;
        }
        this.v1.removeInterval(left, right, this);
        itv1.dispose();
    }

    private void reviseV0() throws ContradictionException {
        int left;
        int nbs = 0;
        int right = left = Integer.MIN_VALUE;
        DisposableValueIterator itv0 = this.v0.getValueIterator(true);
        while (itv0.hasNext()) {
            int val0 = itv0.next();
            DisposableValueIterator itv1 = this.v1.getValueIterator(true);
            while (itv1.hasNext()) {
                int val1 = itv1.next();
                if (!this.relation.isConsistent(val0, val1)) continue;
                ++nbs;
                break;
            }
            itv1.dispose();
            if (nbs == 0) {
                if (val0 == right + 1) {
                    right = val0;
                } else {
                    this.v0.removeInterval(left, right, this);
                    left = right = val0;
                }
            }
            nbs = 0;
        }
        this.v0.removeInterval(left, right, this);
        itv0.dispose();
    }
}

