/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.binary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.binary.CouplesBitSetTable;
import org.chocosolver.solver.constraints.extension.binary.PropBinCSP;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.iterators.DisposableValueIterator;

public class PropBinAC3bitrm
extends PropBinCSP {
    protected int offset0;
    protected int offset1;
    protected int minS0;
    protected int minS1;
    protected int initDomSize0;
    protected int initDomSize1;

    public PropBinAC3bitrm(IntVar x, IntVar y, Tuples tuples) {
        this(x, y, new CouplesBitSetTable(tuples, x, y));
    }

    private PropBinAC3bitrm(IntVar x, IntVar y, CouplesBitSetTable table) {
        super(x, y, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            int left;
            this.offset0 = this.v0.getLB();
            this.offset1 = this.v1.getLB();
            this.initDomSize0 = this.v0.getDomainSize();
            this.initDomSize1 = this.v1.getDomainSize();
            this.fastInitNbSupports();
            int right = left = Integer.MIN_VALUE;
            DisposableValueIterator itv0 = this.v0.getValueIterator(true);
            try {
                while (itv0.hasNext()) {
                    int val0 = itv0.next();
                    if (((CouplesBitSetTable)this.relation).checkValue(0, val0, this.v1)) continue;
                    if (val0 == right + 1) {
                        right = val0;
                        continue;
                    }
                    this.v0.removeInterval(left, right, this);
                    left = right = val0;
                }
                this.v0.removeInterval(left, right, this);
            }
            finally {
                itv0.dispose();
            }
            itv0 = this.v1.getValueIterator(true);
            right = Integer.MIN_VALUE;
            left = Integer.MIN_VALUE;
            try {
                while (itv0.hasNext()) {
                    int val1 = itv0.next();
                    if (((CouplesBitSetTable)this.relation).checkValue(1, val1, this.v0)) continue;
                    if (val1 == right + 1) {
                        right = val1;
                        continue;
                    }
                    this.v1.removeInterval(left, right, this);
                    left = right = val1;
                }
                this.v1.removeInterval(left, right, this);
            }
            finally {
                itv0.dispose();
            }
        }
        this.reviseV0();
        this.reviseV1();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (IntEventType.isInstantiate(mask)) {
            this.onInstantiationOf(idxVarInProp);
        } else if (idxVarInProp == 0) {
            this.reviseV1();
        } else {
            this.reviseV0();
        }
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            ((IntVar[])this.vars)[0].duplicate(solver, identitymap);
            IntVar X = (IntVar)identitymap.get(((IntVar[])this.vars)[0]);
            ((IntVar[])this.vars)[1].duplicate(solver, identitymap);
            IntVar Y = (IntVar)identitymap.get(((IntVar[])this.vars)[1]);
            identitymap.put(this, new PropBinAC3bitrm(X, Y, (CouplesBitSetTable)this.relation.duplicate()));
        }
    }

    private void fastInitNbSupports() {
        int[] initS1 = new int[this.v1.getUB() - this.v1.getLB() + 1];
        this.minS0 = Integer.MAX_VALUE;
        this.minS1 = Integer.MAX_VALUE;
        DisposableValueIterator itv0 = this.v0.getValueIterator(true);
        while (itv0.hasNext()) {
            int val0 = itv0.next();
            int initS0 = 0;
            DisposableValueIterator itv1 = this.v1.getValueIterator(true);
            while (itv1.hasNext()) {
                int val1 = itv1.next();
                if (!this.relation.isConsistent(val0, val1)) continue;
                ++initS0;
                int n = val1 - this.offset1;
                initS1[n] = initS1[n] + 1;
            }
            if (initS0 < this.minS0) {
                this.minS0 = initS0;
            }
            itv1.dispose();
        }
        itv0.dispose();
        for (int i = 0; i < initS1.length; ++i) {
            if (initS1[i] >= this.minS1) continue;
            this.minS1 = initS1[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reviseV1() throws ContradictionException {
        int v0Size = this.v0.getDomainSize();
        if (this.minS1 <= this.initDomSize0 - v0Size) {
            int left;
            int right = left = Integer.MIN_VALUE;
            DisposableValueIterator itv1 = this.v1.getValueIterator(true);
            try {
                while (itv1.hasNext()) {
                    int y = itv1.next();
                    if (((CouplesBitSetTable)this.relation).checkValue(1, y, this.v0)) continue;
                    if (y == right + 1) {
                        right = y;
                        continue;
                    }
                    this.v1.removeInterval(left, right, this);
                    left = right = y;
                }
                this.v1.removeInterval(left, right, this);
            }
            finally {
                itv1.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reviseV0() throws ContradictionException {
        int v1Size = this.v1.getDomainSize();
        if (this.minS0 <= this.initDomSize1 - v1Size) {
            int left;
            int right = left = Integer.MIN_VALUE;
            DisposableValueIterator itv0 = this.v0.getValueIterator(true);
            try {
                while (itv0.hasNext()) {
                    int x = itv0.next();
                    if (((CouplesBitSetTable)this.relation).checkValue(0, x, this.v1)) continue;
                    if (x == right + 1) {
                        right = x;
                        continue;
                    }
                    this.v0.removeInterval(left, right, this);
                    left = right = x;
                }
                this.v0.removeInterval(left, right, this);
            }
            finally {
                itv0.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInstantiationOf(int idx) throws ContradictionException {
        int left;
        if (idx == 0) {
            int left2;
            int value = this.v0.getValue();
            int right = left2 = Integer.MIN_VALUE;
            DisposableValueIterator itv1 = this.v1.getValueIterator(true);
            try {
                while (itv1.hasNext()) {
                    int val = itv1.next();
                    if (this.relation.isConsistent(value, val)) continue;
                    if (val == right + 1) {
                        right = val;
                        continue;
                    }
                    this.v1.removeInterval(left2, right, this);
                    left2 = right = val;
                }
                this.v1.removeInterval(left2, right, this);
            }
            finally {
                itv1.dispose();
            }
        }
        int value = this.v1.getValue();
        int right = left = Integer.MIN_VALUE;
        DisposableValueIterator itv0 = this.v0.getValueIterator(true);
        try {
            while (itv0.hasNext()) {
                int val = itv0.next();
                if (this.relation.isConsistent(val, value)) continue;
                if (val == right + 1) {
                    right = val;
                    continue;
                }
                this.v0.removeInterval(left, right, this);
                left = right = val;
            }
            this.v0.removeInterval(left, right, this);
        }
        finally {
            itv0.dispose();
        }
    }
}

