/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.binary;

import gnu.trove.map.hash.THashMap;
import java.util.Arrays;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.binary.CouplesBitSetTable;
import org.chocosolver.solver.constraints.extension.binary.PropBinCSP;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.iterators.DisposableValueIterator;

public class PropBinAC3rm
extends PropBinCSP {
    protected int[] currentSupport0;
    protected int[] currentSupport1;
    protected int offset0;
    protected int offset1;
    protected int[] initS0;
    protected int[] initS1;
    protected int minS0;
    protected int minS1;
    protected int initDomSize0;
    protected int initDomSize1;

    public PropBinAC3rm(IntVar x, IntVar y, Tuples tuples) {
        this(x, y, new CouplesBitSetTable(tuples, x, y));
    }

    private PropBinAC3rm(IntVar x, IntVar y, CouplesBitSetTable table) {
        super(x, y, table);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            this.initProp();
        }
        this.reviseV0();
        this.reviseV1();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (IntEventType.isInstantiate(mask)) {
            this.onInstantiationOf(idxVarInProp);
        } else if (idxVarInProp == 0) {
            this.reviseV1();
        } else {
            this.reviseV0();
        }
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            ((IntVar[])this.vars)[0].duplicate(solver, identitymap);
            IntVar X = (IntVar)identitymap.get(((IntVar[])this.vars)[0]);
            ((IntVar[])this.vars)[1].duplicate(solver, identitymap);
            IntVar Y = (IntVar)identitymap.get(((IntVar[])this.vars)[1]);
            identitymap.put(this, new PropBinAC3rm(X, Y, (CouplesBitSetTable)this.relation.duplicate()));
        }
    }

    public void fastInitNbSupports(int a, int b) {
        int i;
        DisposableValueIterator itv0 = this.v0.getValueIterator(true);
        int cpt1 = 0;
        while (itv0.hasNext()) {
            int val0 = itv0.next();
            ++cpt1;
            DisposableValueIterator itv1 = this.v1.getValueIterator(true);
            int cpt2 = 0;
            while (itv1.hasNext()) {
                ++cpt2;
                int val1 = itv1.next();
                if (this.relation.isConsistent(val0, val1)) {
                    int n = val0 - this.offset0;
                    this.initS0[n] = this.initS0[n] + 1;
                    int n2 = val1 - this.offset1;
                    this.initS1[n2] = this.initS1[n2] + 1;
                }
                if (cpt2 < a) continue;
                break;
            }
            itv1.dispose();
            if (cpt1 < b) continue;
            break;
        }
        itv0.dispose();
        this.minS0 = Integer.MAX_VALUE;
        this.minS1 = Integer.MAX_VALUE;
        for (i = 0; i < this.initS0.length; ++i) {
            if (this.initS0[i] >= this.minS0) continue;
            this.minS0 = this.initS0[i];
        }
        for (i = 0; i < this.initS1.length; ++i) {
            if (this.initS1[i] >= this.minS1) continue;
            this.minS1 = this.initS1[i];
        }
    }

    public boolean testDeepakConditionV1(int y, int v0Size) {
        return this.initS1[y - this.offset1] <= this.initDomSize0 - v0Size;
    }

    public boolean testDeepakConditionV0(int x, int v1Size) {
        return this.initS0[x - this.offset0] <= this.initDomSize1 - v1Size;
    }

    public int getSupportV1(int y) {
        return this.currentSupport1[y - this.offset1];
    }

    public int getSupportV0(int x) {
        return this.currentSupport0[x - this.offset0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reviseV1() throws ContradictionException {
        int v0Size = this.v0.getDomainSize();
        if (this.minS1 <= this.initDomSize0 - v0Size) {
            int left;
            DisposableValueIterator itv1 = this.v1.getValueIterator(true);
            int right = left = Integer.MIN_VALUE;
            try {
                while (itv1.hasNext()) {
                    int y = itv1.next();
                    if (!this.testDeepakConditionV1(y, v0Size) || this.v0.contains(this.getSupportV1(y))) continue;
                    boolean found = false;
                    int support = 0;
                    DisposableValueIterator itv0 = this.v0.getValueIterator(true);
                    while (!found && itv0.hasNext()) {
                        support = itv0.next();
                        if (!this.relation.isConsistent(support, y)) continue;
                        found = true;
                    }
                    itv0.dispose();
                    if (found) {
                        this.storeSupportV1(support, y);
                        continue;
                    }
                    if (y == right + 1) {
                        right = y;
                        continue;
                    }
                    this.v1.removeInterval(left, right, this);
                    left = right = y;
                }
                this.v1.removeInterval(left, right, this);
            }
            finally {
                itv1.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reviseV0() throws ContradictionException {
        int v1Size = this.v1.getDomainSize();
        if (this.minS0 <= this.initDomSize1 - v1Size) {
            int left;
            DisposableValueIterator itv0 = this.v0.getValueIterator(true);
            int right = left = Integer.MIN_VALUE;
            try {
                while (itv0.hasNext()) {
                    int x = itv0.next();
                    if (!this.testDeepakConditionV0(x, v1Size) || this.v1.contains(this.getSupportV0(x))) continue;
                    boolean found = false;
                    int support = 0;
                    DisposableValueIterator itv1 = this.v1.getValueIterator(true);
                    while (!found && itv1.hasNext()) {
                        support = itv1.next();
                        if (!this.relation.isConsistent(x, support)) continue;
                        found = true;
                    }
                    itv1.dispose();
                    if (found) {
                        this.storeSupportV0(support, x);
                        continue;
                    }
                    if (x == right + 1) {
                        right = x;
                        continue;
                    }
                    this.v0.removeInterval(left, right, this);
                    left = right = x;
                }
                this.v0.removeInterval(left, right, this);
            }
            finally {
                itv0.dispose();
            }
        }
    }

    public void storeSupportV0(int support, int x) {
        this.currentSupport0[x - this.offset0] = support;
        this.currentSupport1[support - this.offset1] = x;
    }

    public void storeSupportV1(int support, int y) {
        this.currentSupport1[y - this.offset1] = support;
        this.currentSupport0[support - this.offset0] = y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initProp() throws ContradictionException {
        DisposableValueIterator itv1;
        int left;
        this.offset1 = this.v1.getLB();
        this.offset0 = this.v0.getLB();
        this.currentSupport0 = new int[this.v0.getUB() - this.v0.getLB() + 1];
        this.currentSupport1 = new int[this.v1.getUB() - this.v1.getLB() + 1];
        this.initS0 = new int[this.v0.getUB() - this.v0.getLB() + 1];
        this.initS1 = new int[this.v1.getUB() - this.v1.getLB() + 1];
        this.initDomSize0 = this.v0.getDomainSize();
        this.initDomSize1 = this.v1.getDomainSize();
        Arrays.fill(this.currentSupport0, -1);
        Arrays.fill(this.currentSupport1, -1);
        this.fastInitNbSupports(Integer.MAX_VALUE, Integer.MAX_VALUE);
        DisposableValueIterator itv0 = this.v0.getValueIterator(true);
        int right = left = Integer.MIN_VALUE;
        int support = 0;
        boolean found = false;
        try {
            while (itv0.hasNext()) {
                itv1 = this.v1.getValueIterator(true);
                int val0 = itv0.next();
                while (itv1.hasNext()) {
                    int val1 = itv1.next();
                    if (!this.relation.isConsistent(val0, val1)) continue;
                    support = val1;
                    found = true;
                    break;
                }
                itv1.dispose();
                if (!found) {
                    if (val0 == right + 1) {
                        right = val0;
                    } else {
                        this.v0.removeInterval(left, right, this);
                        left = right = val0;
                    }
                } else {
                    this.storeSupportV0(support, val0);
                }
                found = false;
            }
            this.v0.removeInterval(left, right, this);
        }
        finally {
            itv0.dispose();
        }
        found = false;
        itv1 = this.v1.getValueIterator(true);
        right = Integer.MIN_VALUE;
        left = Integer.MIN_VALUE;
        try {
            while (itv1.hasNext()) {
                itv0 = this.v0.getValueIterator(true);
                int val1 = itv1.next();
                while (itv0.hasNext()) {
                    int val0 = itv0.next();
                    if (!this.relation.isConsistent(val0, val1)) continue;
                    support = val0;
                    found = true;
                    break;
                }
                itv0.dispose();
                if (!found) {
                    if (val1 == right + 1) {
                        right = val1;
                    } else {
                        this.v1.removeInterval(left, right, this);
                        left = right = val1;
                    }
                } else {
                    this.storeSupportV1(support, val1);
                }
                found = false;
            }
            this.v1.removeInterval(left, right, this);
        }
        finally {
            itv1.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInstantiationOf(int idx) throws ContradictionException {
        if (idx == 0) {
            int value = this.v0.getValue();
            DisposableValueIterator iterator = this.v1.getValueIterator(true);
            int right = Integer.MIN_VALUE;
            int left = Integer.MIN_VALUE;
            try {
                while (iterator.hasNext()) {
                    int val = iterator.next();
                    if (this.relation.isConsistent(value, val)) continue;
                    if (val == right + 1) {
                        right = val;
                        continue;
                    }
                    this.v1.removeInterval(left, right, this);
                    left = right = val;
                }
                this.v1.removeInterval(left, right, this);
            }
            finally {
                iterator.dispose();
            }
        }
        int value = this.v1.getValue();
        DisposableValueIterator iterator = this.v0.getValueIterator(true);
        int right = Integer.MIN_VALUE;
        int left = Integer.MIN_VALUE;
        try {
            while (iterator.hasNext()) {
                int val = iterator.next();
                if (this.relation.isConsistent(val, value)) continue;
                if (val == right + 1) {
                    right = val;
                    continue;
                }
                if (val <= right + 1) continue;
                this.v0.removeInterval(left, right, this);
                left = right = val;
            }
            this.v0.removeInterval(left, right, this);
        }
        finally {
            iterator.dispose();
        }
    }
}

