/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.binary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.binary.CouplesTable;
import org.chocosolver.solver.constraints.extension.binary.PropBinCSP;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.iterators.DisposableValueIterator;

public class PropBinFC
extends PropBinCSP {
    public PropBinFC(IntVar x, IntVar y, Tuples tuples) {
        this(x, y, new CouplesTable(tuples, x, y));
    }

    private PropBinFC(IntVar x, IntVar y, CouplesTable table) {
        super(x, y, table);
    }

    @Override
    protected int getPropagationConditions(int vIdx) {
        return IntEventType.instantiation();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.v0.isInstantiated()) {
            this.onInstantiation0();
        }
        if (this.v1.isInstantiated()) {
            this.onInstantiation1();
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp == 0) {
            this.onInstantiation0();
        } else {
            this.onInstantiation1();
        }
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            ((IntVar[])this.vars)[0].duplicate(solver, identitymap);
            IntVar X = (IntVar)identitymap.get(((IntVar[])this.vars)[0]);
            ((IntVar[])this.vars)[1].duplicate(solver, identitymap);
            IntVar Y = (IntVar)identitymap.get(((IntVar[])this.vars)[1]);
            identitymap.put(this, new PropBinFC(X, Y, (CouplesTable)this.relation.duplicate()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInstantiation0() throws ContradictionException {
        int value = this.v0.getValue();
        DisposableValueIterator values = this.v1.getValueIterator(true);
        int right = Integer.MIN_VALUE;
        int left = Integer.MIN_VALUE;
        try {
            while (values.hasNext()) {
                int val = values.next();
                if (this.relation.isConsistent(value, val)) continue;
                if (val == right + 1) {
                    right = val;
                    continue;
                }
                this.v1.removeInterval(left, right, this);
                left = right = val;
            }
            this.v1.removeInterval(left, right, this);
        }
        finally {
            values.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInstantiation1() throws ContradictionException {
        int value = this.v1.getValue();
        DisposableValueIterator values = this.v0.getValueIterator(true);
        int right = Integer.MIN_VALUE;
        int left = Integer.MIN_VALUE;
        try {
            while (values.hasNext()) {
                int val = values.next();
                if (this.relation.isConsistent(val, value)) continue;
                if (val == right + 1) {
                    right = val;
                    continue;
                }
                this.v0.removeInterval(left, right, this);
                left = right = val;
            }
            this.v0.removeInterval(left, right, this);
        }
        finally {
            values.dispose();
        }
    }
}

