/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.nary.LargeRelation;
import org.chocosolver.solver.constraints.extension.nary.PropLargeCSP;
import org.chocosolver.solver.constraints.extension.nary.TuplesLargeTable;
import org.chocosolver.solver.constraints.extension.nary.TuplesTable;
import org.chocosolver.solver.constraints.extension.nary.TuplesVeryLargeTable;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;

public class PropLargeFC
extends PropLargeCSP<LargeRelation> {
    protected final int[] currentTuple;

    private PropLargeFC(IntVar[] vars, LargeRelation relation) {
        super(vars, relation);
        this.currentTuple = new int[vars.length];
    }

    public PropLargeFC(IntVar[] vars, Tuples tuples) {
        this(vars, PropLargeFC.makeRelation(tuples, vars));
    }

    private static LargeRelation makeRelation(Tuples tuples, IntVar[] vars) {
        long totalSize = 1L;
        for (int i = 0; i < vars.length && totalSize > 0L; totalSize *= (long)vars[i].getDomainSize(), ++i) {
        }
        if (totalSize < 0L) {
            return new TuplesVeryLargeTable(tuples, vars);
        }
        if (totalSize / 8L > 0x3200000L) {
            return new TuplesLargeTable(tuples, vars);
        }
        return new TuplesTable(tuples, vars);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.filter();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.forcePropagate(PropagatorEventType.FULL_PROPAGATION);
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            int[] tuple = new int[((IntVar[])this.vars).length];
            for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
                tuple[i] = ((IntVar[])this.vars)[i].getValue();
            }
            return ESat.eval(this.relation.isConsistent(tuple));
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CSPLarge({");
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(((IntVar[])this.vars)[i]).append(", ");
        }
        sb.append("})");
        return sb.toString();
    }

    protected void filter() throws ContradictionException {
        boolean stop = false;
        int nbUnassigned = 0;
        int index = -1;
        for (int i = 0; !stop && i < ((IntVar[])this.vars).length; ++i) {
            if (!((IntVar[])this.vars)[i].isInstantiated()) {
                ++nbUnassigned;
                index = i;
            } else {
                this.currentTuple[i] = ((IntVar[])this.vars)[i].getValue();
            }
            if (nbUnassigned <= 1) continue;
            stop = true;
        }
        if (!stop) {
            if (nbUnassigned == 1) {
                int left;
                int right = left = Integer.MIN_VALUE;
                int ub = ((IntVar[])this.vars)[index].getUB();
                int val = ((IntVar[])this.vars)[index].getLB();
                while (val <= ub) {
                    this.currentTuple[index] = val;
                    if (!this.relation.isConsistent(this.currentTuple)) {
                        if (val == right + 1) {
                            right = val;
                        } else {
                            ((IntVar[])this.vars)[index].removeInterval(left, right, this.aCause);
                            left = right = val;
                        }
                    }
                    val = ((IntVar[])this.vars)[index].nextValue(val);
                }
                ((IntVar[])this.vars)[index].removeInterval(left, right, this.aCause);
            } else if (!this.relation.isConsistent(this.currentTuple)) {
                this.contradiction(null, "not consistent");
            }
        }
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            identitymap.put(this, new PropLargeFC(aVars, this.relation.duplicate()));
        }
    }
}

