/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.nary.FastBooleanValidityChecker;
import org.chocosolver.solver.constraints.extension.nary.FastValidityChecker;
import org.chocosolver.solver.constraints.extension.nary.LargeRelation;
import org.chocosolver.solver.constraints.extension.nary.PropLargeCSP;
import org.chocosolver.solver.constraints.extension.nary.TuplesLargeTable;
import org.chocosolver.solver.constraints.extension.nary.TuplesTable;
import org.chocosolver.solver.constraints.extension.nary.TuplesVeryLargeTable;
import org.chocosolver.solver.constraints.extension.nary.ValidityChecker;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.PropagatorEventType;

public class PropLargeGAC2001
extends PropLargeCSP<LargeRelation> {
    protected IStateInt[] supports;
    protected int[] blocks;
    protected int size;
    protected int[] offsets;
    protected ValidityChecker valcheck;

    private PropLargeGAC2001(IntVar[] vs, LargeRelation relation) {
        super(vs, relation);
        this.size = vs.length;
        this.blocks = new int[this.size];
        this.offsets = new int[this.size];
        int nbElt = 0;
        boolean allboolean = true;
        for (int i = 0; i < this.size; ++i) {
            this.offsets[i] = vs[i].getLB();
            this.blocks[i] = nbElt;
            if ((((IntVar[])this.vars)[i].getTypeAndKind() & 0xF8) != 24) {
                allboolean = false;
            }
            if (!((IntVar[])this.vars)[i].hasEnumeratedDomain()) {
                throw new SolverException("GAC2001 can not be used with bound variables");
            }
            nbElt += ((IntVar[])this.vars)[i].getUB() - ((IntVar[])this.vars)[i].getLB() + 1;
        }
        this.supports = new IStateInt[nbElt * this.size];
        IEnvironment env = vs[0].getSolver().getEnvironment();
        for (int i = 0; i < this.supports.length; ++i) {
            this.supports[i] = env.makeInt(Integer.MIN_VALUE);
        }
        this.valcheck = allboolean ? new FastBooleanValidityChecker(this.size, (IntVar[])this.vars) : new FastValidityChecker(this.size, (IntVar[])this.vars);
    }

    public PropLargeGAC2001(IntVar[] vs, Tuples tuples) {
        this(vs, PropLargeGAC2001.makeRelation(tuples, vs));
    }

    private static LargeRelation makeRelation(Tuples tuples, IntVar[] vars) {
        long totalSize = 1L;
        for (int i = 0; i < vars.length && totalSize > 0L; totalSize *= (long)vars[i].getDomainSize(), ++i) {
        }
        if (totalSize < 0L) {
            return new TuplesVeryLargeTable(tuples, vars);
        }
        if (totalSize / 8L > 0x3200000L) {
            return new TuplesLargeTable(tuples, vars);
        }
        return new TuplesTable(tuples, vars);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            for (i = 0; i < ((IntVar[])this.vars).length; ++i) {
                this.reviseVar(i, true);
            }
        }
        for (i = 0; i < this.size; ++i) {
            this.reviseVar(i, false);
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.filter(idxVarInProp);
    }

    public void reviseVar(int indexVar, boolean fromScratch) throws ContradictionException {
        int left;
        int right = left = Integer.MIN_VALUE;
        int val = ((IntVar[])this.vars)[indexVar].getLB();
        while (val <= ((IntVar[])this.vars)[indexVar].getUB()) {
            int[] currentSupport = this.seekNextSupport(indexVar, val, fromScratch);
            if (currentSupport != null) {
                this.setSupport(indexVar, val, currentSupport);
            } else if (val == right + 1) {
                right = val;
            } else {
                ((IntVar[])this.vars)[indexVar].removeInterval(left, right, this);
                left = right = val;
            }
            val = ((IntVar[])this.vars)[indexVar].nextValue(val);
        }
        ((IntVar[])this.vars)[indexVar].removeInterval(left, right, this);
    }

    public void setSupport(int indexVar, int value, int[] support) {
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            this.supports[(this.blocks[indexVar] + value - this.offsets[indexVar]) * this.size + i].set(support[i]);
        }
    }

    public int[] getUBport(int indexVar, int value) {
        int[] resultat = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            resultat[i] = this.supports[(this.blocks[indexVar] + value - this.offsets[indexVar]) * this.size + i].get();
        }
        return resultat;
    }

    public int[] lastSupport(int indexVar, int value) {
        return this.getUBport(indexVar, value);
    }

    public int[] seekNextSupport(int indexVar, int val, boolean fromscratch) {
        int[] currentSupport = new int[this.size];
        int k = 0;
        if (fromscratch) {
            for (int i = 0; i < this.size; ++i) {
                currentSupport[i] = i != indexVar ? ((IntVar[])this.vars)[i].getLB() : val;
            }
            if (this.relation.isConsistent(currentSupport)) {
                return currentSupport;
            }
        } else {
            currentSupport = this.getUBport(indexVar, val);
            if (this.valcheck.isValid(currentSupport)) {
                return currentSupport;
            }
            if ((currentSupport = this.getFirstValidTupleFrom(currentSupport, indexVar)) == null) {
                return null;
            }
            if (this.relation.isConsistent(currentSupport)) {
                return currentSupport;
            }
        }
        while (k < ((IntVar[])this.vars).length) {
            if (k == indexVar) {
                ++k;
            }
            if (k >= ((IntVar[])this.vars).length) continue;
            if (((IntVar[])this.vars)[k].nextValue(currentSupport[k]) == Integer.MAX_VALUE) {
                currentSupport[k] = ((IntVar[])this.vars)[k].getLB();
                ++k;
                continue;
            }
            currentSupport[k] = ((IntVar[])this.vars)[k].nextValue(currentSupport[k]);
            if (this.relation.isConsistent(currentSupport)) {
                return currentSupport;
            }
            k = 0;
        }
        return null;
    }

    public int[] getFirstValidTupleFrom(int[] t, int indexVar) {
        int k = 0;
        while (k < ((IntVar[])this.vars).length) {
            if (k == indexVar) {
                ++k;
            }
            if (k >= ((IntVar[])this.vars).length) continue;
            if (((IntVar[])this.vars)[k].nextValue(t[k]) == Integer.MAX_VALUE) {
                t[k] = ((IntVar[])this.vars)[k].getLB();
                ++k;
                continue;
            }
            t[k] = ((IntVar[])this.vars)[k].nextValue(t[k]);
            if (this.valcheck.isValid(t)) {
                return t;
            }
            k = 0;
        }
        return null;
    }

    public void filter(int idx) throws ContradictionException {
        this.valcheck.sortvars();
        if (((IntVar[])this.vars)[idx].hasEnumeratedDomain()) {
            for (int i = 0; i < this.size; ++i) {
                if (idx == this.valcheck.position[i]) continue;
                this.reviseVar(this.valcheck.position[i], false);
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.reviseVar(this.valcheck.position[i], false);
            }
        }
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            identitymap.put(this, new PropLargeGAC2001(aVars, this.relation.duplicate()));
        }
    }
}

