/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.nary.FastBooleanValidityChecker;
import org.chocosolver.solver.constraints.extension.nary.FastValidityChecker;
import org.chocosolver.solver.constraints.extension.nary.IterTuplesTable;
import org.chocosolver.solver.constraints.extension.nary.PropLargeCSP;
import org.chocosolver.solver.constraints.extension.nary.ValidityChecker;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.iterators.DisposableValueIterator;

public class PropLargeGAC2001Positive
extends PropLargeCSP<IterTuplesTable> {
    protected IStateInt[][] supports;
    protected int[] blocks;
    protected int arity;
    protected int[] offsets;
    protected static final int NO_SUPPORT = -2;
    protected int[][][] tab;
    protected ValidityChecker valcheck;

    private PropLargeGAC2001Positive(IntVar[] vs, IterTuplesTable relation) {
        super(vs, relation);
        this.arity = vs.length;
        this.blocks = new int[this.arity];
        this.offsets = new int[this.arity];
        this.supports = new IStateInt[this.arity][];
        IEnvironment environment = this.solver.getEnvironment();
        for (int i = 0; i < this.arity; ++i) {
            this.offsets[i] = vs[i].getLB();
            this.supports[i] = new IStateInt[((IntVar[])this.vars)[i].getDomainSize()];
            for (int j = 0; j < this.supports[i].length; ++j) {
                this.supports[i][j] = environment.makeInt(0);
            }
        }
        this.tab = relation.getTableLists();
        int[][] tt = relation.getTupleTable();
        boolean fastValidCheckAllowed = true;
        boolean fastBooleanValidCheckAllowed = true;
        for (int i = 0; i < tt.length; ++i) {
            for (int j = 0; j < tt[i].length; ++j) {
                int lb = vs[j].getLB();
                int ub = vs[j].getUB();
                if (lb > tt[i][j] || ub < tt[i][j]) {
                    fastValidCheckAllowed = false;
                }
                if (lb >= 0 && ub <= 1) continue;
                fastBooleanValidCheckAllowed = false;
            }
            if (!fastBooleanValidCheckAllowed && !fastValidCheckAllowed) break;
        }
        this.valcheck = fastBooleanValidCheckAllowed ? new FastBooleanValidityChecker(this.arity, (IntVar[])this.vars) : (fastValidCheckAllowed ? new FastValidityChecker(this.arity, (IntVar[])this.vars) : new ValidityChecker(this.arity, (IntVar[])this.vars));
    }

    public PropLargeGAC2001Positive(IntVar[] vs, Tuples tuples) {
        this(vs, PropLargeGAC2001Positive.makeRelation(tuples, vs));
    }

    private static IterTuplesTable makeRelation(Tuples tuples, IntVar[] vars) {
        return new IterTuplesTable(tuples, vars);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        for (int indexVar = 0; indexVar < this.arity; ++indexVar) {
            this.reviseVar(indexVar);
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.filter(idxVarInProp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reviseVar(int indexVar) throws ContradictionException {
        int left;
        DisposableValueIterator itv = ((IntVar[])this.vars)[indexVar].getValueIterator(true);
        int right = left = Integer.MIN_VALUE;
        try {
            while (itv.hasNext()) {
                int val = itv.next();
                int nva = val - ((IterTuplesTable)this.relation).getRelationOffset(indexVar);
                int currentIdxSupport = this.getUBport(indexVar, val);
                if ((currentIdxSupport = this.seekNextSupport(indexVar, nva, currentIdxSupport)) == -2) {
                    if (val == right + 1) {
                        right = val;
                        continue;
                    }
                    ((IntVar[])this.vars)[indexVar].removeInterval(left, right, this.aCause);
                    left = right = val;
                    continue;
                }
                this.setSupport(indexVar, val, currentIdxSupport);
            }
            ((IntVar[])this.vars)[indexVar].removeInterval(left, right, this.aCause);
        }
        finally {
            itv.dispose();
        }
    }

    public int seekNextSupport(int indexVar, int nva, int start) {
        for (int i = start; i < this.tab[indexVar][nva].length; ++i) {
            int currentIdxSupport = this.tab[indexVar][nva][i];
            int[] currentSupport = ((IterTuplesTable)this.relation).getTuple(currentIdxSupport);
            if (!this.valcheck.isValid(currentSupport)) continue;
            return i;
        }
        return -2;
    }

    public void setSupport(int indexVar, int value, int idxSupport) {
        this.supports[indexVar][value - this.offsets[indexVar]].set(idxSupport);
    }

    public int getUBport(int indexVar, int value) {
        return this.supports[indexVar][value - this.offsets[indexVar]].get();
    }

    public void filter(int idx) throws ContradictionException {
        this.valcheck.sortvars();
        for (int i = 0; i < this.arity; ++i) {
            if (idx == this.valcheck.position[i]) continue;
            this.reviseVar(this.valcheck.position[i]);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GAC2001AllowedLarge({");
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            IntVar var = ((IntVar[])this.vars)[i];
            sb.append(var);
        }
        sb.append("})");
        return sb.toString();
    }

    public boolean isSatisfied(int[] tuple) {
        int minListIdx = -1;
        int minSize = Integer.MAX_VALUE;
        for (int i = 0; i < tuple.length; ++i) {
            if (this.tab[i][tuple[i] - this.offsets[i]].length >= minSize) continue;
            minSize = this.tab[i][tuple[i] - this.offsets[i]].length;
            minListIdx = i;
        }
        int nva = tuple[minListIdx] - ((IterTuplesTable)this.relation).getRelationOffset(minListIdx);
        for (int i = 0; i < this.tab[minListIdx][nva].length; ++i) {
            int currentIdxSupport = this.tab[minListIdx][nva][i];
            int[] currentSupport = ((IterTuplesTable)this.relation).getTuple(currentIdxSupport);
            boolean isValid = true;
            for (int j = 0; isValid && j < tuple.length; ++j) {
                if (tuple[j] == currentSupport[j]) continue;
                isValid = false;
            }
            if (!isValid) continue;
            return true;
        }
        return false;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            identitymap.put(this, new PropLargeGAC2001Positive(aVars, (IterTuplesTable)((IterTuplesTable)this.relation).duplicate()));
        }
    }
}

