/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.nary.FastBooleanValidityChecker;
import org.chocosolver.solver.constraints.extension.nary.FastValidityChecker;
import org.chocosolver.solver.constraints.extension.nary.IterTuplesTable;
import org.chocosolver.solver.constraints.extension.nary.PropLargeCSP;
import org.chocosolver.solver.constraints.extension.nary.ValidityChecker;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;

public class PropLargeGAC3rmPositive
extends PropLargeCSP<IterTuplesTable> {
    protected final int[][] supports;
    protected final int arity;
    protected final int[] offsets;
    protected static final int NO_SUPPORT = -2;
    protected int[][][] tab;
    protected ValidityChecker valcheck;

    private PropLargeGAC3rmPositive(IntVar[] vars, IterTuplesTable relation) {
        super(vars, relation);
        this.arity = vars.length;
        this.offsets = new int[this.arity];
        this.supports = new int[this.arity][];
        for (int i = 0; i < this.arity; ++i) {
            this.offsets[i] = vars[i].getLB();
            this.supports[i] = new int[vars[i].getDomainSize()];
        }
        this.tab = relation.getTableLists();
        int[][] tt = relation.getTupleTable();
        boolean fastValidCheckAllowed = true;
        boolean fastBooleanValidCheckAllowed = true;
        for (int i = 0; i < tt.length; ++i) {
            for (int j = 0; j < tt[i].length; ++j) {
                int lb = vars[j].getLB();
                int ub = vars[j].getUB();
                if (lb > tt[i][j] || ub < tt[i][j]) {
                    fastValidCheckAllowed = false;
                }
                if (lb >= 0 && ub <= 1) continue;
                fastBooleanValidCheckAllowed = false;
            }
            if (!fastBooleanValidCheckAllowed && !fastValidCheckAllowed) break;
        }
        this.valcheck = fastBooleanValidCheckAllowed ? new FastBooleanValidityChecker(this.arity, vars) : (fastValidCheckAllowed ? new FastValidityChecker(this.arity, vars) : new ValidityChecker(this.arity, vars));
    }

    public PropLargeGAC3rmPositive(IntVar[] vars, Tuples tuples) {
        this(vars, PropLargeGAC3rmPositive.makeRelation(tuples, vars));
    }

    private static IterTuplesTable makeRelation(Tuples tuples, IntVar[] vars) {
        return new IterTuplesTable(tuples, vars);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.initSupports();
        for (int indexVar = 0; indexVar < this.arity; ++indexVar) {
            this.reviseVar(indexVar);
        }
    }

    @Override
    public void propagate(int vIdx, int mask) throws ContradictionException {
        this.filter(vIdx);
    }

    protected void initSupports() throws ContradictionException {
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            int left;
            int right = left = Integer.MIN_VALUE;
            int ubi = ((IntVar[])this.vars)[i].getUB();
            int val = ((IntVar[])this.vars)[i].getLB();
            while (val <= ubi) {
                int nva = val - ((IterTuplesTable)this.relation).getRelationOffset(i);
                if (this.tab[i][nva].length == 0) {
                    if (val == right + 1) {
                        right = val;
                    } else {
                        ((IntVar[])this.vars)[i].removeInterval(left, right, this.aCause);
                        left = right = val;
                    }
                } else {
                    this.setSupport(this.tab[i][nva][0]);
                }
                val = ((IntVar[])this.vars)[i].nextValue(val);
            }
            ((IntVar[])this.vars)[i].removeInterval(left, right, this.aCause);
        }
    }

    protected void setSupport(int idxSupport) {
        int[] tuple = ((IterTuplesTable)this.relation).getTuple(idxSupport);
        for (int i = 0; i < tuple.length; ++i) {
            this.supports[i][tuple[i] - this.offsets[i]] = idxSupport;
        }
    }

    protected int getSupport(int indexVar, int value) {
        return this.supports[indexVar][value - this.offsets[indexVar]];
    }

    protected void reviseVar(int indexVar) throws ContradictionException {
        int left;
        int right = left = Integer.MIN_VALUE;
        int ub = ((IntVar[])this.vars)[indexVar].getUB();
        int val = ((IntVar[])this.vars)[indexVar].getLB();
        while (val <= ub) {
            int nva = val - ((IterTuplesTable)this.relation).getRelationOffset(indexVar);
            int currentIdxSupport = this.getSupport(indexVar, val);
            if (!this.valcheck.isValid(((IterTuplesTable)this.relation).getTuple(currentIdxSupport))) {
                currentIdxSupport = this.seekNextSupport(indexVar, nva);
                if (currentIdxSupport == -2) {
                    if (val == right + 1) {
                        right = val;
                    } else {
                        ((IntVar[])this.vars)[indexVar].removeInterval(left, right, this.aCause);
                        left = right = val;
                    }
                } else {
                    this.setSupport(currentIdxSupport);
                }
            }
            val = ((IntVar[])this.vars)[indexVar].nextValue(val);
        }
        ((IntVar[])this.vars)[indexVar].removeInterval(left, right, this.aCause);
    }

    protected int seekNextSupport(int indexVar, int nva) {
        for (int i = 0; i < this.tab[indexVar][nva].length; ++i) {
            int currentIdxSupport = this.tab[indexVar][nva][i];
            int[] currentSupport = ((IterTuplesTable)this.relation).getTuple(currentIdxSupport);
            if (!this.valcheck.isValid(currentSupport)) continue;
            return currentIdxSupport;
        }
        return -2;
    }

    protected void filter(int idx) throws ContradictionException {
        this.valcheck.sortvars();
        for (int i = 0; i < this.arity; ++i) {
            if (idx == this.valcheck.getPosition(i)) continue;
            this.reviseVar(this.valcheck.getPosition(i));
        }
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            identitymap.put(this, new PropLargeGAC3rmPositive(aVars, (IterTuplesTable)((IterTuplesTable)this.relation).duplicate()));
        }
    }
}

