/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import gnu.trove.list.TIntList;
import gnu.trove.list.linked.TIntLinkedList;
import gnu.trove.map.hash.THashMap;
import java.util.BitSet;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.nary.FastBooleanValidityChecker;
import org.chocosolver.solver.constraints.extension.nary.FastValidityChecker;
import org.chocosolver.solver.constraints.extension.nary.PropLargeCSP;
import org.chocosolver.solver.constraints.extension.nary.TuplesList;
import org.chocosolver.solver.constraints.extension.nary.ValidityChecker;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.iterators.DisposableValueIterator;

public class PropLargeGACSTRPos
extends PropLargeCSP<TuplesList> {
    protected ValidityChecker valcheck;
    protected int arity;
    protected int[] offsets;
    protected TIntList futureVars;
    protected BitSet[] gacValues;
    protected int[] nbGacValues;
    protected IStateInt last;
    int[] listuples;

    private PropLargeGACSTRPos(IntVar[] vs, TuplesList relation) {
        super(vs, relation);
        int i;
        this.arity = vs.length;
        this.futureVars = new TIntLinkedList();
        this.gacValues = new BitSet[this.arity];
        this.nbGacValues = new int[this.arity];
        this.offsets = new int[this.arity];
        for (i = 0; i < this.arity; ++i) {
            this.offsets[i] = vs[i].getLB();
            this.gacValues[i] = new BitSet(vs[i].getDomainSize());
        }
        this.listuples = new int[((TuplesList)this.relation).getTupleTable().length];
        for (i = 0; i < this.listuples.length; ++i) {
            this.listuples[i] = i;
        }
        this.last = this.solver.getEnvironment().makeInt(this.listuples.length - 1);
        int[][] tt = ((TuplesList)this.relation).getTupleTable();
        boolean fastValidCheckAllowed = true;
        boolean fastBooleanValidCheckAllowed = true;
        for (int i2 = 0; i2 < tt.length; ++i2) {
            for (int j = 0; j < tt[i2].length; ++j) {
                int lb = vs[j].getLB();
                int ub = vs[j].getUB();
                if (lb > tt[i2][j] || ub < tt[i2][j]) {
                    fastValidCheckAllowed = false;
                }
                if (lb >= 0 && ub <= 1) continue;
                fastBooleanValidCheckAllowed = false;
            }
            if (!fastBooleanValidCheckAllowed && !fastValidCheckAllowed) break;
        }
        this.valcheck = fastBooleanValidCheckAllowed ? new FastBooleanValidityChecker(this.arity, (IntVar[])this.vars) : (fastValidCheckAllowed ? new FastValidityChecker(this.arity, (IntVar[])this.vars) : new ValidityChecker(this.arity, (IntVar[])this.vars));
    }

    public PropLargeGACSTRPos(IntVar[] vs, Tuples tuples) {
        this(vs, PropLargeGACSTRPos.makeRelation(tuples, vs));
    }

    private static TuplesList makeRelation(Tuples tuples, IntVar[] vars) {
        return new TuplesList(tuples, vars);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.valcheck.sortvars();
        this.gacstr();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.filter();
    }

    public void initializeData() {
        this.futureVars.clear();
        for (int i = 0; i < this.arity; ++i) {
            this.gacValues[i].clear();
            this.nbGacValues[i] = 0;
            this.futureVars.add(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pruningPhase() throws ContradictionException {
        for (int i = 0; i < this.futureVars.size(); ++i) {
            int left;
            int vIdx = this.futureVars.get(i);
            IntVar v = ((IntVar[])this.vars)[vIdx];
            DisposableValueIterator it3 = v.getValueIterator(true);
            int right = left = Integer.MIN_VALUE;
            try {
                while (it3.hasNext()) {
                    int val = it3.next();
                    if (this.gacValues[vIdx].get(val - this.offsets[vIdx])) continue;
                    if (val == right + 1) {
                        right = val;
                        continue;
                    }
                    v.removeInterval(left, right, this);
                    left = right = val;
                }
                v.removeInterval(left, right, this);
                continue;
            }
            finally {
                it3.dispose();
            }
        }
    }

    public void maintainList() {
        int cidx = 0;
        int nLast = this.last.get();
        while (cidx <= nLast) {
            int idxt;
            int[] tuple;
            if (this.valcheck.isValid(tuple = ((TuplesList)this.relation).getTuple(idxt = this.listuples[cidx++]))) {
                for (int i = 0; i < this.futureVars.size(); ++i) {
                    int vIdx = this.futureVars.get(i);
                    if (this.gacValues[vIdx].get(tuple[vIdx] - this.offsets[vIdx])) continue;
                    this.gacValues[vIdx].set(tuple[vIdx] - this.offsets[vIdx]);
                    int n = vIdx;
                    this.nbGacValues[n] = this.nbGacValues[n] + 1;
                    if (this.nbGacValues[vIdx] != ((IntVar[])this.vars)[vIdx].getDomainSize()) continue;
                    this.futureVars.removeAt(i);
                    --i;
                }
                continue;
            }
            int temp = this.listuples[nLast];
            this.listuples[nLast] = this.listuples[--cidx];
            this.listuples[cidx] = temp;
            this.last.add(-1);
            --nLast;
        }
    }

    public void gacstr() throws ContradictionException {
        this.initializeData();
        this.maintainList();
        this.pruningPhase();
        if (this.getCartesianProduct() <= (double)(this.last.get() + 1)) {
            this.setPassive();
        }
    }

    public double getCartesianProduct() {
        double cp = 1.0;
        for (int i = 0; i < this.arity; ++i) {
            cp *= (double)((IntVar[])this.vars)[i].getDomainSize();
        }
        return cp;
    }

    public void filter() throws ContradictionException {
        this.valcheck.sortvars();
        this.gacstr();
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            identitymap.put(this, new PropLargeGACSTRPos(aVars, (TuplesList)((TuplesList)this.relation).duplicate()));
        }
    }
}

