/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import java.util.TreeMap;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.objects.setDataStructures.swapList.Set_Std_Swap_Array;

public class PropTableStr2
extends Propagator<IntVar> {
    int[][] table;
    str2_var[] str2vars;
    Set_Std_Swap_Array tuples;
    ArrayList<str2_var> Ssup;
    ArrayList<str2_var> Sval;
    boolean firstProp = true;

    public PropTableStr2(IntVar[] vars_, int[][] table) {
        super((Variable[])vars_, PropagatorPriority.LINEAR, false);
        this.str2vars = new str2_var[table[0].length];
        for (int i = 0; i < table[0].length; ++i) {
            this.str2vars[i] = new str2_var(this.solver.getEnvironment(), vars_[i], i, table);
        }
        this.tuples = new Set_Std_Swap_Array(this.solver.getEnvironment(), table.length);
        this.Ssup = new ArrayList();
        this.Sval = new ArrayList();
        this.table = table;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.firstProp) {
            this.firstProp = false;
            this.initialPropagate();
        }
        this.Filter();
    }

    @Override
    public ESat isEntailed() {
        boolean hasSupport = false;
        int tuple = this.tuples.getFirstElement();
        while (tuple >= 0 && !hasSupport) {
            if (this.is_tuple_supported(tuple)) {
                hasSupport = true;
            }
            tuple = this.tuples.getNextElement();
        }
        if (hasSupport) {
            if (this.isCompletelyInstantiated()) {
                return ESat.TRUE;
            }
            return ESat.UNDEFINED;
        }
        return ESat.FALSE;
    }

    @Override
    public String toString() {
        return "STR2 table constraint with " + this.table[0].length + "vars and " + this.table.length + "tuples";
    }

    boolean is_tuple_supported(int tuple_index) {
        for (str2_var v : this.Sval) {
            if (v.var.contains(this.table[tuple_index][v.indice])) continue;
            return false;
        }
        return true;
    }

    void initialPropagate() throws ContradictionException {
        for (str2_var vst : this.str2vars) {
            DisposableValueIterator vit = vst.var.getValueIterator(true);
            while (vit.hasNext()) {
                int value = vit.next();
                if (vst.index_map.containsKey(value)) continue;
                vst.var.removeValue(value, this.aCause);
            }
            vit.dispose();
        }
        for (int t = 0; t < this.table.length; ++t) {
            this.tuples.add(t);
        }
    }

    void Filter() throws ContradictionException {
        this.Ssup.clear();
        this.Sval.clear();
        for (str2_var tmp : this.str2vars) {
            tmp.GAC_clear();
            this.Ssup.add(tmp);
            if (tmp.last_size.get() == tmp.var.getDomainSize()) continue;
            this.Sval.add(tmp);
            tmp.last_size.set(tmp.var.getDomainSize());
        }
        int tuple = this.tuples.getFirstElement();
        while (tuple >= 0) {
            if (this.is_tuple_supported(tuple)) {
                for (int var = 0; var < this.Ssup.size(); ++var) {
                    str2_var v = this.Ssup.get(var);
                    if (v.isConsistant(this.table[tuple][v.indice])) continue;
                    v.makeConsistant(this.table[tuple][v.indice]);
                    if (v.nb_consistant != v.var.getDomainSize()) continue;
                    this.Ssup.set(var, this.Ssup.get(this.Ssup.size() - 1));
                    this.Ssup.remove(this.Ssup.size() - 1);
                    --var;
                }
            } else {
                this.tuples.remove(tuple);
            }
            tuple = this.tuples.getNextElement();
        }
        for (str2_var v : this.Ssup) {
            v.remove_unsupported_value();
        }
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            identitymap.put(this, new PropTableStr2(aVars, (int[][])this.table.clone()));
        }
    }

    class str2_var {
        IntVar var;
        int indice;
        IStateInt last_size;
        BitSet GAC_Val;
        int nb_consistant;
        TreeMap<Integer, Integer> index_map;

        str2_var(IEnvironment env, IntVar var_, int indice_, int[][] table) {
            this.var = var_;
            this.last_size = env.makeInt(0);
            this.indice = indice_;
            this.nb_consistant = 0;
            this.index_map = new TreeMap();
            int key = 0;
            for (int[] t : table) {
                if (this.index_map.containsKey(t[this.indice])) continue;
                this.index_map.put(t[this.indice], key++);
            }
            this.GAC_Val = new BitSet(this.index_map.size());
        }

        void GAC_clear() {
            this.GAC_Val.clear();
            this.nb_consistant = 0;
        }

        boolean isConsistant(int value) {
            return this.GAC_Val.get(this.index_map.get(value));
        }

        void makeConsistant(int value) {
            this.GAC_Val.set(this.index_map.get(value));
            ++this.nb_consistant;
        }

        void remove_unsupported_value() throws ContradictionException {
            for (Map.Entry<Integer, Integer> e : this.index_map.entrySet()) {
                if (!this.var.contains(e.getKey()) || this.GAC_Val.get(e.getValue())) continue;
                this.var.removeValue(e.getKey(), PropTableStr2.this.aCause);
            }
        }
    }
}

