/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.nary.LargeRelation;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;

public class TuplesLargeTable
extends LargeRelation {
    protected final int n;
    protected final TIntObjectHashMap<TIntSet> tables;
    protected final int[] lowerbounds;
    protected final int[] upperbounds;
    protected final boolean feasible;
    protected long[] blocks;

    public TuplesLargeTable(Tuples tuples, IntVar[] vars) {
        this.n = vars.length;
        this.lowerbounds = new int[this.n];
        this.upperbounds = new int[this.n];
        this.feasible = tuples.isFeasible();
        this.blocks = new long[this.n];
        long totalSize = 1L;
        for (int i = 0; i < this.n; ++i) {
            this.blocks[i] = totalSize;
            this.lowerbounds[i] = vars[i].getLB();
            this.upperbounds[i] = vars[i].getUB();
            if ((totalSize *= (long)(this.upperbounds[i] - this.lowerbounds[i] + 1)) >= 0L) continue;
            totalSize = -1L;
        }
        if (totalSize / Integer.MAX_VALUE + 1L < 0L || totalSize / Integer.MAX_VALUE + 1L > Integer.MAX_VALUE) {
            throw new SolverException("Tuples required too much memory ...");
        }
        this.tables = new TIntObjectHashMap();
        int nt = tuples.nbTuples();
        for (int i = 0; i < nt; ++i) {
            int[] tuple = tuples.get(i);
            if (!this.valid(tuple, vars)) continue;
            this.setTuple(tuple);
        }
    }

    private TuplesLargeTable(int n, TIntObjectHashMap<TIntSet> tables, int[] lowerbounds, int[] upperbounds, boolean feasible, long[] blocks) {
        this.n = n;
        this.tables = tables;
        this.lowerbounds = lowerbounds;
        this.upperbounds = upperbounds;
        this.feasible = feasible;
        this.blocks = blocks;
    }

    @Override
    public boolean checkTuple(int[] tuple) {
        long address = 0L;
        for (int i = this.n - 1; i >= 0; --i) {
            if (tuple[i] < this.lowerbounds[i] || tuple[i] > this.upperbounds[i]) {
                return false;
            }
            address += (long)(tuple[i] - this.lowerbounds[i]) * this.blocks[i];
        }
        int a = (int)(address % Integer.MAX_VALUE);
        int t = (int)(address / Integer.MAX_VALUE);
        TIntSet ts = this.tables.get(t);
        return ts != null && ts.contains(a);
    }

    @Override
    public boolean isConsistent(int[] tuple) {
        return this.checkTuple(tuple) == this.feasible;
    }

    void setTuple(int[] tuple) {
        long address = 0L;
        for (int i = this.n - 1; i >= 0; --i) {
            address += (long)(tuple[i] - this.lowerbounds[i]) * this.blocks[i];
        }
        int a = (int)(address % Integer.MAX_VALUE);
        int t = (int)(address / Integer.MAX_VALUE);
        TIntSet ts = this.tables.get(t);
        if (ts == null) {
            ts = new TIntHashSet();
            this.tables.put(t, ts);
        }
        ts.add(a);
    }

    @Override
    public LargeRelation duplicate() {
        TIntObjectHashMap<TIntSet> ntables = new TIntObjectHashMap<TIntSet>();
        for (int t : this.tables.keys()) {
            ntables.put(t, new TIntHashSet(this.tables.get(t)));
        }
        return new TuplesLargeTable(this.n, ntables, (int[])this.lowerbounds.clone(), (int[])this.upperbounds.clone(), this.feasible, (long[])this.blocks.clone());
    }
}

