/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import gnu.trove.map.hash.TIntObjectHashMap;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.nary.LargeRelation;
import org.chocosolver.solver.variables.IntVar;

public class TuplesVeryLargeTable
extends LargeRelation {
    protected final int n;
    protected final int[] lowerbounds;
    protected final int[] upperbounds;
    protected final boolean feasible;
    protected final TIntObjectHashMap<TIntObjectHashMap> supports;

    public TuplesVeryLargeTable(Tuples tuples, IntVar[] vars) {
        this.n = vars.length;
        this.lowerbounds = new int[this.n];
        this.upperbounds = new int[this.n];
        this.feasible = tuples.isFeasible();
        for (int i = 0; i < this.n; ++i) {
            this.lowerbounds[i] = vars[i].getLB();
            this.upperbounds[i] = vars[i].getUB();
        }
        this.supports = new TIntObjectHashMap();
        int nt = tuples.nbTuples();
        for (int i = 0; i < nt; ++i) {
            int[] tuple = tuples.get(i);
            if (!this.valid(tuple, vars)) continue;
            this.setTuple(tuple);
        }
    }

    public TuplesVeryLargeTable(int n, int[] lowerbounds, int[] upperbounds, boolean feasible, TIntObjectHashMap<TIntObjectHashMap> supports) {
        this.n = n;
        this.lowerbounds = lowerbounds;
        this.upperbounds = upperbounds;
        this.feasible = feasible;
        this.supports = supports;
    }

    @Override
    public boolean checkTuple(int[] tuple) {
        TIntObjectHashMap current = this.supports;
        int i = 0;
        while (i < this.n - 1) {
            if ((current = current.get(tuple[i++])) != null) continue;
            return false;
        }
        return (current = current.get(tuple[i])) != null;
    }

    @Override
    public boolean isConsistent(int[] tuple) {
        return this.checkTuple(tuple) == this.feasible;
    }

    void setTuple(int[] tuple) {
        TIntObjectHashMap current = this.supports;
        for (int i = 0; i < tuple.length; ++i) {
            TIntObjectHashMap _current = current.get(tuple[i]);
            if (_current == null) {
                _current = new TIntObjectHashMap();
                current.put(tuple[i], _current);
            }
            current = _current;
        }
    }

    private void deepCopy(TIntObjectHashMap<TIntObjectHashMap> from, TIntObjectHashMap<TIntObjectHashMap> to) {
        for (int k : from.keys()) {
            TIntObjectHashMap<TIntObjectHashMap> _to = new TIntObjectHashMap<TIntObjectHashMap>();
            to.put(k, _to);
            this.deepCopy(from.get(k), _to);
        }
    }

    @Override
    public LargeRelation duplicate() {
        TIntObjectHashMap<TIntObjectHashMap> _supports = new TIntObjectHashMap<TIntObjectHashMap>();
        this.deepCopy(this.supports, _supports);
        return new TuplesVeryLargeTable(this.n, (int[])this.lowerbounds.clone(), (int[])this.upperbounds.clone(), this.feasible, _supports);
    }
}

