/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import org.chocosolver.solver.variables.IntVar;

public class ValidityChecker
implements Comparator<IntVar>,
Serializable {
    protected IntVar[] sortedvs;
    public int[] position;
    protected TObjectIntHashMap<IntVar> mapinit;
    protected int arity;

    public ValidityChecker(int ari, IntVar[] vars) {
        this.arity = ari;
        this.sortedvs = new IntVar[this.arity];
        this.mapinit = new TObjectIntHashMap(this.arity);
        this.position = new int[this.arity];
        for (int i = 0; i < vars.length; ++i) {
            this.sortedvs[i] = vars[i];
            this.mapinit.put(vars[i], i);
            this.position[i] = i;
        }
    }

    public final int getPosition(int idx) {
        return this.position[idx];
    }

    public void sortvars() {
        Arrays.sort(this.sortedvs, this);
        for (int i = 0; i < this.arity; ++i) {
            this.position[i] = this.mapinit.get(this.sortedvs[i]);
        }
    }

    public boolean isValid(int[] tuple) {
        for (int i = 0; i < this.arity; ++i) {
            if (this.sortedvs[i].contains(tuple[this.position[i]])) continue;
            return false;
        }
        return true;
    }

    public boolean isValid(int[] tuple, int i) {
        return this.sortedvs[i].contains(tuple[this.position[i]]);
    }

    @Override
    public int compare(IntVar o, IntVar o1) {
        return o.getDomainSize() - o1.getDomainSize();
    }
}

