/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.tools.ArrayUtils;

public class PropDiffN
extends Propagator<IntVar> {
    private int n;
    private UndirectedGraph overlappingBoxes;
    private ISet boxesToCompute;
    private boolean fast;

    public PropDiffN(IntVar[] x, IntVar[] y, IntVar[] dx, IntVar[] dy, boolean fast) {
        super((Variable[])ArrayUtils.append(x, y, dx, dy), PropagatorPriority.LINEAR, true);
        this.fast = fast;
        this.n = x.length;
        if (this.n != y.length || this.n != dx.length || this.n != dy.length) {
            throw new UnsupportedOperationException();
        }
        this.overlappingBoxes = new UndirectedGraph(this.solver, this.n, SetType.LINKED_LIST, true);
        this.boxesToCompute = SetFactory.makeStoredSet(SetType.LINKED_LIST, this.n, this.solver);
    }

    @Override
    public int getPropagationConditions(int idx) {
        if (this.fast) {
            return IntEventType.instantiation();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        int v = varIdx % this.n;
        ISet s = this.overlappingBoxes.getNeighOf(v);
        int i = s.getFirstElement();
        while (i >= 0) {
            if (!this.mayOverlap(v, i)) {
                this.overlappingBoxes.removeEdge(v, i);
            }
            i = s.getNextElement();
        }
        if (!this.boxesToCompute.contain(v)) {
            this.boxesToCompute.add(v);
        }
        this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            for (i = 0; i < this.n; ++i) {
                this.overlappingBoxes.getNeighOf(i).clear();
            }
            for (i = 0; i < this.n; ++i) {
                for (int j = i + 1; j < this.n; ++j) {
                    if (!this.mayOverlap(i, j)) continue;
                    this.overlappingBoxes.addEdge(i, j);
                    if (!this.boxInstantiated(i) || !this.boxInstantiated(j)) continue;
                    this.contradiction(((IntVar[])this.vars)[i], "");
                }
            }
            this.boxesToCompute.clear();
            for (i = 0; i < this.n; ++i) {
                this.boxesToCompute.add(i);
            }
        }
        i = this.boxesToCompute.getFirstElement();
        while (i >= 0) {
            this.filterFromBox(i);
            i = this.boxesToCompute.getNextElement();
        }
        this.boxesToCompute.clear();
    }

    private boolean mayOverlap(int i, int j) {
        return !this.disjoint(i, j, true) && !this.disjoint(i, j, false);
    }

    private boolean disjoint(int i, int j, boolean horizontal) {
        int off = horizontal ? 0 : this.n;
        return ((IntVar[])this.vars)[i + off].getLB() >= ((IntVar[])this.vars)[j + off].getUB() + ((IntVar[])this.vars)[j + off + 2 * this.n].getUB() || ((IntVar[])this.vars)[j + off].getLB() >= ((IntVar[])this.vars)[i + off].getUB() + ((IntVar[])this.vars)[i + off + 2 * this.n].getUB();
    }

    protected void filterFromBox(int i) throws ContradictionException {
        ISet s = this.overlappingBoxes.getNeighOf(i);
        int xm = ((IntVar[])this.vars)[i].getLB();
        int xM = ((IntVar[])this.vars)[i].getUB() + ((IntVar[])this.vars)[i + 2 * this.n].getUB();
        int ym = ((IntVar[])this.vars)[i + this.n].getLB();
        int yM = ((IntVar[])this.vars)[i + this.n].getUB() + ((IntVar[])this.vars)[i + 3 * this.n].getUB();
        int am = ((IntVar[])this.vars)[i + 2 * this.n].getLB() * ((IntVar[])this.vars)[i + 3 * this.n].getLB();
        int j = s.getFirstElement();
        while (j >= 0) {
            xm = Math.min(xm, ((IntVar[])this.vars)[j].getLB());
            xM = Math.max(xM, ((IntVar[])this.vars)[j].getUB() + ((IntVar[])this.vars)[j + 2 * this.n].getUB());
            ym = Math.min(ym, ((IntVar[])this.vars)[j + this.n].getLB());
            yM = Math.max(yM, ((IntVar[])this.vars)[j + this.n].getUB() + ((IntVar[])this.vars)[j + 3 * this.n].getUB());
            if ((am += ((IntVar[])this.vars)[j + 2 * this.n].getLB() * ((IntVar[])this.vars)[j + 3 * this.n].getLB()) > (xM - xm) * (yM - ym)) {
                this.contradiction(((IntVar[])this.vars)[i], "");
            }
            j = s.getNextElement();
        }
        boolean horizontal = true;
        boolean vertical = false;
        int j2 = s.getFirstElement();
        while (j2 >= 0) {
            if (this.doOverlap(i, j2, horizontal)) {
                this.filter(i, j2, vertical);
            }
            if (this.doOverlap(i, j2, vertical)) {
                this.filter(i, j2, horizontal);
            }
            assert (!this.doOverlap(i, j2, horizontal) || !this.doOverlap(i, j2, vertical));
            j2 = s.getNextElement();
        }
    }

    private boolean doOverlap(int i, int j, boolean hori) {
        int offSet = hori ? 0 : this.n;
        int S_i = ((IntVar[])this.vars)[i + offSet].getUB();
        int e_i = ((IntVar[])this.vars)[i + offSet].getLB() + ((IntVar[])this.vars)[i + 2 * this.n + offSet].getLB();
        int S_j = ((IntVar[])this.vars)[j + offSet].getUB();
        int e_j = ((IntVar[])this.vars)[j + offSet].getLB() + ((IntVar[])this.vars)[j + 2 * this.n + offSet].getLB();
        return S_i < e_i && e_j > S_i && S_j < e_i || S_j < e_j && e_i > S_j && S_i < e_j;
    }

    private void filter(int i, int j, boolean hori) throws ContradictionException {
        int offSet = hori ? 0 : this.n;
        int S_i = ((IntVar[])this.vars)[i + offSet].getUB();
        int e_i = ((IntVar[])this.vars)[i + offSet].getLB() + ((IntVar[])this.vars)[i + 2 * this.n + offSet].getLB();
        int S_j = ((IntVar[])this.vars)[j + offSet].getUB();
        int e_j = ((IntVar[])this.vars)[j + offSet].getLB() + ((IntVar[])this.vars)[j + 2 * this.n + offSet].getLB();
        if (S_i < e_i || S_j < e_j) {
            if (e_j > S_i) {
                ((IntVar[])this.vars)[j + offSet].updateLowerBound(e_i, this.aCause);
                ((IntVar[])this.vars)[i + offSet].updateUpperBound(S_j - ((IntVar[])this.vars)[i + 2 * this.n + offSet].getLB(), this.aCause);
                ((IntVar[])this.vars)[i + offSet + 2 * this.n].updateUpperBound(S_j - ((IntVar[])this.vars)[i + offSet].getLB(), this.aCause);
            }
            if (S_j < e_i) {
                ((IntVar[])this.vars)[i + offSet].updateLowerBound(e_j, this.aCause);
                ((IntVar[])this.vars)[j + offSet].updateUpperBound(S_i - ((IntVar[])this.vars)[j + 2 * this.n + offSet].getLB(), this.aCause);
                ((IntVar[])this.vars)[j + offSet + 2 * this.n].updateUpperBound(S_i - ((IntVar[])this.vars)[j + offSet].getLB(), this.aCause);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        for (int i = 0; i < this.n; ++i) {
            if (!this.boxInstantiated(i)) continue;
            for (int j = i + 1; j < this.n; ++j) {
                if (!this.boxInstantiated(j) || !this.mayOverlap(i, j)) continue;
                return ESat.FALSE;
            }
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    private boolean boxInstantiated(int i) {
        return ((IntVar[])this.vars)[i].isInstantiated() && ((IntVar[])this.vars)[i + this.n].isInstantiated() && ((IntVar[])this.vars)[i + 2 * this.n].isInstantiated() && ((IntVar[])this.vars)[i + 3 * this.n].isInstantiated();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("DIFFN(");
        sb.append("");
        for (int i = 0; i < this.n; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("[").append(((IntVar[])this.vars)[i].toString());
            sb.append(",").append(((IntVar[])this.vars)[i + this.n].toString());
            sb.append(",").append(((IntVar[])this.vars)[i + 2 * this.n].toString());
            sb.append(",").append(((IntVar[])this.vars)[i + 3 * this.n].toString()).append("]");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = this.n;
            IntVar[] X = new IntVar[size];
            IntVar[] Y = new IntVar[size];
            IntVar[] dX = new IntVar[size];
            IntVar[] dY = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                X[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
                ((IntVar[])this.vars)[i + this.n].duplicate(solver, identitymap);
                Y[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i + this.n]);
                ((IntVar[])this.vars)[i + 2 * this.n].duplicate(solver, identitymap);
                dX[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i + 2 * this.n]);
                ((IntVar[])this.vars)[i + 3 * this.n].duplicate(solver, identitymap);
                dY[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i + 3 * this.n]);
            }
            identitymap.put(this, new PropDiffN(X, Y, dX, dY, this.fast));
        }
    }
}

