/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.tools.ArrayUtils;

public class PropKLoops
extends Propagator<IntVar> {
    private int n;
    private int offSet;
    private ISet possibleLoops;
    private IStateInt nbMinLoops;

    public PropKLoops(IntVar[] succs, int offSet, IntVar nbLoops) {
        super((Variable[])ArrayUtils.append(succs, {nbLoops}), PropagatorPriority.UNARY, true);
        this.n = succs.length;
        this.offSet = offSet;
        IEnvironment environment = this.solver.getEnvironment();
        this.possibleLoops = SetFactory.makeStoredSet(SetType.BIPARTITESET, this.n, this.solver);
        this.nbMinLoops = environment.makeInt();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.possibleLoops.clear();
        this.nbMinLoops.set(0);
        for (int i = 0; i < this.n; ++i) {
            if (!((IntVar[])this.vars)[i].contains(i + this.offSet)) continue;
            if (((IntVar[])this.vars)[i].isInstantiated()) {
                this.nbMinLoops.add(1);
                continue;
            }
            this.possibleLoops.add(i);
        }
        this.filter();
    }

    private void filter() throws ContradictionException {
        int nbMin = this.nbMinLoops.get();
        int nbMax = nbMin + this.possibleLoops.getSize();
        ((IntVar[])this.vars)[this.n].updateLowerBound(nbMin, this.aCause);
        ((IntVar[])this.vars)[this.n].updateUpperBound(nbMax, this.aCause);
        if (((IntVar[])this.vars)[this.n].isInstantiated() && nbMin != nbMax) {
            if (((IntVar[])this.vars)[this.n].getValue() == nbMax) {
                int i = this.possibleLoops.getFirstElement();
                while (i >= 0) {
                    ((IntVar[])this.vars)[i].instantiateTo(i + this.offSet, this.aCause);
                    assert (((IntVar[])this.vars)[i].isInstantiatedTo(i + this.offSet));
                    this.nbMinLoops.add(1);
                    i = this.possibleLoops.getNextElement();
                }
                this.possibleLoops.clear();
                this.setPassive();
            } else if (((IntVar[])this.vars)[this.n].getValue() == nbMin) {
                int i = this.possibleLoops.getFirstElement();
                while (i >= 0) {
                    if (((IntVar[])this.vars)[i].removeValue(i + this.offSet, this.aCause)) {
                        this.possibleLoops.remove(i);
                    }
                    i = this.possibleLoops.getNextElement();
                }
                if (this.possibleLoops.isEmpty()) {
                    this.setPassive();
                }
            }
        }
    }

    @Override
    public void propagate(int idV, int mask) throws ContradictionException {
        if (idV < this.n && this.possibleLoops.contain(idV)) {
            if (((IntVar[])this.vars)[idV].contains(idV + this.offSet)) {
                if (((IntVar[])this.vars)[idV].isInstantiated()) {
                    this.nbMinLoops.add(1);
                    this.possibleLoops.remove(idV);
                }
            } else {
                this.possibleLoops.remove(idV);
            }
        }
        this.filter();
    }

    @Override
    public ESat isEntailed() {
        int nbMax = 0;
        int nbMin = 0;
        for (int i = 0; i < this.n; ++i) {
            if (!((IntVar[])this.vars)[i].contains(i + this.offSet)) continue;
            ++nbMax;
            if (!((IntVar[])this.vars)[i].isInstantiated()) continue;
            ++nbMin;
        }
        if (((IntVar[])this.vars)[this.n].getLB() > nbMax || ((IntVar[])this.vars)[this.n].getUB() < nbMin) {
            return ESat.FALSE;
        }
        if (nbMin == nbMax && ((IntVar[])this.vars)[this.n].isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length - 1;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            ((IntVar[])this.vars)[size].duplicate(solver, identitymap);
            IntVar aVar = (IntVar)identitymap.get(((IntVar[])this.vars)[size]);
            identitymap.put(this, new PropKLoops(aVars, this.offSet, aVar));
        }
    }
}

