/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary;

import gnu.trove.map.hash.THashMap;
import java.util.BitSet;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropKnapsack
extends Propagator<IntVar> {
    private int[] weigth;
    private int[] energy;
    private int[] order;
    private double[] ratio;
    private int n;
    private IntVar capacity;
    private IntVar power;

    public PropKnapsack(IntVar[] itemOccurence, IntVar capacity, IntVar power, int[] weight, int[] energy) {
        super((Variable[])ArrayUtils.append(itemOccurence, {capacity, power}), PropagatorPriority.LINEAR, true);
        this.weigth = weight;
        this.energy = energy;
        this.n = itemOccurence.length;
        this.capacity = ((IntVar[])this.vars)[this.n];
        this.power = ((IntVar[])this.vars)[this.n + 1];
        this.order = new int[this.n];
        this.ratio = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.ratio[i] = (double)energy[i] / (double)weight[i];
        }
        BitSet in = new BitSet(this.n);
        double best = -1.0;
        int index = 0;
        for (int i = 0; i < this.n; ++i) {
            int item = -1;
            int o = in.nextClearBit(0);
            while (o < this.n) {
                if (item == -1 || this.ratio[o] > best) {
                    best = this.ratio[o];
                    item = o;
                }
                o = in.nextClearBit(o + 1);
            }
            in.set(item);
            if (item == -1) {
                throw new UnsupportedOperationException();
            }
            this.order[index++] = item;
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        double camax = this.capacity.getUB();
        double pomin = 0.0;
        for (int i = 0; i < this.n; ++i) {
            camax -= (double)(this.weigth[i] * ((IntVar[])this.vars)[i].getLB());
            pomin += (double)(this.energy[i] * ((IntVar[])this.vars)[i].getLB());
        }
        this.power.updateLowerBound((int)pomin, this.aCause);
        if (camax == 0.0) {
            this.power.updateUpperBound((int)pomin, this.aCause);
        } else if (camax < 0.0) {
            this.contradiction(this.capacity, "");
        } else {
            for (int i = 0; i < this.n; ++i) {
                if (camax < 0.0) {
                    throw new UnsupportedOperationException(camax + " < 0");
                }
                int idx = this.order[i];
                int delta = this.weigth[idx] * (((IntVar[])this.vars)[idx].getUB() - ((IntVar[])this.vars)[idx].getLB());
                if (delta <= 0) continue;
                if ((double)delta <= camax) {
                    pomin += (double)(this.energy[idx] * (((IntVar[])this.vars)[idx].getUB() - ((IntVar[])this.vars)[idx].getLB()));
                    if ((camax -= (double)delta) != 0.0) continue;
                    this.power.updateUpperBound((int)pomin, this.aCause);
                    return;
                }
                this.power.updateUpperBound((int)(pomin += Math.ceil(camax * this.ratio[idx])), this.aCause);
                return;
            }
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
    }

    @Override
    public ESat isEntailed() {
        double camax = this.capacity.getUB();
        double pomin = 0.0;
        for (int i = 0; i < this.n; ++i) {
            camax -= (double)(this.weigth[i] * ((IntVar[])this.vars)[i].getLB());
            pomin += (double)(this.energy[i] * ((IntVar[])this.vars)[i].getLB());
        }
        if (camax < 0.0 || pomin > (double)this.power.getUB()) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated() && pomin == (double)this.power.getValue()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length - 2;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            ((IntVar[])this.vars)[size].duplicate(solver, identitymap);
            IntVar C = (IntVar)identitymap.get(((IntVar[])this.vars)[size]);
            ((IntVar[])this.vars)[size + 1].duplicate(solver, identitymap);
            IntVar E = (IntVar)identitymap.get(((IntVar[])this.vars)[size + 1]);
            identitymap.put(this, new PropKnapsack(aVars, C, E, this.weigth, this.energy));
        }
    }
}

