/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferent;

import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.binary.PropNotEqualX_Y;
import org.chocosolver.solver.constraints.nary.alldifferent.PropAllDiffAC;
import org.chocosolver.solver.constraints.nary.alldifferent.PropAllDiffAdaptative;
import org.chocosolver.solver.constraints.nary.alldifferent.PropAllDiffBC;
import org.chocosolver.solver.constraints.nary.alldifferent.PropAllDiffInst;
import org.chocosolver.solver.constraints.nary.cnf.PropTrue;
import org.chocosolver.solver.variables.IntVar;

public class AllDifferent
extends Constraint {
    public AllDifferent(IntVar[] vars, String type) {
        super("AllDifferent", AllDifferent.createPropagators(vars, type));
    }

    private static Propagator[] createPropagators(IntVar[] VARS, String consistency) {
        if (VARS.length <= 1) {
            return new Propagator[]{new PropTrue(VARS[0].getSolver().ONE)};
        }
        switch (Type.valueOf(consistency)) {
            case NEQS: {
                int s = VARS.length;
                int k = 0;
                Propagator[] props = new Propagator[(s * s - s) / 2];
                for (int i = 0; i < s - 1; ++i) {
                    for (int j = i + 1; j < s; ++j) {
                        props[k++] = new PropNotEqualX_Y(VARS[i], VARS[j]);
                    }
                }
                return props;
            }
            case FC: {
                return new Propagator[]{new PropAllDiffInst(VARS)};
            }
            case BC: {
                return new Propagator[]{new PropAllDiffInst(VARS), new PropAllDiffBC(VARS)};
            }
            case AC: {
                return new Propagator[]{new PropAllDiffInst(VARS), new PropAllDiffAC(VARS)};
            }
        }
        boolean enumDom = false;
        for (int i = 0; i < VARS.length && !enumDom; ++i) {
            if (!VARS[i].hasEnumeratedDomain()) continue;
            enumDom = true;
        }
        if (enumDom) {
            return new Propagator[]{new PropAllDiffInst(VARS), new PropAllDiffBC(VARS), new PropAllDiffAdaptative(VARS)};
        }
        return AllDifferent.createPropagators(VARS, "BC");
    }

    public static enum Type {
        AC,
        BC,
        FC,
        NEQS,
        DEFAULT;

    }
}

