/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferent;

import gnu.trove.map.hash.THashMap;
import java.util.Random;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.nary.alldifferent.PropAllDiffAC;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;

public class PropAllDiffAdaptative
extends PropAllDiffAC {
    Random rd = new Random(0L);
    int period = -1;

    public PropAllDiffAdaptative(IntVar[] variables) {
        super(variables);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.period == -1) {
            this.period = 1;
            this.filter.propagate();
        } else {
            this.period = Math.max(this.period, 1);
            if (this.rd.nextInt(this.period) == 0) {
                int domSize = 0;
                for (IntVar v : (IntVar[])this.vars) {
                    domSize += v.getDomainSize();
                }
                try {
                    this.filter.propagate();
                }
                catch (ContradictionException e) {
                    this.period = (this.period + 1) / 2;
                    throw e;
                }
                for (IntVar v : (IntVar[])this.vars) {
                    domSize -= v.getDomainSize();
                }
                this.period = domSize > 0 ? --this.period : ++this.period;
            }
        }
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            IntVar[] aVars = new IntVar[((IntVar[])this.vars).length];
            for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            identitymap.put(this, new PropAllDiffAdaptative(aVars));
        }
    }
}

