/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferent;

import gnu.trove.map.hash.THashMap;
import gnu.trove.stack.array.TIntArrayStack;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropAllDiffInst
extends Propagator<IntVar> {
    protected final int n;
    protected TIntArrayStack toCheck = new TIntArrayStack();

    public PropAllDiffInst(IntVar[] variables) {
        super((Variable[])variables, PropagatorPriority.UNARY, true);
        this.n = ((IntVar[])this.vars).length;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.instantiation();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.toCheck.clear();
        for (int v = 0; v < this.n; ++v) {
            if (!((IntVar[])this.vars)[v].isInstantiated()) continue;
            this.toCheck.push(v);
        }
        this.fixpoint();
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        this.toCheck.push(varIdx);
        this.fixpoint();
    }

    protected void fixpoint() throws ContradictionException {
        try {
            while (this.toCheck.size() > 0) {
                int vidx = this.toCheck.pop();
                int val = ((IntVar[])this.vars)[vidx].getValue();
                for (int i = 0; i < this.n; ++i) {
                    if (i == vidx || !((IntVar[])this.vars)[i].removeValue(val, this.aCause) || !((IntVar[])this.vars)[i].isInstantiated()) continue;
                    this.toCheck.push(i);
                }
            }
        }
        catch (ContradictionException cex) {
            this.toCheck.clear();
            throw cex;
        }
    }

    @Override
    public ESat isEntailed() {
        int nbInst = 0;
        for (int i = 0; i < this.n; ++i) {
            if (!((IntVar[])this.vars)[i].isInstantiated()) continue;
            ++nbInst;
            for (int j = i + 1; j < this.n; ++j) {
                if (!((IntVar[])this.vars)[j].isInstantiatedTo(((IntVar[])this.vars)[i].getValue())) continue;
                return ESat.FALSE;
            }
        }
        if (nbInst == ((IntVar[])this.vars).length) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            IntVar[] aVars = new IntVar[((IntVar[])this.vars).length];
            for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            identitymap.put(this, new PropAllDiffInst(aVars));
        }
    }
}

