/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferent.algo;

import gnu.trove.map.hash.TIntIntHashMap;
import java.util.BitSet;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.graphOperations.connectivity.StrongConnectivityFinder;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class AlgoAllDiffAC {
    protected int n;
    protected int n2;
    protected DirectedGraph digraph;
    private int[] matching;
    private int[] nodeSCC;
    protected BitSet free;
    private StrongConnectivityFinder SCCfinder;
    private int[] father;
    private BitSet in;
    private TIntIntHashMap map;
    int[] fifo;
    IntVar[] vars;
    ICause aCause;

    public AlgoAllDiffAC(IntVar[] variables, ICause cause) {
        this.vars = variables;
        this.aCause = cause;
        this.n = this.vars.length;
        this.matching = new int[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.matching[i] = -1;
        }
        this.map = new TIntIntHashMap();
        int idx = this.n;
        for (int i = 0; i < this.n; ++i) {
            IntVar v = this.vars[i];
            int ub = v.getUB();
            int j = v.getLB();
            while (j <= ub) {
                if (!this.map.containsKey(j)) {
                    this.map.put(j, idx);
                    ++idx;
                }
                j = v.nextValue(j);
            }
        }
        this.n2 = idx;
        this.fifo = new int[this.n2];
        this.digraph = new DirectedGraph(this.n2 + 1, SetType.BITSET, false);
        this.free = new BitSet(this.n2);
        this.father = new int[this.n2];
        this.in = new BitSet(this.n2);
        this.SCCfinder = new StrongConnectivityFinder(this.digraph);
    }

    public void propagate() throws ContradictionException {
        this.findMaximumMatching();
        this.filter();
    }

    protected void findMaximumMatching() throws ContradictionException {
        int i;
        for (int i2 = 0; i2 < this.n2; ++i2) {
            this.digraph.getSuccOf(i2).clear();
            this.digraph.getPredOf(i2).clear();
        }
        this.free.set(0, this.n2);
        for (i = 0; i < this.n; ++i) {
            IntVar v = this.vars[i];
            int ub = v.getUB();
            int mate = this.matching[i];
            int k = v.getLB();
            while (k <= ub) {
                int j = this.map.get(k);
                if (mate == j) {
                    assert (this.free.get(i) && this.free.get(j));
                    this.digraph.addArc(j, i);
                    this.free.clear(i);
                    this.free.clear(j);
                } else {
                    this.digraph.addArc(i, j);
                }
                k = v.nextValue(k);
            }
        }
        i = this.free.nextSetBit(0);
        while (i >= 0 && i < this.n) {
            this.tryToMatch(i);
            i = this.free.nextSetBit(i + 1);
        }
        for (int i3 = 0; i3 < this.n; ++i3) {
            int p;
            this.matching[i3] = p = this.digraph.getPredOf(i3).getFirstElement();
        }
    }

    private void tryToMatch(int i) throws ContradictionException {
        int mate = this.augmentPath_BFS(i);
        if (mate != -1) {
            this.free.clear(mate);
            this.free.clear(i);
            int tmp = mate;
            while (tmp != i) {
                this.digraph.removeArc(this.father[tmp], tmp);
                this.digraph.addArc(tmp, this.father[tmp]);
                tmp = this.father[tmp];
            }
        } else {
            this.vars[0].instantiateTo(this.vars[0].getLB() - 1, this.aCause);
        }
    }

    private int augmentPath_BFS(int root) {
        this.in.clear();
        int indexFirst = 0;
        int indexLast = 0;
        this.fifo[indexLast++] = root;
        while (indexFirst != indexLast) {
            int x = this.fifo[indexFirst++];
            ISet succs = this.digraph.getSuccOf(x);
            int y = succs.getFirstElement();
            while (y >= 0) {
                if (!this.in.get(y)) {
                    this.father[y] = x;
                    this.fifo[indexLast++] = y;
                    this.in.set(y);
                    if (this.free.get(y)) {
                        return y;
                    }
                }
                y = succs.getNextElement();
            }
        }
        return -1;
    }

    private void buildSCC() {
        if (this.n2 > this.n * 2) {
            this.digraph.removeNode(this.n2);
            this.digraph.addNode(this.n2);
            for (int i = this.n; i < this.n2; ++i) {
                if (this.free.get(i)) {
                    this.digraph.addArc(i, this.n2);
                    continue;
                }
                this.digraph.addArc(this.n2, i);
            }
        }
        this.SCCfinder.findAllSCC();
        this.nodeSCC = this.SCCfinder.getNodesSCC();
        this.digraph.removeNode(this.n2);
    }

    protected void filter() throws ContradictionException {
        int j;
        int k;
        int ub;
        IntVar v;
        int i;
        this.buildSCC();
        for (i = 0; i < this.n; ++i) {
            v = this.vars[i];
            ub = v.getUB();
            k = v.getLB();
            while (k <= ub) {
                j = this.map.get(k);
                if (this.nodeSCC[i] != this.nodeSCC[j]) {
                    if (this.matching[i] == j) {
                        v.instantiateTo(k, this.aCause);
                    } else {
                        v.removeValue(k, this.aCause);
                        this.digraph.removeArc(i, j);
                    }
                }
                k = v.nextValue(k);
            }
        }
        for (i = 0; i < this.n; ++i) {
            v = this.vars[i];
            if (v.hasEnumeratedDomain()) continue;
            ub = v.getUB();
            for (k = v.getLB(); k <= ub; ++k) {
                j = this.map.get(k);
                if (this.digraph.arcExists(i, j) || this.digraph.arcExists(j, i)) continue;
                v.removeValue(k, this.aCause);
            }
            int lb = v.getLB();
            for (int k2 = v.getUB(); k2 >= lb; --k2) {
                j = this.map.get(k2);
                if (this.digraph.arcExists(i, j) || this.digraph.arcExists(j, i)) continue;
                v.removeValue(k2, this.aCause);
            }
        }
    }
}

