/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferent.conditions;

import org.chocosolver.solver.constraints.nary.alldifferent.PropAllDiffInst;
import org.chocosolver.solver.constraints.nary.alldifferent.conditions.Condition;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.ESat;

public class PropCondAllDiffInst
extends PropAllDiffInst {
    protected Condition condition;

    public PropCondAllDiffInst(IntVar[] variables, Condition c) {
        super(variables);
        this.condition = c;
    }

    @Override
    public String toString() {
        int i;
        StringBuilder st = new StringBuilder();
        st.append("PropCondAllDiffInst(");
        for (i = 0; i < Math.min(4, this.n); ++i) {
            st.append(((IntVar[])this.vars)[i].getName()).append(", ");
        }
        if (i < this.n - 2) {
            st.append("...,");
        }
        st.append(((IntVar[])this.vars)[this.n - 1].getName()).append(")");
        st.append(this.condition);
        return st.toString();
    }

    @Override
    protected void fixpoint() throws ContradictionException {
        try {
            while (this.toCheck.size() > 0) {
                int vidx = this.toCheck.pop();
                if (!this.condition.holdOnVar(((IntVar[])this.vars)[vidx])) continue;
                int val = ((IntVar[])this.vars)[vidx].getValue();
                for (int i = 0; i < this.n; ++i) {
                    if (i == vidx || !((IntVar[])this.vars)[i].removeValue(val, this.aCause) || !((IntVar[])this.vars)[i].isInstantiated()) continue;
                    this.toCheck.push(i);
                }
            }
        }
        catch (ContradictionException cex) {
            this.toCheck.clear();
            throw cex;
        }
    }

    @Override
    public ESat isEntailed() {
        int nbInst = 0;
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            if (!((IntVar[])this.vars)[i].isInstantiated()) continue;
            ++nbInst;
            if (!this.condition.holdOnVar(((IntVar[])this.vars)[i])) continue;
            for (int j = i + 1; j < ((IntVar[])this.vars).length; ++j) {
                if (!this.condition.holdOnVar(((IntVar[])this.vars)[j]) || !((IntVar[])this.vars)[j].isInstantiated() || ((IntVar[])this.vars)[i].getValue() != ((IntVar[])this.vars)[j].getValue()) continue;
                return ESat.FALSE;
            }
        }
        if (nbInst == ((IntVar[])this.vars).length) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

