/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferent.conditions;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.alldifferent.algo.AlgoAllDiffAC;
import org.chocosolver.solver.constraints.nary.alldifferent.conditions.Condition;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;

public class PropCondAllDiff_AC
extends Propagator<IntVar> {
    private Condition condition;
    private AlgoAllDiffAC filter;

    public PropCondAllDiff_AC(IntVar[] variables, Condition condition) {
        super((Variable[])variables, PropagatorPriority.QUADRATIC, false);
        this.condition = condition;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int nb = 0;
        for (IntVar v : (IntVar[])this.vars) {
            if (!this.condition.holdOnVar(v)) continue;
            ++nb;
        }
        IntVar[] vs = new IntVar[nb];
        for (IntVar v : (IntVar[])this.vars) {
            if (!this.condition.holdOnVar(v)) continue;
            vs[--nb] = v;
        }
        this.filter = new AlgoAllDiffAC(vs, this.aCause);
        this.filter.propagate();
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
    }

    @Override
    public ESat isEntailed() {
        int nbInst = 0;
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            if (!((IntVar[])this.vars)[i].isInstantiated()) continue;
            ++nbInst;
            if (!this.condition.holdOnVar(((IntVar[])this.vars)[i])) continue;
            for (int j = i + 1; j < ((IntVar[])this.vars).length; ++j) {
                if (!this.condition.holdOnVar(((IntVar[])this.vars)[j]) || !((IntVar[])this.vars)[j].isInstantiated() || ((IntVar[])this.vars)[i].getValue() != ((IntVar[])this.vars)[j].getValue()) continue;
                return ESat.FALSE;
            }
        }
        if (nbInst == ((IntVar[])this.vars).length) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            identitymap.put(this, new PropCondAllDiff_AC(aVars, this.condition));
        }
    }
}

