/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.among;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateBitSet;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.procedure.UnarySafeIntProcedure;

public class PropAmongGAC
extends Propagator<IntVar> {
    private final int[] values;
    private final int nb_vars;
    private final IStateBitSet both;
    private final IStateInt LB;
    private final IStateInt UB;
    private TIntHashSet setValues;
    private IStateInt[] occs;
    protected final IIntDeltaMonitor[] idms;
    protected final RemProc rem_proc;
    protected boolean needFilter;

    public PropAmongGAC(IntVar[] variables, int[] values) {
        super((Variable[])variables, PropagatorPriority.LINEAR, true);
        this.nb_vars = variables.length - 1;
        this.idms = new IIntDeltaMonitor[((IntVar[])this.vars).length];
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            this.idms[i] = ((IntVar[])this.vars)[i].hasEnumeratedDomain() ? ((IntVar[])this.vars)[i].monitorDelta(this) : IIntDeltaMonitor.Default.NONE;
        }
        IEnvironment environment = this.solver.getEnvironment();
        this.both = environment.makeBitSet(this.nb_vars);
        this.LB = environment.makeInt(0);
        this.UB = environment.makeInt(0);
        this.setValues = new TIntHashSet(values);
        this.values = this.setValues.toArray();
        Arrays.sort(this.values);
        this.occs = new IStateInt[this.nb_vars];
        for (int i = 0; i < this.nb_vars; ++i) {
            this.occs[i] = environment.makeInt(0);
        }
        this.rem_proc = new RemProc(this);
    }

    @Override
    public int getPropagationConditions(int idx) {
        if (idx == this.nb_vars) {
            return IntEventType.boundAndInst();
        }
        return IntEventType.all();
    }

    @Override
    public boolean advise(int varIdx, int mask) {
        if (super.advise(varIdx, mask)) {
            if (varIdx == this.nb_vars) {
                return true;
            }
            this.needFilter = false;
            if (IntEventType.isInstantiate(mask)) {
                if (this.both.get(varIdx)) {
                    IntVar var = ((IntVar[])this.vars)[varIdx];
                    int val = var.getValue();
                    if (this.setValues.contains(val)) {
                        this.LB.add(1);
                        this.both.set(varIdx, false);
                        this.needFilter = true;
                    } else {
                        this.UB.add(-1);
                        this.both.set(varIdx, false);
                        this.needFilter = true;
                    }
                }
            } else {
                this.idms[varIdx].freeze();
                this.idms[varIdx].forEachRemVal(this.rem_proc.set(varIdx));
                this.idms[varIdx].unfreeze();
            }
            return this.needFilter;
        }
        return false;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            int i;
            int lb = 0;
            int ub = this.nb_vars;
            for (i = 0; i < this.nb_vars; ++i) {
                IntVar var = ((IntVar[])this.vars)[i];
                int nb = 0;
                for (int j = 0; j < this.values.length; ++j) {
                    nb += var.contains(this.values[j]) ? 1 : 0;
                }
                this.occs[i].set(nb);
                if (nb == var.getDomainSize()) {
                    ++lb;
                    continue;
                }
                if (nb == 0) {
                    --ub;
                    continue;
                }
                if (nb <= 0) continue;
                this.both.set(i, true);
            }
            this.LB.set(lb);
            this.UB.set(ub);
            for (i = 0; i < this.idms.length; ++i) {
                this.idms[i].unfreeze();
            }
        }
        this.filter();
    }

    protected void filter() throws ContradictionException {
        int lb = this.LB.get();
        int ub = this.UB.get();
        ((IntVar[])this.vars)[this.nb_vars].updateLowerBound(lb, this.aCause);
        ((IntVar[])this.vars)[this.nb_vars].updateUpperBound(ub, this.aCause);
        int min = Math.max(((IntVar[])this.vars)[this.nb_vars].getLB(), lb);
        int max = Math.min(((IntVar[])this.vars)[this.nb_vars].getUB(), ub);
        if (max < min) {
            this.contradiction(null, "impossible");
        }
        if (lb == min && lb == max) {
            this.removeOnlyValues();
        }
        if (ub == min && ub == max) {
            this.removeButValues();
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        this.filter();
    }

    private void removeOnlyValues() throws ContradictionException {
        int i = this.both.nextSetBit(0);
        while (i >= 0) {
            IntVar v = ((IntVar[])this.vars)[i];
            if (v.hasEnumeratedDomain()) {
                for (int value : this.values) {
                    if (!v.removeValue(value, this.aCause)) continue;
                    this.occs[i].add(-1);
                }
            } else {
                int k1;
                int lb = v.getLB();
                int ub = v.getUB();
                int k2 = this.values.length - 1;
                for (k1 = 0; k1 < k2 && this.values[k1] < lb; ++k1) {
                }
                while (k1 <= k2 && v.removeValue(this.values[k1], this.aCause)) {
                    this.occs[i].add(-1);
                    ++k1;
                }
                while (k2 > k1 && this.values[k2] > ub) {
                    --k2;
                }
                while (k2 >= k1 && v.removeValue(this.values[k2], this.aCause)) {
                    this.occs[i].add(-1);
                    --k2;
                }
            }
            i = this.both.nextSetBit(i + 1);
        }
    }

    private void removeButValues() throws ContradictionException {
        int i = this.both.nextSetBit(0);
        while (i >= 0) {
            IntVar v = ((IntVar[])this.vars)[i];
            DisposableValueIterator it = v.getValueIterator(true);
            int right = Integer.MIN_VALUE;
            int left = Integer.MIN_VALUE;
            while (it.hasNext()) {
                int value = it.next();
                if (this.setValues.contains(value)) continue;
                if (value == right + 1) {
                    right = value;
                    continue;
                }
                v.removeInterval(left, right, this.aCause);
                left = right = value;
            }
            v.removeInterval(left, right, this.aCause);
            it.dispose();
            i = this.both.nextSetBit(i + 1);
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            int nb = 0;
            for (int i = 0; i < this.nb_vars; ++i) {
                if (!this.setValues.contains(((IntVar[])this.vars)[i].getValue())) continue;
                ++nb;
            }
            return ESat.eval(((IntVar[])this.vars)[this.nb_vars].getValue() == nb);
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("AMONG(");
        sb.append("[");
        for (int i = 0; i < this.nb_vars; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(((IntVar[])this.vars)[i].toString());
        }
        sb.append("],{");
        sb.append(Arrays.toString(this.values));
        sb.append("},");
        sb.append(((IntVar[])this.vars)[this.nb_vars].toString()).append(")");
        return sb.toString();
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length;
            IntVar[] aVars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            identitymap.put(this, new PropAmongGAC(aVars, this.values));
        }
    }

    protected static class RemProc
    implements UnarySafeIntProcedure<Integer> {
        final PropAmongGAC p;
        int varIdx;

        public RemProc(PropAmongGAC p) {
            this.p = p;
        }

        @Override
        public UnarySafeIntProcedure set(Integer integer) {
            this.varIdx = integer;
            return this;
        }

        @Override
        public void execute(int val) {
            if (this.p.both.get(this.varIdx)) {
                if (this.p.setValues.contains(val)) {
                    this.p.occs[this.varIdx].add(-1);
                }
                IntVar var = ((IntVar[])this.p.vars)[this.varIdx];
                int nb = this.p.occs[this.varIdx].get();
                if (nb == var.getDomainSize()) {
                    this.p.LB.add(1);
                    this.p.both.set(this.varIdx, false);
                    this.p.needFilter = true;
                } else if (nb == 0) {
                    this.p.UB.add(-1);
                    this.p.both.set(this.varIdx, false);
                    this.p.needFilter = true;
                }
            }
        }
    }
}

