/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.automata.FA;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.State;
import dk.brics.automaton.StatePair;
import dk.brics.automaton.Transition;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.chocosolver.solver.constraints.nary.automata.FA.IAutomaton;
import org.chocosolver.util.tools.StringUtils;

public class FiniteAutomaton
implements IAutomaton {
    protected static final TIntIntHashMap charFromIntMap = new TIntIntHashMap();
    protected static final TIntIntHashMap intFromCharMap = new TIntIntHashMap();
    protected Automaton representedBy;
    protected TObjectIntHashMap<State> stateToIndex;
    protected ArrayList<State> states;
    protected TIntHashSet alphabet;
    protected int nbStates;
    private HashSet<State> nexts = new HashSet();
    private TIntHashSet tmpSet = new TIntHashSet();

    public static int getIntFromChar(char c) {
        return intFromCharMap.get(c);
    }

    public static char getCharFromInt(int i) {
        return (char)charFromIntMap.get(i);
    }

    public FiniteAutomaton() {
        this.representedBy = new Automaton();
        this.stateToIndex = new TObjectIntHashMap();
        this.states = new ArrayList();
        this.alphabet = new TIntHashSet();
    }

    public FiniteAutomaton(String regexp) {
        this();
        String correct = StringUtils.toCharExp(regexp);
        this.representedBy = new RegExp(correct).toAutomaton();
        for (State s : this.representedBy.getStates()) {
            for (Transition t : s.getTransitions()) {
                for (char c = t.getMin(); c <= t.getMax(); c = (char)(c + '\u0001')) {
                    this.alphabet.add(FiniteAutomaton.getIntFromChar(c));
                }
            }
        }
        this.syncStates();
    }

    public FiniteAutomaton(FiniteAutomaton other) {
        this.perfectCopy(other);
    }

    private void perfectCopy(FiniteAutomaton other) {
        this.representedBy = new Automaton();
        this.states = new ArrayList();
        this.stateToIndex = new TObjectIntHashMap();
        this.alphabet = new TIntHashSet();
        this.nbStates = other.nbStates;
        for (int i = 0; i < other.nbStates; ++i) {
            State s = new State();
            this.states.add(s);
            this.stateToIndex.put(s, i);
            if (other.isFinal(i)) {
                s.setAccept(true);
            }
            if (other.getInitialState() != i) continue;
            this.representedBy.setInitialState(s);
        }
        List<int[]> transitions = other.getTransitions();
        for (int[] t : transitions) {
            this.addTransition(t[0], t[1], t[2]);
        }
    }

    private FiniteAutomaton(Automaton a, TIntHashSet alphabet) {
        this();
        this.fill(a, alphabet);
    }

    public static int max(TIntHashSet hs) {
        int max = Integer.MIN_VALUE;
        TIntIterator it = hs.iterator();
        while (it.hasNext()) {
            int n = it.next();
            if (n <= max) continue;
            max = n;
        }
        return max;
    }

    private static int min(TIntHashSet hs) {
        int min = Integer.MAX_VALUE;
        TIntIterator it = hs.iterator();
        while (it.hasNext()) {
            int n = it.next();
            if (n >= min) continue;
            min = n;
        }
        return min;
    }

    public void fill(Automaton a, TIntHashSet alphabet) {
        int max = FiniteAutomaton.max(alphabet);
        int min = FiniteAutomaton.min(alphabet);
        this.setDeterministic(a.isDeterministic());
        HashMap<State, State> m = new HashMap<State, State>();
        Set<State> states = a.getStates();
        for (State s : states) {
            this.addState();
            State ns = this.states.get(this.states.size() - 1);
            m.put(s, ns);
        }
        for (State s : states) {
            State p = (State)m.get(s);
            int source = this.stateToIndex.get(p);
            p.setAccept(s.isAccept());
            if (a.getInitialState().equals(s)) {
                this.representedBy.setInitialState(p);
            }
            for (Transition t : s.getTransitions()) {
                int tmin = FiniteAutomaton.getIntFromChar(t.getMin());
                int tmax = FiniteAutomaton.getIntFromChar(t.getMax());
                State dest = (State)m.get(t.getDest());
                int desti = this.stateToIndex.get(dest);
                int minmax = Math.min(max, tmax);
                for (int i = Math.max(min, tmin); i <= minmax; ++i) {
                    if (!alphabet.contains(i)) continue;
                    this.addTransition(source, desti, i);
                }
            }
        }
    }

    @Override
    public int getNbStates() {
        return this.nbStates;
    }

    public int getNbSymbols() {
        return this.alphabet.size();
    }

    public int addState() {
        int idx = this.states.size();
        State s = new State();
        this.states.add(s);
        this.stateToIndex.put(s, idx);
        ++this.nbStates;
        return idx;
    }

    public void removeSymbolFromAutomaton(int symbol) {
        char c = FiniteAutomaton.getCharFromInt(symbol);
        ArrayList<IAutomaton.Triple> triples = new ArrayList<IAutomaton.Triple>();
        for (int i = 0; i < this.states.size(); ++i) {
            State s = this.states.get(i);
            for (Transition transition : s.getTransitions()) {
                if (transition.getMin() > c || transition.getMax() < c) continue;
                triples.add(new IAutomaton.Triple(i, this.stateToIndex.get(transition.getDest()), symbol));
            }
            for (IAutomaton.Triple triple : triples) {
                this.deleteTransition(triple.a, triple.b, triple.c);
            }
            triples.clear();
        }
        this.alphabet.remove(symbol);
    }

    public void addTransition(int source, int destination, int ... symbols) {
        for (int symbol : symbols) {
            try {
                this.checkState(source, destination);
            }
            catch (IAutomaton.StateNotInAutomatonException e) {
                // empty catch block
            }
            this.alphabet.add(symbol);
            State s = this.states.get(source);
            State d = this.states.get(destination);
            s.addTransition(new Transition(FiniteAutomaton.getCharFromInt(symbol), d));
        }
    }

    public void deleteTransition(int source, int destination, int symbol) {
        try {
            this.checkState(source, destination);
        }
        catch (IAutomaton.StateNotInAutomatonException e) {
            // empty catch block
        }
        State s = this.states.get(source);
        State d = this.states.get(destination);
        Set<Transition> transitions = s.getTransitions();
        HashSet<Transition> nTrans = new HashSet<Transition>();
        char c = FiniteAutomaton.getCharFromInt(symbol);
        Iterator<Transition> it = transitions.iterator();
        while (it.hasNext()) {
            Transition t = it.next();
            if (!t.getDest().equals(d) || t.getMin() > c || t.getMax() < c) continue;
            it.remove();
            if (t.getMin() == c && c < t.getMax()) {
                nTrans.add(new Transition((char)(c + '\u0001'), t.getMax(), d));
                continue;
            }
            if (t.getMin() > c && c == t.getMax()) {
                nTrans.add(new Transition(t.getMin(), (char)(c - '\u0001'), d));
                continue;
            }
            if (t.getMin() >= c || c >= t.getMax()) continue;
            nTrans.add(new Transition(t.getMin(), (char)(c - '\u0001'), d));
            nTrans.add(new Transition((char)(c + '\u0001'), t.getMax(), d));
        }
        transitions.addAll(nTrans);
    }

    private void checkState(int ... state) throws IAutomaton.StateNotInAutomatonException {
        int sz = this.states.size();
        for (int s : state) {
            if (s < sz) continue;
            throw new IAutomaton.StateNotInAutomatonException(s);
        }
    }

    @Override
    public int delta(int source, int symbol) throws IAutomaton.NonDeterministicOperationException {
        if (!this.representedBy.isDeterministic()) {
            throw new IAutomaton.NonDeterministicOperationException();
        }
        try {
            this.checkState(source);
        }
        catch (IAutomaton.StateNotInAutomatonException e) {
            // empty catch block
        }
        State s = this.states.get(source);
        State d = s.step(FiniteAutomaton.getCharFromInt(symbol));
        if (d != null) {
            return this.stateToIndex.get(d);
        }
        return -1;
    }

    @Override
    public void delta(int source, int symbol, TIntHashSet states) {
        try {
            this.checkState(source);
        }
        catch (IAutomaton.StateNotInAutomatonException e) {
            // empty catch block
        }
        State s = this.states.get(source);
        this.nexts.clear();
        s.step(FiniteAutomaton.getCharFromInt(symbol), this.nexts);
        for (State to : this.nexts) {
            states.add(this.stateToIndex.get(to));
        }
    }

    public TIntArrayList getOutSymbols(int source) {
        try {
            this.checkState(source);
        }
        catch (IAutomaton.StateNotInAutomatonException e) {
            // empty catch block
        }
        TIntHashSet set = new TIntHashSet();
        State s = this.states.get(source);
        for (Transition t : s.getTransitions()) {
            for (char c = t.getMin(); c <= t.getMax(); c = (char)(c + '\u0001')) {
                set.add(FiniteAutomaton.getIntFromChar(c));
            }
        }
        return new TIntArrayList(set.toArray());
    }

    public int[] getOutSymbolsArray(int source) {
        try {
            this.checkState(source);
        }
        catch (IAutomaton.StateNotInAutomatonException e) {
            // empty catch block
        }
        this.tmpSet.clear();
        State s = this.states.get(source);
        for (Transition t : s.getTransitions()) {
            for (char c = t.getMin(); c <= t.getMax(); c = (char)(c + '\u0001')) {
                this.tmpSet.add(FiniteAutomaton.getIntFromChar(c));
            }
        }
        return this.tmpSet.toArray();
    }

    public void addToAlphabet(int a) {
        this.alphabet.add(a);
    }

    public void removeFromAlphabet(int a) {
        this.alphabet.remove(a);
    }

    @Override
    public int getInitialState() {
        State s = this.representedBy.getInitialState();
        if (s == null) {
            return -1;
        }
        return this.stateToIndex.get(s);
    }

    @Override
    public boolean isFinal(int state) {
        try {
            this.checkState(state);
        }
        catch (IAutomaton.StateNotInAutomatonException stateNotInAutomatonException) {
            // empty catch block
        }
        return this.states.get(state).isAccept();
    }

    public void setInitialState(int state) {
        try {
            this.checkState(state);
        }
        catch (IAutomaton.StateNotInAutomatonException stateNotInAutomatonException) {
            // empty catch block
        }
        this.representedBy.setInitialState(this.states.get(state));
    }

    public void setFinal(int state) {
        try {
            this.checkState(state);
        }
        catch (IAutomaton.StateNotInAutomatonException stateNotInAutomatonException) {
            // empty catch block
        }
        this.states.get(state).setAccept(true);
    }

    public void setFinal(int ... states) {
        for (int s : states) {
            this.setFinal(s);
        }
    }

    public void setNonFinal(int state) {
        try {
            this.checkState(state);
        }
        catch (IAutomaton.StateNotInAutomatonException stateNotInAutomatonException) {
            // empty catch block
        }
        this.states.get(state).setAccept(false);
    }

    public void setNonFInal(int ... states) {
        for (int s : states) {
            this.setNonFinal(s);
        }
    }

    @Override
    public boolean run(int[] word) {
        StringBuilder b = new StringBuilder();
        for (int i : word) {
            char c = FiniteAutomaton.getCharFromInt(i);
            b.append(c);
        }
        return this.representedBy.run(b.toString());
    }

    public Automaton makeBricsAutomaton() {
        return this.representedBy.clone();
    }

    public IAutomaton repeat() {
        return new FiniteAutomaton(this.representedBy.repeat(), this.alphabet);
    }

    public IAutomaton repeat(int min) {
        return new FiniteAutomaton(this.representedBy.repeat(min), this.alphabet);
    }

    public IAutomaton repeat(int min, int max) {
        return new FiniteAutomaton(this.representedBy.repeat(min, max), this.alphabet);
    }

    public void minimize() {
        this.representedBy.minimize();
        this.syncStates();
    }

    private void syncStates() {
        this.alphabet.clear();
        this.states.clear();
        this.stateToIndex.clear();
        int idx = 0;
        for (State s : this.representedBy.getStates()) {
            this.states.add(s);
            this.stateToIndex.put(s, idx++);
            for (Transition t : s.getTransitions()) {
                for (char c = t.getMin(); c <= t.getMax(); c = (char)(c + '\u0001')) {
                    this.alphabet.add(FiniteAutomaton.getIntFromChar(c));
                }
            }
        }
        this.nbStates = this.states.size();
    }

    public void reduce() {
        this.representedBy.reduce();
        this.syncStates();
    }

    public void removeDeadTransitions() {
        this.representedBy.removeDeadTransitions();
        this.syncStates();
    }

    public FiniteAutomaton union(FiniteAutomaton otherI) {
        Automaton union = this.representedBy.union(otherI.representedBy);
        TIntHashSet alphabet = new TIntHashSet(this.alphabet.toArray());
        alphabet.addAll(otherI.alphabet.toArray());
        return new FiniteAutomaton(union, alphabet);
    }

    public FiniteAutomaton intersection(IAutomaton otherI) {
        FiniteAutomaton other = (FiniteAutomaton)otherI;
        Automaton inter = this.representedBy.intersection(other.representedBy);
        TIntHashSet alphabet = new TIntHashSet();
        for (int a : this.alphabet.toArray()) {
            if (!other.alphabet.contains(a)) continue;
            alphabet.add(a);
        }
        return new FiniteAutomaton(inter, alphabet);
    }

    public FiniteAutomaton complement(TIntHashSet alphabet) {
        Automaton comp = this.representedBy.complement();
        return new FiniteAutomaton(comp, alphabet);
    }

    public FiniteAutomaton complement() {
        return this.complement(this.alphabet);
    }

    public FiniteAutomaton concatenate(FiniteAutomaton otherI) {
        Automaton conc = this.representedBy.concatenate(otherI.representedBy);
        TIntHashSet alphabet = new TIntHashSet(this.alphabet.toArray());
        alphabet.addAll(otherI.alphabet.toArray());
        return new FiniteAutomaton(conc, alphabet);
    }

    public void addEpsilon(int source, int destination) {
        try {
            this.checkState(source, destination);
        }
        catch (IAutomaton.StateNotInAutomatonException e) {
            // empty catch block
        }
        State s = this.states.get(source);
        State d = this.states.get(destination);
        ArrayList<StatePair> pairs = new ArrayList<StatePair>();
        pairs.add(new StatePair(s, d));
        this.representedBy.addEpsilons(pairs);
    }

    public boolean isDeterministic() {
        return this.representedBy.isDeterministic();
    }

    public void setDeterministic(boolean deterministic) {
        this.representedBy.setDeterministic(deterministic);
    }

    public TIntHashSet getFinalStates() {
        TIntHashSet finals = new TIntHashSet();
        for (int i = 0; i < this.states.size(); ++i) {
            if (!this.states.get(i).isAccept()) continue;
            finals.add(i);
        }
        return finals;
    }

    public void toDotty(String f) {
        String s = this.toDot();
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File(f)));
            bw.write(s);
            bw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toDot() {
        StringBuilder b = new StringBuilder("digraph Automaton {\n");
        b.append("  rankdir = LR;\n");
        Set<State> states = this.representedBy.getStates();
        for (State s : states) {
            int idx = this.stateToIndex.get(s);
            b.append("  ").append(idx);
            if (s.isAccept()) {
                b.append(" [shape=doublecircle];\n");
            } else {
                b.append(" [shape=circle];\n");
            }
            if (s == this.representedBy.getInitialState()) {
                b.append("  initial [shape=plaintext,label=\"\"];\n");
                b.append("  initial -> ").append(idx).append("\n");
            }
            for (Transition t : s.getTransitions()) {
                b.append("  ").append(idx);
                this.appendDot(t, b);
            }
        }
        return b.append("}\n").toString();
    }

    private void appendDot(Transition t, StringBuilder b) {
        int destIdx = this.stateToIndex.get(t.getDest());
        b.append(" -> ").append(destIdx).append(" [label=\"");
        b.append("{");
        b.append(FiniteAutomaton.getIntFromChar(t.getMin()));
        if (t.getMin() != t.getMax()) {
            for (char c = (char)(t.getMin() + '\u0001'); c <= t.getMax(); c = (char)(c + '\u0001')) {
                b.append(",");
                b.append(FiniteAutomaton.getIntFromChar(c));
            }
        }
        b.append("}");
        b.append("\"]\n");
    }

    public TIntHashSet getAlphabet() {
        return this.alphabet;
    }

    public List<int[]> getTransitions() {
        ArrayList<int[]> transitions = new ArrayList<int[]>();
        for (int i = 0; i < this.states.size(); ++i) {
            State s = this.states.get(i);
            for (Transition t : s.getTransitions()) {
                int dest = this.stateToIndex.get(t.getDest());
                for (char c = t.getMin(); c <= t.getMax(); c = (char)(c + '\u0001')) {
                    int symbol = FiniteAutomaton.getIntFromChar(c);
                    transitions.add(new int[]{i, dest, symbol});
                }
            }
        }
        return transitions;
    }

    public List<int[]> getTransitions(int state) {
        ArrayList<int[]> transitions = new ArrayList<int[]>();
        for (Transition t : this.states.get(state).getTransitions()) {
            int dest = this.stateToIndex.get(t.getDest());
            for (char c = t.getMin(); c <= t.getMax(); c = (char)(c + '\u0001')) {
                int symbol = FiniteAutomaton.getIntFromChar(c);
                transitions.add(new int[]{state, dest, symbol});
            }
        }
        return transitions;
    }

    public ArrayList<int[]> _removeSymbolFromAutomaton(int alpha) {
        char c = FiniteAutomaton.getCharFromInt(alpha);
        TIntHashSet setOfRemoved = new TIntHashSet();
        ArrayList<IAutomaton.Triple> triples = new ArrayList<IAutomaton.Triple>();
        for (int i = 0; i < this.states.size(); ++i) {
            State s = this.states.get(i);
            for (Transition transition : s.getTransitions()) {
                if (transition.getMin() > c || transition.getMax() < c) continue;
                triples.add(new IAutomaton.Triple(i, this.stateToIndex.get(transition.getDest()), alpha));
                setOfRemoved.add(i);
            }
            for (IAutomaton.Triple triple : triples) {
                this.deleteTransition(triple.a, triple.b, triple.c);
            }
            triples.clear();
        }
        this.alphabet.remove(alpha);
        ArrayList<int[]> couple = new ArrayList<int[]>();
        for (int i = 0; i < this.states.size(); ++i) {
            State s = this.states.get(i);
            for (Transition t : s.getTransitions()) {
                int dest = this.stateToIndex.get(t.getDest());
                if (!setOfRemoved.contains(dest)) continue;
                for (char d = t.getMin(); d <= t.getMax(); d = (char)(d + '\u0001')) {
                    couple.add(new int[]{i, FiniteAutomaton.getIntFromChar(d)});
                }
            }
        }
        return couple;
    }

    @Override
    public FiniteAutomaton clone() throws CloneNotSupportedException {
        FiniteAutomaton auto = (FiniteAutomaton)super.clone();
        auto.representedBy = new Automaton();
        auto.states = new ArrayList();
        auto.stateToIndex = new TObjectIntHashMap();
        auto.alphabet = new TIntHashSet();
        auto.nbStates = this.nbStates;
        for (int i = 0; i < this.nbStates; ++i) {
            State s = new State();
            auto.states.add(s);
            auto.stateToIndex.put(s, i);
            if (this.isFinal(i)) {
                s.setAccept(true);
            }
            if (this.getInitialState() != i) continue;
            auto.representedBy.setInitialState(s);
        }
        List<int[]> transitions = this.getTransitions();
        for (int[] t : transitions) {
            auto.addTransition(t[0], t[1], t[2]);
        }
        return auto;
    }

    public String toString() {
        return this.representedBy.toString();
    }

    static {
        int delta = 0;
        for (int i = 0; i <= 65535; ++i) {
            while ((char)(i + delta) == '\"' || (char)(i + delta) == '{' || (char)(i + delta) == '}' || (char)(i + delta) == '<' || (char)(i + delta) == '>' || (char)(i + delta) == '[' || (char)(i + delta) == ']' || (char)(i + delta) == '(' || (char)(i + delta) == ')') {
                ++delta;
            }
            charFromIntMap.put(i, i + delta);
            intFromCharMap.put(i + delta, i);
        }
    }
}

