/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.automata;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import gnu.trove.stack.TIntStack;
import gnu.trove.stack.array.TIntArrayStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.automata.FA.ICostAutomaton;
import org.chocosolver.solver.constraints.nary.automata.FA.utils.Bounds;
import org.chocosolver.solver.constraints.nary.automata.FA.utils.ICounter;
import org.chocosolver.solver.constraints.nary.automata.structure.Node;
import org.chocosolver.solver.constraints.nary.automata.structure.multicostregular.Arc;
import org.chocosolver.solver.constraints.nary.automata.structure.multicostregular.FastPathFinder;
import org.chocosolver.solver.constraints.nary.automata.structure.multicostregular.StoredDirectedMultiGraph;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.iterators.DisposableIntIterator;
import org.chocosolver.util.objects.StoredIndexedBipartiteSetWithOffset;
import org.chocosolver.util.procedure.UnaryIntProcedure;
import org.chocosolver.util.tools.ArrayUtils;
import org.jgrapht.graph.DirectedMultigraph;

public final class PropMultiCostRegular
extends Propagator<IntVar> {
    public static final int MAXBOUNDITER = 10;
    public static final int MAXNONIMPROVEITER = 15;
    public static final double U0 = 10.0;
    public static final double RO = 0.7;
    public final TObjectIntHashMap<IntVar> map;
    public int[] lastSp;
    public double lastSpValue;
    public int[] lastLp;
    public double lastLpValue;
    protected final IntVar[] vs;
    protected final int offset;
    public final IntVar[] z;
    protected final ICostAutomaton pi;
    protected StoredDirectedMultiGraph graph;
    protected final boolean[] modifiedBound;
    protected final double[] uUb;
    protected final double[] uLb;
    protected FastPathFinder slp;
    protected final int nbR;
    protected final TIntStack toRemove;
    protected final TIntStack[] toUpdateLeft;
    protected final TIntStack[] toUpdateRight;
    protected final TIntHashSet removed = new TIntHashSet();
    public int lastWorld = -1;
    public long lastNbOfBacktracks = -1L;
    public long lastNbOfRestarts = -1L;
    private TIntHashSet boundUpdate;
    private boolean computed;
    protected final IIntDeltaMonitor[] idms;
    protected final RemProc rem_proc;
    public final double _MCR_DECIMAL_PREC = this.solver.getSettings().getMCRDecimalPrecision();

    public PropMultiCostRegular(IntVar[] variables, IntVar[] costvariables, ICostAutomaton cauto) {
        super((Variable[])ArrayUtils.append(variables, costvariables), PropagatorPriority.CUBIC, true);
        int i;
        this.vs = (IntVar[])Arrays.copyOfRange(this.vars, 0, variables.length);
        this.offset = this.vs.length;
        this.z = (IntVar[])Arrays.copyOfRange(this.vars, this.offset, ((IntVar[])this.vars).length);
        this.nbR = this.z.length - 1;
        this.idms = new IIntDeltaMonitor[((IntVar[])this.vars).length];
        for (i = 0; i < ((IntVar[])this.vars).length; ++i) {
            this.idms[i] = ((IntVar[])this.vars)[i].monitorDelta(this);
        }
        this.modifiedBound = new boolean[]{true, true};
        this.uUb = new double[2 * this.nbR];
        this.uLb = new double[2 * this.nbR];
        this.map = new TObjectIntHashMap();
        for (i = 0; i < ((IntVar[])this.vars).length; ++i) {
            this.map.put(((IntVar[])this.vars)[i], i);
        }
        this.toRemove = new TIntArrayStack();
        this.toUpdateLeft = new TIntArrayStack[this.nbR + 1];
        this.toUpdateRight = new TIntArrayStack[this.nbR + 1];
        for (i = 0; i <= this.nbR; ++i) {
            this.toUpdateLeft[i] = new TIntArrayStack();
            this.toUpdateRight[i] = new TIntArrayStack();
        }
        this.boundUpdate = new TIntHashSet();
        this.pi = cauto;
        this.rem_proc = new RemProc(this);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return vIdx < this.vs.length ? IntEventType.all() : IntEventType.boundAndInst();
    }

    protected void initialize() throws ContradictionException {
        this.checkBounds();
        this.initGraph();
        this.slp = this.graph.getPathFinder();
        for (int i = 0; i < this.offset; ++i) {
            int right = Integer.MIN_VALUE;
            int left = Integer.MIN_VALUE;
            int j = this.vs[i].getLB();
            while (j <= this.vs[i].getUB()) {
                StoredIndexedBipartiteSetWithOffset sup = this.graph.getUBport(i, j);
                if (sup == null || sup.isEmpty()) {
                    if (j == right + 1) {
                        right = j;
                    } else {
                        this.vs[i].removeInterval(left, right, this.aCause);
                        left = right = j;
                    }
                }
                j = this.vs[i].nextValue(j);
            }
            this.vs[i].removeInterval(left, right, this.aCause);
        }
        this.slp.computeShortestAndLongestPath(this.toRemove, this.z, this);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            this.initialize();
        }
        this.filter();
        for (int i = 0; i < this.idms.length; ++i) {
            this.idms[i].unfreeze();
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        if (varIdx < this.offset) {
            this.checkWorld();
            this.idms[varIdx].freeze();
            this.idms[varIdx].forEachRemVal(this.rem_proc.set(varIdx));
            this.idms[varIdx].unfreeze();
        } else {
            this.boundUpdate.add(varIdx - this.offset);
            this.computed = false;
        }
        this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
    }

    /*
     * WARNING - void declaration
     */
    private void initGraph() {
        Node o;
        int k;
        TIntIterator layerIter;
        int j;
        int i;
        int aid = 0;
        int nid = 0;
        int[] offsets = new int[this.offset];
        int[] sizes = new int[this.offset];
        int[] starts = new int[this.offset];
        int totalSizes = 0;
        starts[0] = 0;
        for (int i2 = 0; i2 < this.offset; ++i2) {
            offsets[i2] = this.vs[i2].getLB();
            sizes[i2] = this.vs[i2].getUB() - this.vs[i2].getLB() + 1;
            if (i2 > 0) {
                starts[i2] = sizes[i2 - 1] + starts[i2 - 1];
            }
            totalSizes += sizes[i2];
        }
        int n = this.offset;
        DirectedMultigraph<Node, Arc> graph = new DirectedMultigraph<Node, Arc>(new Arc.ArcFactory());
        ArrayList tmp = new ArrayList(totalSizes);
        for (i = 0; i < totalSizes; ++i) {
            tmp.add(new HashSet());
        }
        ArrayList<TIntHashSet> layer = new ArrayList<TIntHashSet>();
        TIntHashSet[] tmpQ = new TIntHashSet[totalSizes];
        for (i = 0; i <= n; ++i) {
            layer.add(new TIntHashSet());
        }
        ((TIntHashSet)layer.get(0)).add(this.pi.getInitialState());
        TIntHashSet nexts = new TIntHashSet();
        for (i = 0; i < n; ++i) {
            int UB = this.vs[i].getUB();
            j = this.vs[i].getLB();
            while (j <= UB) {
                layerIter = ((TIntHashSet)layer.get(i)).iterator();
                while (layerIter.hasNext()) {
                    k = layerIter.next();
                    nexts.clear();
                    this.pi.delta(k, j, nexts);
                    TIntIterator it = nexts.iterator();
                    while (it.hasNext()) {
                        int succ = it.next();
                        ((TIntHashSet)layer.get(i + 1)).add(succ);
                    }
                    if (nexts.isEmpty()) continue;
                    int idx = starts[i] + j - offsets[i];
                    if (tmpQ[idx] == null) {
                        tmpQ[idx] = new TIntHashSet();
                    }
                    tmpQ[idx].add(k);
                }
                j = this.vs[i].nextValue(j);
            }
        }
        layerIter = ((TIntHashSet)layer.get(n)).iterator();
        while (layerIter.hasNext()) {
            k = layerIter.next();
            if (this.pi.isFinal(k)) continue;
            layerIter.remove();
        }
        int nbNodes = this.pi.getNbStates();
        BitSet mark = new BitSet(nbNodes);
        Node[] in = new Node[this.pi.getNbStates() * (n + 1)];
        Node tink = new Node(this.pi.getNbStates() + 1, n + 1, nid++);
        graph.addVertex(tink);
        for (i = n - 1; i >= 0; --i) {
            mark.clear(0, nbNodes);
            int UB = this.vs[i].getUB();
            j = this.vs[i].getLB();
            while (j <= UB) {
                int idx = starts[i] + j - offsets[i];
                TIntHashSet l = tmpQ[idx];
                if (l != null) {
                    TIntIterator qijIter = l.iterator();
                    while (qijIter.hasNext()) {
                        void var14_23;
                        k = var14_23.next();
                        nexts.clear();
                        this.pi.delta(k, j, nexts);
                        if (nexts.size() > 1) {
                            System.err.println("STOP");
                        }
                        boolean added = false;
                        TIntIterator it = nexts.iterator();
                        while (it.hasNext()) {
                            Node b;
                            int qn = it.next();
                            if (!((TIntHashSet)layer.get(i + 1)).contains(qn)) continue;
                            added = true;
                            Node a = in[i * this.pi.getNbStates() + k];
                            if (a == null) {
                                in[i * this.pi.getNbStates() + k] = a = new Node(k, i, nid++);
                                graph.addVertex(a);
                            }
                            if ((b = in[(i + 1) * this.pi.getNbStates() + qn]) == null) {
                                in[(i + 1) * this.pi.getNbStates() + qn] = b = new Node(qn, i + 1, nid++);
                                graph.addVertex(b);
                            }
                            Arc arc = new Arc(a, b, j, aid++);
                            graph.addEdge(a, b, arc);
                            ((HashSet)tmp.get(idx)).add(arc);
                            mark.set(k);
                        }
                        if (added) continue;
                        var14_23.remove();
                    }
                }
                j = this.vs[i].nextValue(j);
            }
            layerIter = ((TIntHashSet)layer.get(i)).iterator();
            while (layerIter.hasNext()) {
                if (mark.get(layerIter.next())) continue;
                layerIter.remove();
            }
        }
        TIntHashSet th = new TIntHashSet();
        int[][] intLayer = new int[n + 2][];
        for (k = 0; k < this.pi.getNbStates(); ++k) {
            o = in[n * this.pi.getNbStates() + k];
            if (o == null) continue;
            Arc a = new Arc(o, tink, 0, aid++);
            graph.addEdge(o, tink, a);
        }
        for (i = 0; i <= n; ++i) {
            th.clear();
            for (k = 0; k < this.pi.getNbStates(); ++k) {
                o = in[i * this.pi.getNbStates() + k];
                if (o == null) continue;
                th.add(o.id);
            }
            intLayer[i] = th.toArray();
        }
        intLayer[n + 1] = new int[]{tink.id};
        if (intLayer[0].length > 0) {
            IEnvironment environment = this.solver.getEnvironment();
            this.graph = new StoredDirectedMultiGraph(environment, graph, intLayer, starts, offsets, totalSizes, this.pi, this.z);
            this.graph.makePathFinder();
        }
    }

    private void filter() throws ContradictionException {
        this.checkWorld();
        this.delayedBoundUpdate();
        this.delayedGraphUpdate();
        this.modifiedBound[0] = true;
        this.modifiedBound[1] = true;
        this.computeSharpBounds();
        assert (this.toRemove.size() == 0);
        assert (this.check());
        assert (this.isGraphConsistent());
    }

    protected void updateUpperBound() throws ContradictionException {
        int[] P;
        double lp;
        double coeff;
        boolean modif;
        int k = 0;
        double bk = 0.7;
        int nbNSig = 0;
        int nbNSig2 = 0;
        double bestVal = Double.POSITIVE_INFINITY;
        do {
            coeff = 0.0;
            for (int i = 0; i < this.nbR; ++i) {
                coeff += this.uUb[i] * (double)this.z[i + 1].getUB();
                coeff -= this.uUb[i + this.nbR] * (double)this.z[i + 1].getLB();
            }
            modif = false;
            this.slp.computeLongestPath(this.toRemove, (double)this.z[0].getLB() - coeff, this.uUb, true, true, 0, this);
            lp = this.slp.getLongestPathValue();
            P = this.slp.getLongestPath();
            this.filterUp(lp + coeff);
            if (bestVal - (lp + coeff) < 0.5) {
                ++nbNSig;
                ++nbNSig2;
            } else {
                nbNSig = 0;
                nbNSig2 = 0;
            }
            if (nbNSig == 3) {
                bk *= 0.8;
                nbNSig = 0;
            }
            if (lp + coeff < bestVal) {
                bestVal = lp + coeff;
            }
            double uk = 10.0 * Math.pow(bk, k);
            for (int l = 0; l < this.uUb.length / 2; ++l) {
                double axu = 0.0;
                for (int e : P) {
                    int i = this.graph.GNodes.layers[this.graph.GArcs.origs[e]];
                    if (i >= this.offset) continue;
                    axu += this.graph.GArcs.originalCost[e][l + 1];
                }
                double newLB = Math.max(this.uUb[l] - uk * ((double)this.z[l + 1].getUB() - axu), 0.0);
                double newLA = Math.max(this.uUb[l + this.nbR] - uk * (axu - (double)this.z[l + 1].getLB()), 0.0);
                if (Math.abs(this.uUb[l] - newLB) >= this._MCR_DECIMAL_PREC) {
                    this.uUb[l] = newLB;
                    modif = true;
                }
                if (!(Math.abs(this.uUb[l + this.nbR] - newLA) >= this._MCR_DECIMAL_PREC)) continue;
                this.uUb[l + this.nbR] = newLA;
                modif = true;
            }
        } while (modif && nbNSig2 < 15 && ++k < 10);
        this.lastLp = P;
        this.lastLpValue = lp + coeff;
    }

    protected void updateLowerBound() throws ContradictionException {
        boolean modif;
        int k = 0;
        double bk = 0.7;
        double bestVal = Double.NEGATIVE_INFINITY;
        int nbNSig = 0;
        int nbNSig2 = 0;
        int[] bestPath = new int[this.offset + 1];
        do {
            double coeff = 0.0;
            for (int i = 0; i < this.nbR; ++i) {
                coeff += this.uLb[i] * (double)this.z[i + 1].getUB();
                coeff -= this.uLb[i + this.nbR] * (double)this.z[i + 1].getLB();
            }
            modif = false;
            this.slp.computeShortestPath(this.toRemove, (double)this.z[0].getUB() + coeff, this.uLb, true, false, 0, this);
            double sp = this.slp.getShortestPathValue();
            int[] P = this.slp.getShortestPath();
            this.filterDown(sp - coeff);
            if (sp - coeff - bestVal < 0.5) {
                ++nbNSig;
                ++nbNSig2;
            } else {
                nbNSig = 0;
                nbNSig2 = 0;
            }
            if (nbNSig == 3) {
                bk *= 0.8;
                nbNSig = 0;
            }
            if (sp - coeff > bestVal) {
                bestVal = sp - coeff;
                System.arraycopy(P, 0, bestPath, 0, P.length);
            }
            double uk = 10.0 * Math.pow(bk, k);
            for (int l = 0; l < this.uLb.length / 2; ++l) {
                double axu = 0.0;
                for (int e : P) {
                    int i = this.graph.GNodes.layers[this.graph.GArcs.origs[e]];
                    if (i >= this.offset) continue;
                    axu += this.graph.GArcs.originalCost[e][l + 1];
                }
                double newLB = Math.max(this.uLb[l] + uk * (axu - (double)this.z[l + 1].getUB()), 0.0);
                double newLA = Math.max(this.uLb[l + this.nbR] + uk * ((double)this.z[l + 1].getLB() - axu), 0.0);
                if (Math.abs(this.uLb[l] - newLB) >= this._MCR_DECIMAL_PREC) {
                    this.uLb[l] = newLB;
                    modif = true;
                }
                if (!(Math.abs(this.uLb[l + this.nbR] - newLA) >= this._MCR_DECIMAL_PREC)) continue;
                this.uLb[l + this.nbR] = newLA;
                modif = true;
            }
        } while (modif && nbNSig2 < 15 && ++k < 10);
        this.lastSp = bestPath;
        this.lastSpValue = bestVal;
    }

    protected boolean prefilter() throws ContradictionException {
        FastPathFinder p = this.graph.getPathFinder();
        boolean cont = true;
        while (cont) {
            boolean[] modified = p.computeShortestAndLongestPath(this.toRemove, this.z, this);
            cont = this.toRemove.size() > 0;
            this.modifiedBound[0] = this.modifiedBound[0] | modified[0];
            this.modifiedBound[1] = this.modifiedBound[1] | modified[1];
            this.delayedGraphUpdate();
        }
        return this.modifiedBound[0] || this.modifiedBound[1];
    }

    protected void filterDown(double realsp) throws ContradictionException {
        if (realsp - (double)this.z[0].getUB() >= this._MCR_DECIMAL_PREC) {
            this.contradiction(null, "cost variable domain is emptied");
        }
        if (realsp - (double)this.z[0].getLB() >= this._MCR_DECIMAL_PREC) {
            double mr = Math.round(realsp);
            double rsp = realsp - mr <= this._MCR_DECIMAL_PREC ? mr : realsp;
            this.z[0].updateLowerBound((int)Math.ceil(rsp), this.aCause);
            this.modifiedBound[0] = true;
        }
    }

    protected void filterUp(double reallp) throws ContradictionException {
        if (reallp - (double)this.z[0].getLB() <= -this._MCR_DECIMAL_PREC) {
            this.contradiction(null, "cost variable domain is emptied");
        }
        if (reallp - (double)this.z[0].getUB() <= -this._MCR_DECIMAL_PREC) {
            double mr = Math.round(reallp);
            double rsp = reallp - mr <= this._MCR_DECIMAL_PREC ? mr : reallp;
            this.z[0].updateUpperBound((int)Math.floor(rsp), this.aCause);
            this.modifiedBound[1] = true;
        }
    }

    protected void checkWorld() throws ContradictionException {
        int currentworld = this.solver.getEnvironment().getWorldIndex();
        long currentbt = this.solver.getMeasures().getBackTrackCount();
        long currentrestart = this.solver.getMeasures().getRestartCount();
        if (currentworld < this.lastWorld || currentbt != this.lastNbOfBacktracks || currentrestart > this.lastNbOfRestarts) {
            for (int i = 0; i <= this.nbR; ++i) {
                this.toUpdateLeft[i].clear();
                this.toUpdateRight[i].clear();
            }
            this.toRemove.clear();
            this.graph.inStack.clear();
            this.getGraph().getPathFinder().computeShortestAndLongestPath(this.toRemove, this.z, this);
            this.computed = true;
        }
        this.lastWorld = currentworld;
        this.lastNbOfBacktracks = currentbt;
        this.lastNbOfRestarts = currentrestart;
    }

    protected void delayedGraphUpdate() throws ContradictionException {
        try {
            while (true) {
                if (this.toRemove.size() > 0) {
                    int n = this.toRemove.pop();
                    this.graph.removeArc(n, this.toRemove, this.toUpdateLeft, this.toUpdateRight, this);
                    continue;
                }
                for (int k = 0; k <= this.nbR; ++k) {
                    while (this.toUpdateLeft[k].size() > 0) {
                        this.graph.updateLeft(this.toUpdateLeft[k], this.toRemove, k, this.modifiedBound, this);
                        if (this.toRemove.size() <= 0) continue;
                    }
                    while (this.toUpdateRight[k].size() > 0) {
                        this.graph.updateRight(this.toUpdateRight[k], this.toRemove, k, this.modifiedBound, this);
                        if (this.toRemove.size() <= 0) continue;
                    }
                }
                if (this.toRemove.size() <= 0) break;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void computeSharpBounds() throws ContradictionException {
        while (this.modifiedBound[0] || this.modifiedBound[1]) {
            if (this.modifiedBound[1]) {
                this.modifiedBound[1] = false;
                this.updateLowerBound();
            }
            if (this.modifiedBound[0]) {
                this.modifiedBound[0] = false;
                this.updateUpperBound();
            }
            this.delayedGraphUpdate();
        }
    }

    private boolean remContains(int e) {
        int[] element = this.toRemove.toArray();
        for (int i = 0; i < this.toRemove.size(); ++i) {
            if (element[i] != e) continue;
            return true;
        }
        return false;
    }

    private void checkBounds() throws ContradictionException {
        List<ICounter> counters = this.pi.getCounters();
        int nbCounters = this.pi.getNbResources();
        for (int i = 0; i < nbCounters; ++i) {
            IntVar z = this.z[i];
            Bounds bounds = counters.get(i).bounds();
            z.updateLowerBound(bounds.min.value, this.aCause);
            z.updateUpperBound(bounds.max.value, this.aCause);
        }
    }

    private void delayedBoundUpdate() throws ContradictionException {
        if (!this.computed && this.boundUpdate.size() > 0) {
            this.getGraph().delayedBoundUpdate(this.toRemove, this.z, this.boundUpdate.toArray());
            this.boundUpdate.clear();
        }
    }

    public void rebuildCostRegInfo() throws ContradictionException {
        this.checkWorld();
    }

    public final boolean needPropagation() {
        int currentworld = this.solver.getEnvironment().getWorldIndex();
        long currentbt = this.solver.getMeasures().getBackTrackCount();
        long currentrestart = this.solver.getMeasures().getRestartCount();
        return currentworld < this.lastWorld || currentbt != this.lastNbOfBacktracks || currentrestart > this.lastNbOfRestarts;
    }

    public boolean isGraphConsistent() {
        for (int i = 0; i < this.offset; ++i) {
            DisposableIntIterator iter = this.graph.layers[i].getIterator();
            while (iter.hasNext()) {
                int n = iter.next();
                DisposableIntIterator it = this.graph.GNodes.outArcs[n].getIterator();
                while (it.hasNext()) {
                    int arc = it.next();
                    int val = this.graph.GArcs.values[arc];
                    if (((IntVar[])this.vars)[i].contains(val)) continue;
                    System.err.println("Arc " + arc + " from node " + n + " to node" + this.graph.GArcs.dests[arc] + " with value " + val + " in layer " + i + " should not be here");
                    return false;
                }
            }
            iter.dispose();
        }
        return true;
    }

    public final StoredDirectedMultiGraph getGraph() {
        return this.graph;
    }

    public final int getRegret(int layer, int value, int ... resources) {
        return this.graph.getRegret(layer, value, resources);
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            return ESat.eval(this.isSatisfied());
        }
        return ESat.UNDEFINED;
    }

    public boolean isSatisfied() {
        for (IntVar var : (IntVar[])this.vars) {
            if (var.isInstantiated()) continue;
            return false;
        }
        return this.check();
    }

    public boolean isSatisfied(int[] word) {
        int[] first = new int[this.offset];
        System.arraycopy(word, 0, first, 0, first.length);
        return this.check(first);
    }

    public boolean check(int[] word) {
        if (!this.pi.run(word)) {
            System.err.println("Word is not accepted by the automaton");
            System.err.print("{" + word[0]);
            for (int i = 1; i < word.length; ++i) {
                System.err.print("," + word[i]);
            }
            System.err.println("}");
            return false;
        }
        int[] gcost = new int[this.z.length];
        for (int l = 0; l < this.graph.layers.length - 2; ++l) {
            DisposableIntIterator it = this.graph.layers[l].getIterator();
            while (it.hasNext()) {
                int orig = it.next();
                DisposableIntIterator arcIter = this.graph.GNodes.outArcs[orig].getIterator();
                while (arcIter.hasNext()) {
                    int arc = arcIter.next();
                    for (int i = 0; i < this.z.length; ++i) {
                        int n = i;
                        gcost[n] = (int)((double)gcost[n] + this.graph.GArcs.originalCost[arc][i]);
                    }
                }
                arcIter.dispose();
            }
            it.dispose();
        }
        for (int i = 0; i < gcost.length; ++i) {
            if (!this.z[i].isInstantiated()) {
                LOGGER.error("z[" + i + "] in MCR should be instantiated : " + this.z[i]);
                return false;
            }
            if (this.z[i].getValue() == gcost[i]) continue;
            LOGGER.error("cost: " + gcost[i] + " != z:" + this.z[i].getValue());
            return false;
        }
        return true;
    }

    public boolean check() {
        int[] word = new int[this.offset];
        for (int i = 0; i < this.offset; ++i) {
            if (!this.vs[i].isInstantiated()) {
                return true;
            }
            word[i] = this.vs[i].getValue();
        }
        for (IntVar aZ : this.z) {
            if (aZ.isInstantiated()) continue;
            return true;
        }
        return this.check(word);
    }

    public int getMinPathCostForAssignment(int col, int val, int ... resources) {
        return this.graph.getMinPathCostForAssignment(col, val, resources);
    }

    public int[] getMinMaxPathCostForAssignment(int col, int val, int ... resources) {
        return this.graph.getMinMaxPathCostForAssignment(col, val, resources);
    }

    public int getMinPathCost(int ... resources) {
        return this.graph.getMinPathCost(resources);
    }

    public double[] getInstantiatedLayerCosts(int layer) {
        return this.graph.getInstantiatedLayerCosts(layer);
    }

    public void forcePathRecomputation() throws ContradictionException {
        this.lastWorld = Integer.MAX_VALUE;
        this.checkWorld();
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            IntVar[] aVars = new IntVar[this.vs.length];
            for (int i = 0; i < this.vs.length; ++i) {
                this.vs[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(this.vs[i]);
            }
            IntVar[] cVars = new IntVar[this.z.length];
            for (int i = 0; i < this.z.length; ++i) {
                this.z[i].duplicate(solver, identitymap);
                cVars[i] = (IntVar)identitymap.get(this.z[i]);
            }
            ICostAutomaton nauto = null;
            try {
                nauto = (ICostAutomaton)this.pi.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            identitymap.put(this, new PropMultiCostRegular(aVars, cVars, nauto));
        }
    }

    private static class RemProc
    implements UnaryIntProcedure<Integer> {
        private final PropMultiCostRegular p;
        private int idxVar;

        public RemProc(PropMultiCostRegular p) {
            this.p = p;
        }

        @Override
        public UnaryIntProcedure set(Integer idxVar) {
            this.idxVar = idxVar;
            return this;
        }

        @Override
        public void execute(int i) throws ContradictionException {
            StoredIndexedBipartiteSetWithOffset support = this.p.graph.getUBport(this.idxVar, i);
            if (support != null) {
                int[] list = support._getStructure();
                int size = support.size();
                for (int j = 0; j < size; ++j) {
                    int e = list[j];
                    assert (this.p.graph.isInStack(e) == this.p.remContains(e));
                    if (this.p.graph.isInStack(e)) continue;
                    this.p.graph.setInStack(e);
                    this.p.toRemove.push(e);
                }
            }
        }
    }
}

