/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.automata;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.automata.FA.IAutomaton;
import org.chocosolver.solver.constraints.nary.automata.structure.Node;
import org.chocosolver.solver.constraints.nary.automata.structure.regular.Arc;
import org.chocosolver.solver.constraints.nary.automata.structure.regular.StoredDirectedMultiGraph;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.UnaryIntProcedure;
import org.jgrapht.graph.DirectedMultigraph;

public class PropRegular
extends Propagator<IntVar> {
    StoredDirectedMultiGraph graph;
    final IAutomaton automaton;
    static int num;
    int _num = num++;
    protected final RemProc rem_proc;
    protected final IIntDeltaMonitor[] idms = new IIntDeltaMonitor[((IntVar[])this.vars).length];

    public PropRegular(IntVar[] variables, IAutomaton automaton) {
        super((Variable[])variables, PropagatorPriority.LINEAR, true);
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            this.idms[i] = ((IntVar[])this.vars)[i].monitorDelta(this);
        }
        this.rem_proc = new RemProc(this);
        this.automaton = automaton;
        this.graph = PropRegular.initGraph(this.solver.getEnvironment(), (IntVar[])this.vars, automaton);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        for (int i = 0; i < this.idms.length; ++i) {
            this.idms[i].freeze();
            this.idms[i].forEachRemVal(this.rem_proc.set(i));
            int j = ((IntVar[])this.vars)[i].getLB();
            while (j <= ((IntVar[])this.vars)[i].getUB()) {
                if (!this.graph.hasSupport(i, j)) {
                    ((IntVar[])this.vars)[i].removeValue(j, this.aCause);
                }
                j = ((IntVar[])this.vars)[i].nextValue(j);
            }
            this.idms[i].unfreeze();
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        this.idms[varIdx].freeze();
        this.idms[varIdx].forEachRemVal(this.rem_proc.set(varIdx));
        this.idms[varIdx].unfreeze();
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            int[] str = new int[((IntVar[])this.vars).length];
            for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
                str[i] = ((IntVar[])this.vars)[i].getValue();
            }
            return ESat.eval(this.automaton.run(str));
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("Regular").append("(");
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            IntVar var = ((IntVar[])this.vars)[i];
            sb.append(var.getName());
        }
        sb.append(")");
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static StoredDirectedMultiGraph initGraph(IEnvironment environment, IntVar[] vars, IAutomaton auto) {
        int k;
        TIntIterator layerIter;
        int j;
        int i;
        int aid = 0;
        int nid = 0;
        int[] offsets = new int[vars.length];
        int[] sizes = new int[vars.length];
        int[] starts = new int[vars.length];
        int totalSizes = 0;
        starts[0] = 0;
        for (int i2 = 0; i2 < vars.length; ++i2) {
            offsets[i2] = vars[i2].getLB();
            sizes[i2] = vars[i2].getUB() - vars[i2].getLB() + 1;
            if (i2 > 0) {
                starts[i2] = sizes[i2 - 1] + starts[i2 - 1];
            }
            totalSizes += sizes[i2];
        }
        int n = vars.length;
        DirectedMultigraph<Node, Arc> graph = new DirectedMultigraph<Node, Arc>(new Arc.ArcFactory());
        ArrayList tmp = new ArrayList(totalSizes);
        for (i = 0; i < totalSizes; ++i) {
            tmp.add(new HashSet());
        }
        TIntHashSet[] layer = new TIntHashSet[n + 1];
        TIntHashSet[] tmpQ = new TIntHashSet[totalSizes];
        for (i = 0; i <= n; ++i) {
            layer[i] = new TIntHashSet();
        }
        layer[0].add(auto.getInitialState());
        TIntHashSet nexts = new TIntHashSet();
        for (i = 0; i < n; ++i) {
            int ub = vars[i].getUB();
            j = vars[i].getLB();
            while (j <= ub) {
                layerIter = layer[i].iterator();
                while (layerIter.hasNext()) {
                    k = layerIter.next();
                    nexts.clear();
                    auto.delta(k, j, nexts);
                    TIntIterator it = nexts.iterator();
                    while (it.hasNext()) {
                        int succ = it.next();
                        layer[i + 1].add(succ);
                    }
                    if (nexts.isEmpty()) continue;
                    int idx = starts[i] + j - offsets[i];
                    if (tmpQ[idx] == null) {
                        tmpQ[idx] = new TIntHashSet();
                    }
                    tmpQ[idx].add(k);
                }
                j = vars[i].nextValue(j);
            }
        }
        layerIter = layer[n].iterator();
        while (layerIter.hasNext()) {
            k = layerIter.next();
            if (auto.isFinal(k)) continue;
            layerIter.remove();
        }
        int nbNodes = auto.getNbStates();
        BitSet mark = new BitSet(nbNodes);
        Node[] in = new Node[auto.getNbStates() * (n + 1)];
        for (i = n - 1; i >= 0; --i) {
            mark.clear(0, nbNodes);
            int ub = vars[i].getUB();
            j = vars[i].getLB();
            while (j <= ub) {
                int idx = starts[i] + j - offsets[i];
                TIntHashSet l = tmpQ[idx];
                if (l != null) {
                    TIntIterator qijIter = l.iterator();
                    while (qijIter.hasNext()) {
                        void var16_25;
                        k = var16_25.next();
                        nexts.clear();
                        auto.delta(k, j, nexts);
                        boolean added = false;
                        TIntIterator it = nexts.iterator();
                        while (it.hasNext()) {
                            Node b;
                            int qn = it.next();
                            if (!layer[i + 1].contains(qn)) continue;
                            added = true;
                            Node a = in[i * auto.getNbStates() + k];
                            if (a == null) {
                                in[i * auto.getNbStates() + k] = a = new Node(k, i, nid++);
                                graph.addVertex(a);
                            }
                            if ((b = in[(i + 1) * auto.getNbStates() + qn]) == null) {
                                in[(i + 1) * auto.getNbStates() + qn] = b = new Node(qn, i + 1, nid++);
                                graph.addVertex(b);
                            }
                            Arc arc = new Arc(a, b, j, aid++);
                            graph.addEdge(a, b, arc);
                            ((HashSet)tmp.get(idx)).add(arc);
                            mark.set(k);
                        }
                        if (added) continue;
                        var16_25.remove();
                    }
                }
                j = vars[i].nextValue(j);
            }
            layerIter = layer[i].iterator();
            while (layerIter.hasNext()) {
                if (mark.get(layerIter.next())) continue;
                layerIter.remove();
            }
        }
        return new StoredDirectedMultiGraph(environment, graph, starts, offsets, totalSizes);
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            IntVar[] aVars = new IntVar[((IntVar[])this.vars).length];
            for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                aVars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            IAutomaton nauto = null;
            try {
                nauto = this.automaton.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            identitymap.put(this, new PropRegular(aVars, nauto));
        }
    }

    private static class RemProc
    implements UnaryIntProcedure<Integer> {
        private final PropRegular p;
        private int idxVar;

        public RemProc(PropRegular p) {
            this.p = p;
        }

        @Override
        public UnaryIntProcedure set(Integer idxVar) {
            this.idxVar = idxVar;
            return this;
        }

        @Override
        public void execute(int i) throws ContradictionException {
            this.p.graph.clearSupports(this.idxVar, i, this.p);
        }
    }
}

